/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertUnsafeCastToUnsafeCastCallIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class ConvertUnsafeCastToUnsafeCastCallIntention
extends SelfTargetingIntention<KtBinaryExpressionWithTypeRHS> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpressionWithTypeRHS element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!JsPlatformKt.isJs((TargetPlatform)PlatformKt.getPlatform((KtElement)element3))) {
            return false;
        }
        if (Intrinsics.areEqual((Object)element3.getOperationReference().getReferencedNameElementType(), (Object)KtTokens.AS_KEYWORD) ^ true) {
            return false;
        }
        KtTypeReference ktTypeReference = element3.getRight();
        if (ktTypeReference == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"element.right ?: return false");
        KtTypeReference right2 = ktTypeReference;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)right2), (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)right2);
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context[BindingContext.T\u2026E, right] ?: return false");
        KotlinType type2 = kotlinType;
        if (TypeUtils.isNullableType((KotlinType)type2)) {
            return false;
        }
        Object[] objectArray = new Object[2];
        KtExpression ktExpression = element3.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.left");
        String string = ktExpression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.left.text");
        objectArray[0] = string;
        String string2 = right2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"right.text");
        objectArray[1] = string2;
        this.setTextGetter(KotlinBundle.lazyMessage("convert.to.0.unsafecast.1", objectArray));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpressionWithTypeRHS element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getRight();
        if (ktTypeReference == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"element.right ?: return");
        KtTypeReference right2 = ktTypeReference;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
        Object[] objectArray = new Object[2];
        KtExpression ktExpression = element3.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.left");
        objectArray[0] = ktExpression;
        objectArray[1] = right2;
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0.unsafeCast<$1>()", (Object[])objectArray, (boolean)false, (int)4, null);
        element3.replace((PsiElement)newExpression2);
    }

    public ConvertUnsafeCastToUnsafeCastCallIntention() {
        super(KtBinaryExpressionWithTypeRHS.class, KotlinBundle.lazyMessage("convert.to.unsafecast.call", new Object[0]), null, 4, null);
    }
}

