/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "caretOffset", "", "findChildBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Companion", "kotlin.idea"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final KtBlockExpression findChildBlock(KtElement $this$findChildBlock) {
        KtBlockExpression ktBlockExpression;
        KtElement ktElement = $this$findChildBlock;
        if (ktElement instanceof KtBlockExpression) {
            ktBlockExpression = (KtBlockExpression)$this$findChildBlock;
        } else if (ktElement instanceof KtLoopExpression) {
            KtExpression ktExpression = ((KtLoopExpression)$this$findChildBlock).getBody();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else if (ktElement instanceof KtWhenEntry) {
            KtExpression ktExpression = ((KtWhenEntry)$this$findChildBlock).getExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else {
            ktBlockExpression = null;
        }
        return ktBlockExpression;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        block4: {
            PsiElement container2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
                if (ktBlockExpression == null) {
                    return false;
                }
                KtBlockExpression block2 = ktBlockExpression;
                if (!Companion.isApplicableTo(block2)) {
                    return false;
                }
                container2 = block2.getParent();
                if (!(container2 instanceof KtContainerNode)) break block3;
                String string = UtilsKt.description((KtContainerNode)container2);
                if (string == null) {
                    return false;
                }
                String description2 = string;
                this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.0.statement", description2));
                break block4;
            }
            if (!(container2 instanceof KtWhenEntry)) break block4;
            this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.when.entry", new Object[0]));
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block2 = ktBlockExpression;
        Companion.removeBraces(element3, block2, editor2);
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return !(element3 instanceof KtBlockExpression) || ((KtBlockExpression)element3).getParent() instanceof KtWhenEntry;
    }

    public RemoveBracesIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage("remove.braces", new Object[0]), null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveBracesIntention$Companion;", "", "()V", "handleComments", "", "construct", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isApplicableTo", "", "removeBraces", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
    public static final class Companion {
        public final boolean isApplicableTo(@NotNull KtBlockExpression block2) {
            PsiElement container2;
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
            List list2 = block2.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
            if (ktExpression == null) {
                return false;
            }
            KtExpression singleStatement = ktExpression;
            if (singleStatement instanceof KtLambdaExpression) {
                KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)singleStatement).getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"singleStatement.functionLiteral");
                if (ktFunctionLiteral.getArrow() == null) {
                    return false;
                }
            }
            if ((container2 = block2.getParent()) instanceof KtContainerNode) {
                if (singleStatement instanceof KtProperty || singleStatement instanceof KtClass) {
                    return false;
                }
                if (singleStatement instanceof KtIfExpression) {
                    KtExpression elseExpression2;
                    PsiElement psiElement2 = ((KtContainerNode)container2).getParent();
                    if (!(psiElement2 instanceof KtIfExpression)) {
                        psiElement2 = null;
                    }
                    KtIfExpression ktIfExpression = (KtIfExpression)psiElement2;
                    Object object = elseExpression2 = ktIfExpression != null ? ktIfExpression.getElse() : null;
                    if (elseExpression2 != null && Intrinsics.areEqual((Object)elseExpression2, (Object)block2) ^ true) {
                        return false;
                    }
                }
                return true;
            }
            if (container2 instanceof KtWhenEntry) {
                return !(singleStatement instanceof KtNamedDeclaration);
            }
            return false;
        }

        public final void removeBraces(@NotNull KtElement element3, @NotNull KtBlockExpression block2, @Nullable Editor editor2) {
            block16: {
                PsiElement container2;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
                List list2 = block2.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
                KtExpression statement = (KtExpression)CollectionsKt.single((List)list2);
                if (editor2 != null) {
                    CaretModel caretModel = editor2.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                    int n = caretModel.getOffset();
                    KtExpression ktExpression = statement;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"statement");
                    bl = n >= PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression));
                } else {
                    bl = false;
                }
                boolean caretOnAfterStatement = bl;
                PsiElement psiElement2 = container2 = block2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"container");
                PsiElement psiElement3 = psiElement2.getParent();
                if (psiElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                KtExpression construct = (KtExpression)psiElement3;
                this.handleComments(construct, block2);
                PsiElement newElement2 = block2.replace(statement.copy());
                Editor editor3 = editor2;
                if (editor3 != null && (editor3 = editor3.getCaretModel()) != null) {
                    int n;
                    if (caretOnAfterStatement) {
                        PsiElement psiElement4 = newElement2;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"newElement");
                        n = PsiUtilsKt.getEndOffset((PsiElement)psiElement4);
                    } else {
                        PsiElement psiElement5 = newElement2;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"newElement");
                        n = PsiUtilsKt.getStartOffset((PsiElement)psiElement5);
                    }
                    editor3.moveToOffset(n);
                }
                if (construct instanceof KtDoWhileExpression) {
                    PsiElement psiElement6 = newElement2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"newElement");
                    PsiElement psiElement7 = psiElement6.getParent();
                    Intrinsics.checkNotNull((Object)psiElement7);
                    psiElement7.addAfter(factory2.createNewLine(), newElement2);
                } else if (editor2 != null) {
                    Document document = editor2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    Document document2 = document;
                    PsiElement psiElement8 = newElement2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement8, (String)"newElement");
                    int line = document2.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)psiElement8));
                    int rightMargin = editor2.getSettings().getRightMargin(editor2.getProject());
                    if (document2.getLineEndOffset(line) - document2.getLineStartOffset(line) >= rightMargin) {
                        newElement2.getParent().addBefore(factory2.createNewLine(), newElement2);
                    }
                }
                if (!(construct instanceof KtIfExpression)) break block16;
                ASTNode aSTNode = container2.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"container.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.ELSE) && ((KtIfExpression)construct).getParent() instanceof KtExpression && !(((KtIfExpression)construct).getParent() instanceof KtStatementExpression)) {
                    KtIfExpression ktIfExpression;
                    PsiElement replaced2 = ((KtIfExpression)construct).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0)", (Object[])new Object[]{construct}, (boolean)false, (int)4, null));
                    PsiElement psiElement9 = replaced2.getChildren()[0];
                    if (!(psiElement9 instanceof KtIfExpression)) {
                        psiElement9 = null;
                    }
                    if ((ktIfExpression = (KtIfExpression)psiElement9) != null && (ktIfExpression = ktIfExpression.getElse()) != null) {
                        KtIfExpression ktIfExpression2 = ktIfExpression;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        KtIfExpression it = ktIfExpression2;
                        boolean bl4 = false;
                        Editor editor4 = editor2;
                        if (editor4 != null && (editor4 = editor4.getCaretModel()) != null) {
                            int n;
                            if (caretOnAfterStatement) {
                                KtIfExpression ktIfExpression3 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)ktIfExpression3, (String)"it");
                                n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktIfExpression3));
                            } else {
                                KtIfExpression ktIfExpression4 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)ktIfExpression4, (String)"it");
                                n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktIfExpression4));
                            }
                            editor4.moveToOffset(n);
                        }
                    }
                }
            }
        }

        public static /* synthetic */ void removeBraces$default(Companion companion, KtElement ktElement, KtBlockExpression ktBlockExpression, Editor editor2, int n, Object object) {
            if ((n & 4) != 0) {
                editor2 = null;
            }
            companion.removeBraces(ktElement, ktBlockExpression, editor2);
        }

        private final void handleComments(KtExpression construct, KtBlockExpression block2) {
            PsiElement sibling;
            PsiElement psiElement2 = block2.getFirstChild();
            Object object = sibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
            while (sibling != null) {
                if (sibling instanceof PsiComment) {
                    KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)construct), (boolean)false, (int)2, null);
                    if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                        PsiElement psiElement3 = construct.getPrevSibling();
                        Intrinsics.checkNotNull((Object)psiElement3);
                        psiElement3.replace(psiFactory.createNewLine());
                    }
                    PsiElement commentElement = construct.getParent().addBefore(sibling, construct.getPrevSibling());
                    construct.getParent().addBefore(psiFactory.createNewLine(), commentElement);
                }
                sibling = sibling.getNextSibling();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

