/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "className", "", "smartPsiElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getClassName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "kotlin.maven"})
public final class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    @NotNull
    private final String className;
    private final SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer;

    @NotNull
    public String getText() {
        return KotlinMavenBundle.message("fix.add.maven.dependency.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiElement psiElement2 = this.smartPsiElementPointer.getElement();
        boolean bl = false;
        boolean bl2 = false;
        KtSimpleNameExpression it = (KtSimpleNameExpression)psiElement2;
        boolean bl3 = false;
        return it != null && it.isValid() && file2 != null && MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file2)) != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (editor2 == null || file2 == null) {
            return;
        }
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file2));
        if (mavenProject == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"MavenDomUtil.findContainingProject(file) ?: return");
        MavenProject mavenProject2 = mavenProject;
        PsiFile psiFile3 = PsiManager.getInstance((Project)project2).findFile(mavenProject2.getFile());
        if (!(psiFile3 instanceof XmlFile)) {
            psiFile3 = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile3;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        List list2 = MavenArtifactSearchDialog.searchForClass((Project)project2, (String)this.className);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"MavenArtifactSearchDialo\u2026Class(project, className)");
        List ids = list2;
        if (ids.isEmpty()) {
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(project2, virtualFile3, xmlFile2, ids){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ XmlFile $xmlFile;
            final /* synthetic */ List $ids;

            @Nullable
            public final Unit invoke() {
                Unit unit;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                boolean isTestSource = FileIndexUtilsKt.isInTestSourceContentKotlinAware((FileIndex)projectFileIndex, this.$virtualFile);
                MavenArtifactScope scope2 = isTestSource ? MavenArtifactScope.TEST : null;
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.$xmlFile);
                if (pomFile != null) {
                    PomFile pomFile2 = pomFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    PomFile pom2 = pomFile2;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = this.$ids;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MavenId it = (MavenId)element$iv;
                        boolean bl4 = false;
                        MavenId mavenId = it;
                        Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"it");
                        PomFile.addDependency$default(pom2, mavenId, scope2, null, false, null, 28, null);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.$project = project2;
                this.$virtualFile = virtualFile2;
                this.$xmlFile = xmlFile;
                this.$ids = list2;
                super(0);
            }
        });
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public AddMavenDependencyQuickFix(@NotNull String className2, @NotNull SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter(smartPsiElementPointer, (String)"smartPsiElementPointer");
        this.className = className2;
        this.smartPsiElementPointer = smartPsiElementPointer;
    }
}

