/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.ConvertMemberToExtensionFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DeclarationCantBeInlinedFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class DeclarationCantBeInlinedFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final DeclarationCantBeInlinedFactory INSTANCE;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        if (!(psiElement2 instanceof KtNamedFunction)) {
            psiElement2 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
        if (ktNamedFunction == null) {
            return CollectionsKt.emptyList();
        }
        KtNamedFunction function2 = ktNamedFunction;
        KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)function2));
        if (ktClass2 == null) {
            return CollectionsKt.emptyList();
        }
        KtClass containingClass2 = ktClass2;
        boolean bl = false;
        List fixes2 = new ArrayList();
        if (containingClass2.isInterface()) {
            fixes2.add(new ConvertMemberToExtensionFix(function2));
        } else if (function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)function2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OPEN_KEYWORD");
            fixes2.add(new RemoveModifierFix(ktModifierListOwner, ktModifierKeywordToken, false));
        }
        return fixes2;
    }

    private DeclarationCantBeInlinedFactory() {
    }

    static {
        DeclarationCantBeInlinedFactory declarationCantBeInlinedFactory;
        INSTANCE = declarationCantBeInlinedFactory = new DeclarationCantBeInlinedFactory();
    }
}

