/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "Companion", "kotlin.idea"})
public final class ReplaceInfixOrOperatorCallFix
extends KotlinQuickFixAction<KtExpression> {
    private final boolean notNullNeeded;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("replace.with.safe.call1", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)file2), (boolean)false, (int)2, null);
            String elvis2 = ReplaceCallFixUtilsKt.elvisOrEmpty(element3, this.notNullNeeded);
            PsiElement replacement2 = null;
            Object object = element3;
            if (object instanceof KtArrayAccessExpression) {
                KtBinaryExpression assignment2;
                KtBinaryExpression ktBinaryExpression = assignment2 = KtPsiUtilKt.getAssignmentByLHS((KtExpression)element3);
                KtExpression right2 = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
                KtExpression ktExpression2 = ((KtArrayAccessExpression)element3).getArrayExpression();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.arrayExpression ?: return");
                KtExpression arrayExpression = ktExpression2;
                if (assignment2 != null) {
                    if (right2 == null) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = arrayExpression;
                    List list2 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.indexExpressions");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.1.INSTANCE, (int)30, null);
                    objectArray[2] = right2;
                    KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0?.set($1, $2)", (Object[])objectArray, (boolean)false, (int)4, null);
                    assignment2.replace((PsiElement)newExpression2);
                } else {
                    String string = "$0?.get($1)" + elvis2;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = arrayExpression;
                    List list3 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"element.indexExpressions");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.2.INSTANCE, (int)30, null);
                    KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
                    replacement2 = ((KtArrayAccessExpression)element3).replace((PsiElement)newExpression3);
                }
            } else if (object instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element3).getCalleeExpression();
                if (ktExpression3 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"element.calleeExpression ?: return");
                KtExpression calleeExpression2 = ktExpression3;
                Object object2 = ((KtCallExpression)element3).getValueArgumentList();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    return;
                }
                Object valueArgumentList2 = object2;
                PsiElement psiElement2 = ((KtCallExpression)element3).getParent();
                if (!(psiElement2 instanceof KtQualifiedExpression)) {
                    psiElement2 = null;
                }
                KtQualifiedExpression parentQualified = (KtQualifiedExpression)psiElement2;
                KtExpression newExpression4 = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(parentQualified, calleeExpression2, (String)valueArgumentList2, elvis2){
                    final /* synthetic */ KtQualifiedExpression $parentQualified;
                    final /* synthetic */ KtExpression $calleeExpression;
                    final /* synthetic */ String $valueArgumentList;
                    final /* synthetic */ String $elvis;

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                        Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                        if (this.$parentQualified != null) {
                            KtExpression receiver2 = this.$parentQualified.getReceiverExpression();
                            ASTNode operationNode = this.$parentQualified.getOperationTokenNode();
                            ASTNode aSTNode = receiver2.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"receiver.node");
                            String beforeOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), (Function1)invoke.newExpression.beforeOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.beforeOperationNode.2.INSTANCE, (int)30, null);
                            String afterOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)operationNode, (boolean)true), (Function1)invoke.newExpression.afterOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.afterOperationNode.2.INSTANCE, (int)30, null);
                            $this$buildExpression.appendExpression(receiver2);
                            $this$buildExpression.appendFixedText(beforeOperationNode2);
                            KtSingleValueToken ktSingleValueToken = KtTokens.SAFE_ACCESS;
                            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SAFE_ACCESS");
                            String string = ktSingleValueToken.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtTokens.SAFE_ACCESS.value");
                            $this$buildExpression.appendFixedText(string);
                            $this$buildExpression.appendFixedText(afterOperationNode2);
                        }
                        $this$buildExpression.appendExpression(this.$calleeExpression);
                        KtSingleValueToken ktSingleValueToken = KtTokens.SAFE_ACCESS;
                        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SAFE_ACCESS");
                        String string = ktSingleValueToken.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtTokens.SAFE_ACCESS.value");
                        $this$buildExpression.appendFixedText(string);
                        $this$buildExpression.appendFixedText("invoke");
                        $this$buildExpression.appendFixedText(this.$valueArgumentList);
                        $this$buildExpression.appendFixedText(this.$elvis);
                    }
                    {
                        this.$parentQualified = ktQualifiedExpression;
                        this.$calleeExpression = ktExpression;
                        this.$valueArgumentList = string;
                        this.$elvis = string2;
                        super(1);
                    }
                }), (int)1, null);
                KtQualifiedExpression ktQualifiedExpression = parentQualified;
                replacement2 = (ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : element3).replace((PsiElement)newExpression4);
            } else if (object instanceof KtBinaryExpression) {
                PsiElement psiElement3;
                if (Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)KtTokens.IDENTIFIER)) {
                    String string = "$0?.$1($2)" + elvis2;
                    Object[] objectArray = new Object[3];
                    KtExpression ktExpression4 = ((KtBinaryExpression)element3).getLeft();
                    if (ktExpression4 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"element.left ?: return");
                    objectArray[0] = ktExpression4;
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element3).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                    String string2 = ktOperationReferenceExpression.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.operationReference.text");
                    objectArray[1] = string2;
                    KtExpression ktExpression5 = ((KtBinaryExpression)element3).getRight();
                    if (ktExpression5 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression5, (String)"element.right ?: return");
                    objectArray[2] = ktExpression5;
                    KtExpression newExpression5 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
                    psiElement3 = ((KtBinaryExpression)element3).replace((PsiElement)newExpression5);
                } else {
                    KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)OperatorToFunctionIntention.Companion.convert(element3).getSecond();
                    PsiElement psiElement4 = nameExpression2.getParent();
                    if (psiElement4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                    }
                    KtCallExpression callExpression2 = (KtCallExpression)psiElement4;
                    PsiElement psiElement5 = callExpression2.getParent();
                    if (psiElement5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                    }
                    KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)psiElement5;
                    KtExpression safeExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0?.$1" + elvis2), (Object[])new Object[]{qualifiedExpression.getReceiverExpression(), callExpression2}, (boolean)false, (int)4, null);
                    psiElement3 = qualifiedExpression.replace((PsiElement)safeExpression);
                }
                replacement2 = psiElement3;
            }
            object = elvis2;
            boolean bl = false;
            if (!(object.length() > 0)) break block20;
            PsiElement psiElement6 = replacement2;
            if (psiElement6 != null) {
                ReplaceCallFixUtilsKt.moveCaretToEnd(psiElement6, editor2, project2);
            }
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element3, boolean notNullNeeded) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.notNullNeeded = notNullNeeded;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement expression2 = diagnostic.getPsiElement();
            if (expression2 instanceof KtArrayAccessExpression && Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.UNSAFE_IMPLICIT_INVOKE_CALL) ^ true) {
                if (((KtArrayAccessExpression)expression2).getArrayExpression() == null) {
                    return null;
                }
                return new ReplaceInfixOrOperatorCallFix((KtExpression)expression2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)expression2));
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof KtBinaryExpression) {
                IntentionAction intentionAction;
                if (((KtBinaryExpression)parent2).getLeft() == null || ((KtBinaryExpression)parent2).getRight() == null) {
                    intentionAction = null;
                } else if (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.EQ)) {
                    intentionAction = null;
                } else {
                    ImmutableSet immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
                    Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"OperatorConventions.COMPARISON_OPERATIONS");
                    intentionAction = CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)((KtBinaryExpression)parent2).getOperationToken()) ? null : (IntentionAction)new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2));
                }
                return intentionAction;
            }
            if (parent2 instanceof KtCallExpression) {
                if (((KtCallExpression)parent2).getCalleeExpression() == null || ((KtCallExpression)parent2).getValueArgumentList() == null) {
                    return null;
                }
                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)((KtElement)parent2), (BodyResolveMode)BodyResolveMode.FULL);
                if (resolvedCall2 == null) {
                    return null;
                }
                ResolvedCall resolvedCall3 = resolvedCall2;
                if (!UtilsKt.canBeReplacedWithInvokeCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall3) || ResolvedCallUtilKt.getImplicitReceiverValue((ResolvedCall)resolvedCall3) != null) {
                    return null;
                }
                return new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2));
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

