/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationsHandler$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.move.AutocreatingPsiDirectoryWrapper;
import org.jetbrains.kotlin.idea.refactoring.move.AutocreatingPsiDirectoryWrapperKt;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinDirectoryMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveConflictChecker;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.UserDataProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 G2\u00020\u0001:\u0005GHIJKB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ<\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0002J(\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001fj\b\u0012\u0004\u0012\u00020\u001c` 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0016J'\u0010$\u001a\u00020\"2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J'\u0010(\u001a\u00020\"2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\f2\b\u0010+\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0002J0\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\nH\u0002J\"\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u00020&H\u0002J\"\u0010;\u001a\u0004\u0018\u0001012\u0006\u0010<\u001a\u0002012\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0015H\u0002J%\u0010=\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010A\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J-\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\f2\b\u0010+\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010FR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler;", "Lcom/intellij/refactoring/copy/CopyHandlerDelegateBase;", "()V", "copyFilesHandler", "Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "getCopyFilesHandler", "()Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "copyFilesHandler$delegate", "Lkotlin/Lazy;", "canCopy", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "fromUpdate", "([Lcom/intellij/psi/PsiElement;Z)Z", "canCopyDeclarations", "([Lcom/intellij/psi/PsiElement;)Z", "canCopyFiles", "collectConflicts", "Lcom/intellij/util/containers/MultiMap;", "", "sourceData", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "targetData", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "internalUsages", "Ljava/util/HashSet;", "Lcom/intellij/usageView/UsageInfo;", "Lkotlin/collections/HashSet;", "collectInternalUsages", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "doClone", "", "element", "doCopy", "defaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiDirectory;)V", "doCopyFiles", "filesToCopy", "Lcom/intellij/psi/PsiFileSystemItem;", "initialTargetDirectory", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)V", "doRefactor", "doRefactoringOnElement", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "doRefactoringOnFile", "fileToCopy", "targetDirectory", "targetFileName", "isSingleDeclarationInFile", "getFilePolicy", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$ExistingFilePolicy;", "existingFile", "Lcom/intellij/psi/PsiFile;", "getOrCreateTargetFile", "originalFile", "getSourceFiles", "([Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiFileSystemItem;", "getTargetDataForUX", "getTargetDataForUnitTest", "getTargetFileName", "trackedCopyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFiles", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)Ljava/util/Set;", "Companion", "ExistingFilePolicy", "RefactoringResult", "SourceData", "TargetData", "kotlin.idea"})
public final class CopyKotlinDeclarationsHandler
extends CopyHandlerDelegateBase {
    private final Lazy copyFilesHandler$delegate = LazyKt.lazy((Function0)copyFilesHandler.2.INSTANCE);
    @Nullable
    private static final UserDataProperty newName$delegate;
    @NotNull
    public static final Companion Companion;

    private final CopyFilesOrDirectoriesHandler getCopyFilesHandler() {
        Lazy lazy = this.copyFilesHandler$delegate;
        CopyKotlinDeclarationsHandler copyKotlinDeclarationsHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CopyFilesOrDirectoriesHandler)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final PsiFileSystemItem[] getSourceFiles(PsiElement[] elements2) {
        void $this$mapTo$iv$iv;
        PsiElement[] $this$map$iv = elements2;
        boolean $i$f$map = false;
        PsiElement[] psiElementArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            PsiFileSystemItem psiFileSystemItem;
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile2 = it.getContainingFile();
            if (psiFile2 != null) {
                psiFileSystemItem = (PsiFileSystemItem)psiFile2;
            } else {
                Object v2 = it;
                if (!(v2 instanceof PsiFileSystemItem)) {
                    v2 = null;
                }
                psiFileSystemItem = v2;
            }
            if (psiFileSystemItem == null) {
                return null;
            }
            PsiFileSystemItem psiFileSystemItem2 = psiFileSystemItem;
            collection.add(psiFileSystemItem2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiFileSystemItem[] psiFileSystemItemArray = thisCollection$iv.toArray(new PsiFileSystemItem[0]);
        if (psiFileSystemItemArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiFileSystemItemArray;
    }

    private final boolean canCopyFiles(PsiElement[] elements2, boolean fromUpdate) {
        boolean bl;
        PsiFileSystemItem[] sourceFiles2;
        block3: {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements2);
            if (psiFileSystemItemArray == null) {
                return false;
            }
            PsiFileSystemItem[] $this$any$iv = sourceFiles2 = psiFileSystemItemArray;
            boolean $i$f$any = false;
            PsiFileSystemItem[] psiFileSystemItemArray2 = $this$any$iv;
            int n = psiFileSystemItemArray2.length;
            for (int j = 0; j < n; ++j) {
                PsiFileSystemItem element$iv;
                PsiFileSystemItem it = element$iv = psiFileSystemItemArray2[j];
                boolean bl2 = false;
                if (!(it instanceof KtFile)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        return this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles2, fromUpdate);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canCopyDeclarations(PsiElement[] elements2) {
        void $this$flatMapTo$iv$iv;
        PsiElement[] $this$flatMap$iv = elements2;
        boolean $i$f$flatMap = false;
        PsiElement[] psiElementArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var8_8 = $this$flatMapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[j];
            boolean bl = false;
            Collection $this$ifEmpty$iv = CopyKotlinDeclarationsHandler.Companion.getDeclarationsToCopy((PsiElement)it);
            boolean $i$f$ifEmpty = false;
            if ($this$ifEmpty$iv.isEmpty()) {
                boolean bl2 = false;
                return false;
            }
            Iterable list$iv$iv = (List)$this$ifEmpty$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiFile> set$iv = new HashSet<PsiFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtElement it = (KtElement)e$iv;
            boolean bl = false;
            PsiFile key$iv = it.getContainingFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        KtElement ktElement = (KtElement)CollectionsKt.singleOrNull((List)list$iv);
        if (ktElement == null || (ktElement = ktElement.getContainingFile()) == null) {
            return false;
        }
        KtElement containingFile = ktElement;
        return ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)containingFile) != null;
    }

    public boolean canCopy(@NotNull PsiElement[] elements2, boolean fromUpdate) {
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        return this.canCopyDeclarations(elements2) || this.canCopyFiles(elements2, fromUpdate);
    }

    private final KtFile getOrCreateTargetFile(KtFile originalFile2, PsiDirectory targetDirectory2, String targetFileName) {
        PsiFile existingFile = targetDirectory2.findFile(targetFileName);
        if (Intrinsics.areEqual((Object)existingFile, (Object)originalFile2)) {
            return null;
        }
        if (existingFile != null) {
            switch (CopyKotlinDeclarationsHandler$WhenMappings.$EnumSwitchMapping$0[this.getFilePolicy(existingFile, targetFileName, targetDirectory2).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(existingFile){
                        final /* synthetic */ PsiFile $existingFile;

                        public final void invoke() {
                            this.$existingFile.delete();
                        }
                        {
                            this.$existingFile = psiFile2;
                            super(0);
                        }
                    });
                    break;
                }
                case 3: {
                    return null;
                }
            }
        }
        return (KtFile)ApplicationUtilsKt.runWriteAction((Function0)new Function0<KtFile>(existingFile, targetFileName, targetDirectory2){
            final /* synthetic */ PsiFile $existingFile;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $targetDirectory;

            @NotNull
            public final KtFile invoke() {
                KtFile ktFile;
                if (this.$existingFile != null && this.$existingFile.isValid()) {
                    PsiFile psiFile2 = this.$existingFile;
                    if (psiFile2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    ktFile = (KtFile)psiFile2;
                } else {
                    ktFile = KotlinRefactoringUtilKt.createKotlinFile$default(this.$targetFileName, this.$targetDirectory, null, 4, null);
                }
                return ktFile;
            }
            {
                this.$existingFile = psiFile2;
                this.$targetFileName = string;
                this.$targetDirectory = psiDirectory;
                super(0);
            }
        });
    }

    private final ExistingFilePolicy getFilePolicy(PsiFile existingFile, String targetFileName, PsiDirectory targetDirectory2) {
        ExistingFilePolicy existingFilePolicy;
        Object[] objectArray = new Object[2];
        objectArray[0] = targetFileName;
        VirtualFile virtualFile2 = targetDirectory2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"targetDirectory.virtualFile");
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetDirectory.virtualFile.path");
        objectArray[1] = string;
        String message2 = KotlinBundle.message("text.file.0.already.exists.in.1", objectArray);
        if (!(existingFile instanceof KtFile)) {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                return ExistingFilePolicy.OVERWRITE;
            }
            int answer = Messages.showOkCancelDialog((String)message2, (String)CopyKotlinDeclarationsHandler.Companion.getCommandName(), (String)KotlinBundle.message("action.text.overwrite", new Object[0]), (String)KotlinBundle.message("action.text.cancel", new Object[0]), (Icon)Messages.getQuestionIcon());
            existingFilePolicy = answer == 0 ? ExistingFilePolicy.OVERWRITE : ExistingFilePolicy.SKIP;
        } else {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                return ExistingFilePolicy.APPEND;
            }
            int answer = Messages.showYesNoCancelDialog((String)message2, (String)CopyKotlinDeclarationsHandler.Companion.getCommandName(), (String)KotlinBundle.message("action.text.append", new Object[0]), (String)KotlinBundle.message("action.text.overwrite", new Object[0]), (String)KotlinBundle.message("action.text.cancel", new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (answer) {
                case 0: {
                    existingFilePolicy = ExistingFilePolicy.APPEND;
                    break;
                }
                case 1: {
                    existingFilePolicy = ExistingFilePolicy.OVERWRITE;
                    break;
                }
                default: {
                    existingFilePolicy = ExistingFilePolicy.SKIP;
                }
            }
        }
        return existingFilePolicy;
    }

    private final TargetData getTargetDataForUnitTest(SourceData sourceData) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        SourceData $this$with = sourceData;
        boolean bl3 = false;
        VirtualFile virtualFile2 = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$with.getInitialTargetDirectory());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile targetSourceRoot = virtualFile2;
        String string2 = Companion.getNewName($this$with.getProject());
        if (string2 == null) {
            KtElement ktElement = $this$with.getSingleElementToCopy();
            string2 = string = ktElement != null ? ktElement.getName() : null;
        }
        if (string2 == null) {
            String string3 = $this$with.getOriginalFile().getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"originalFile.name");
        }
        if (string == null) {
            return null;
        }
        String newName2 = string;
        if ($this$with.getSingleElementToCopy() != null) {
            CharSequence charSequence = newName2;
            boolean bl4 = false;
            if (charSequence.length() == 0) {
                return null;
            }
        }
        return new TargetData(false, newName2, AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper($this$with.getInitialTargetDirectory()), targetSourceRoot);
    }

    private final TargetData getTargetDataForUX(SourceData sourceData) {
        CopyKotlinDeclarationDialog dialog2;
        KtNamedDeclaration singleNamedSourceElement;
        boolean openInEditor = false;
        String newName2 = null;
        AutocreatingPsiDirectoryWrapper targetDirWrapper = null;
        VirtualFile targetSourceRoot = null;
        KtElement ktElement = sourceData.getSingleElementToCopy();
        if (!(ktElement instanceof KtNamedDeclaration)) {
            ktElement = null;
        }
        if ((singleNamedSourceElement = (KtNamedDeclaration)ktElement) != null) {
            dialog2 = new CopyKotlinDeclarationDialog(singleNamedSourceElement, sourceData.getInitialTargetDirectory(), sourceData.getProject());
            dialog2.setTitle(CopyKotlinDeclarationsHandler.Companion.getCommandName());
            if (!dialog2.showAndGet()) {
                return null;
            }
            openInEditor = dialog2.getOpenInEditor();
            String string = dialog2.getNewName();
            if (string == null) {
                string = singleNamedSourceElement.getName();
            }
            newName2 = string;
            MoveDestination moveDestination = dialog2.getTargetDirectory();
            targetDirWrapper = moveDestination != null ? AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper(moveDestination) : null;
            targetSourceRoot = dialog2.getTargetSourceRoot();
        } else {
            dialog2 = new CopyFilesOrDirectoriesDialog((PsiElement[])new KtFile[]{sourceData.getOriginalFile()}, sourceData.getInitialTargetDirectory(), sourceData.getProject(), false);
            if (!dialog2.showAndGet()) {
                return null;
            }
            openInEditor = dialog2.openInEditor();
            newName2 = dialog2.getNewName();
            PsiDirectory psiDirectory = dialog2.getTargetDirectory();
            targetDirWrapper = psiDirectory != null ? AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper(psiDirectory) : null;
            PsiDirectory psiDirectory2 = dialog2.getTargetDirectory();
            Object object = targetSourceRoot = psiDirectory2 != null ? ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)psiDirectory2) : null;
        }
        if (targetDirWrapper == null) {
            return null;
        }
        if (newName2 == null) {
            return null;
        }
        if (sourceData.getSingleElementToCopy() != null) {
            CharSequence charSequence = newName2;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return null;
            }
        }
        return new TargetData(openInEditor, newName2, targetDirWrapper, targetSourceRoot);
    }

    private final LinkedHashSet<UsageInfo> collectInternalUsages(SourceData sourceData, TargetData targetData) {
        return (LinkedHashSet)ApplicationUtilsKt.runReadAction((Function0)new Function0<LinkedHashSet<UsageInfo>>(targetData, sourceData){
            final /* synthetic */ TargetData $targetData;
            final /* synthetic */ SourceData $sourceData;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LinkedHashSet<UsageInfo> invoke() {
                void $this$flatMapTo$iv;
                String targetPackageName = this.$targetData.getTargetDirWrapper().getPackageName();
                ContainerChangeInfo changeInfo = new ContainerChangeInfo(new ContainerInfo.Package(this.$sourceData.getOriginalFile().getPackageFqName()), new ContainerInfo.Package(new FqName(targetPackageName)));
                Iterable iterable = this.$sourceData.getElementsToCopy();
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    void $this$filterTo$iv$iv;
                    KtElement elementToCopy = (KtElement)element$iv;
                    boolean bl = false;
                    Iterable $this$filter$iv = MoveUtilsKt.getInternalReferencesToUpdateOnPackageNameChange(elementToCopy, changeInfo);
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        UsageInfo it = (UsageInfo)element$iv$iv;
                        boolean bl2 = false;
                        UsageInfo usageInfo = it;
                        if (!(usageInfo instanceof MoveRenameUsageInfo)) {
                            usageInfo = null;
                        }
                        MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usageInfo;
                        Object referencedElement = moveRenameUsageInfo != null ? moveRenameUsageInfo.getReferencedElement() : null;
                        if (!(referencedElement == null || !PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)elementToCopy), (PsiElement)referencedElement, (boolean)false, (int)2, null))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable list$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                return (LinkedHashSet)destination$iv;
            }
            {
                this.$targetData = targetData;
                this.$sourceData = sourceData;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<VirtualFile> trackedCopyFiles(PsiFileSystemItem[] sourceFiles2, PsiDirectory initialTargetDirectory) {
        if (!this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles2)) {
            return SetsKt.emptySet();
        }
        VirtualFileListener mapper2 = new VirtualFileListener(){
            @NotNull
            private final Set<VirtualFile> filesCopied;

            @NotNull
            public final Set<VirtualFile> getFilesCopied() {
                return this.filesCopied;
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                this.filesCopied.add(virtualFile2);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                this.filesCopied.add(virtualFile2);
            }
            {
                boolean bl = false;
                this.filesCopied = new LinkedHashSet<E>();
            }
        };
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileManager $this$with = virtualFileManager;
        boolean bl3 = false;
        try {
            $this$with.addVirtualFileListener(mapper2);
            this.getCopyFilesHandler().doCopy((PsiElement[])sourceFiles2, initialTargetDirectory);
        }
        finally {
            $this$with.removeVirtualFileListener(mapper2);
        }
        return mapper2.getFilesCopied();
    }

    private final void doCopyFiles(PsiFileSystemItem[] filesToCopy, PsiDirectory initialTargetDirectory) {
        PsiFileSystemItem[] psiFileSystemItemArray = filesToCopy;
        boolean bl = false;
        if (psiFileSystemItemArray.length == 0) {
            return;
        }
        Project project2 = filesToCopy[0].getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"filesToCopy[0].project");
        Project project3 = project2;
        PsiManager psiManager2 = PsiManager.getInstance((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager3 = psiManager2;
        ApplicationUtilsKt.executeCommand$default(project3, CopyKotlinDeclarationsHandler.Companion.getCommandName(), null, (Function0)new Function0<Unit>(this, filesToCopy, initialTargetDirectory, psiManager3, project3){
            final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ PsiFileSystemItem[] $filesToCopy;
            final /* synthetic */ PsiDirectory $initialTargetDirectory;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ Project $project;

            public final void invoke() {
                Set copiedFiles = CopyKotlinDeclarationsHandler.access$trackedCopyFiles(this.this$0, this.$filesToCopy, this.$initialTargetDirectory);
                Iterable $this$forEach$iv = copiedFiles;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtFile targetKtFile;
                    VirtualFile copiedFile = (VirtualFile)element$iv;
                    boolean bl = false;
                    PsiFile psiFile2 = this.$psiManager.findFile(copiedFile);
                    if (!(psiFile2 instanceof KtFile)) {
                        psiFile2 = null;
                    }
                    if ((targetKtFile = (KtFile)psiFile2) == null) continue;
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(targetKtFile, this){
                        final /* synthetic */ KtFile $targetKtFile;
                        final /* synthetic */ doCopyFiles.1 this$0;
                        {
                            this.$targetKtFile = ktFile;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            PsiDirectory psiDirectory;
                            if (!PackageUtilsKt.packageMatchesDirectoryOrImplicit(this.$targetKtFile) && (psiDirectory = this.$targetKtFile.getContainingDirectory()) != null && (psiDirectory = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory)) != null && (psiDirectory = UtilsKt.quoteIfNeeded((FqName)psiDirectory)) != null) {
                                PsiDirectory psiDirectory2 = psiDirectory;
                                boolean bl = false;
                                boolean bl2 = false;
                                PsiDirectory targetDirectoryFqName = psiDirectory2;
                                boolean bl3 = false;
                                this.$targetKtFile.setPackageFqName((FqName)targetDirectoryFqName);
                            }
                            DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.this$0.$project);
                        }
                    });
                }
            }
            {
                this.this$0 = copyKotlinDeclarationsHandler;
                this.$filesToCopy = psiFileSystemItemArray;
                this.$initialTargetDirectory = psiDirectory;
                this.$psiManager = psiManager2;
                this.$project = project2;
                super(0);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void doCopy(@NotNull PsiElement[] elements2, @Nullable PsiDirectory defaultTargetDirectory) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement[] psiElementArray = elements2;
        boolean bl = false;
        if (psiElementArray.length == 0) {
            return;
        }
        if (!this.canCopyDeclarations(elements2)) {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements2);
            if (psiFileSystemItemArray != null) {
                psiElementArray = psiFileSystemItemArray;
                bl = false;
                boolean bl2 = false;
                PsiElement[] it = psiElementArray;
                boolean bl3 = false;
                this.doCopyFiles((PsiFileSystemItem[])it, defaultTargetDirectory);
                return;
            }
        }
        PsiElement[] $this$mapNotNull$iv = elements2;
        boolean $i$f$mapNotNull = false;
        PsiElement[] it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var11_18 = $this$forEach$iv$iv$iv;
        int n = ((void)var11_18).length;
        for (int j = 0; j < n; ++j) {
            KtElement ktElement;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var11_18[j];
            boolean bl4 = false;
            void it2 = element$iv$iv;
            boolean bl5 = false;
            if (CopyKotlinDeclarationsHandler.Companion.getCopyableElement((PsiElement)it2) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            KtElement it$iv$iv = ktElement;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToCopy = (List)destination$iv$iv;
        if (elementsToCopy.isEmpty()) {
            return;
        }
        KtElement singleElementToCopy = (KtElement)CollectionsKt.singleOrNull((List)elementsToCopy);
        PsiFile psiFile2 = ((KtElement)CollectionsKt.first((List)elementsToCopy)).getContainingFile();
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile originalFile2 = (KtFile)psiFile2;
        PsiDirectory psiDirectory = defaultTargetDirectory;
        if (psiDirectory == null) {
            psiDirectory = originalFile2.getContainingDirectory();
        }
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory initialTargetDirectory = psiDirectory;
        Project project2 = initialTargetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"initialTargetDirectory.project");
        Project project3 = project2;
        SourceData sourceData = new SourceData(project3, singleElementToCopy, elementsToCopy, originalFile2, initialTargetDirectory);
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        TargetData targetData = application.isUnitTestMode() ? this.getTargetDataForUnitTest(sourceData) : this.getTargetDataForUX(sourceData);
        if (targetData == null) {
            return;
        }
        LinkedHashSet<UsageInfo> internalUsages = this.collectInternalUsages(sourceData, targetData);
        MoveUtilsKt.markInternalUsages((Collection<? extends UsageInfo>)internalUsages);
        MultiMap<PsiElement, String> conflicts2 = this.collectConflicts(sourceData, targetData, (HashSet<UsageInfo>)internalUsages);
        KotlinRefactoringUtilKt.checkConflictsInteractively$default(project3, conflicts2, null, (Function0)new Function0<Unit>(this, project3, sourceData, targetData, internalUsages){
            final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceData $sourceData;
            final /* synthetic */ TargetData $targetData;
            final /* synthetic */ LinkedHashSet $internalUsages;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    ApplicationUtilsKt.executeCommand$default(this.$project, org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationsHandler$Companion.access$getCommandName$p(CopyKotlinDeclarationsHandler.Companion), null, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ doCopy.2 this$0;

                        public final void invoke() {
                            CopyKotlinDeclarationsHandler.access$doRefactor(this.this$0.this$0, this.this$0.$sourceData, this.this$0.$targetData);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 2, null);
                }
                finally {
                    MoveUtilsKt.cleanUpInternalUsages(this.$internalUsages);
                }
            }
            {
                this.this$0 = copyKotlinDeclarationsHandler;
                this.$project = project2;
                this.$sourceData = sourceData;
                this.$targetData = targetData;
                this.$internalUsages = linkedHashSet;
                super(0);
            }
        }, 2, null);
    }

    private final String getTargetFileName(SourceData sourceData, TargetData targetData) {
        String string;
        if (StringsKt.contains$default((CharSequence)targetData.getNewName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            string = targetData.getNewName();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(targetData.getNewName()).append(".");
            VirtualFile virtualFile2 = sourceData.getOriginalFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"sourceData.originalFile.virtualFile");
            string = stringBuilder.append(virtualFile2.getExtension()).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void doRefactor(SourceData sourceData, TargetData targetData) {
        Object object;
        RefactoringResult refactoringResult = null;
        try {
            KtFile targetFile2;
            RefactoringResult refactoringResult2;
            KtFile ktFile;
            PsiDirectory psiDirectory = (PsiDirectory)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>(targetData, sourceData){
                final /* synthetic */ TargetData $targetData;
                final /* synthetic */ SourceData $sourceData;

                @NotNull
                public final PsiDirectory invoke() {
                    return this.$targetData.getTargetDirWrapper().getOrCreateDirectory(this.$sourceData.getInitialTargetDirectory());
                }
                {
                    this.$targetData = targetData;
                    this.$sourceData = sourceData;
                    super(0);
                }
            });
            String targetFileName = this.getTargetFileName(sourceData, targetData);
            boolean isSingleDeclarationInFile = sourceData.getSingleElementToCopy() instanceof KtNamedDeclaration && Intrinsics.areEqual((Object)((KtDeclaration)CollectionsKt.singleOrNull((List)sourceData.getOriginalFile().getDeclarations())), (Object)sourceData.getSingleElementToCopy());
            Object object2 = sourceData.getSingleElementToCopy() instanceof KtFile ? (KtFile)sourceData.getSingleElementToCopy() : (ktFile = isSingleDeclarationInFile ? sourceData.getOriginalFile() : null);
            if (ktFile != null) {
                refactoringResult2 = this.doRefactoringOnFile(ktFile, sourceData, psiDirectory, targetFileName, isSingleDeclarationInFile);
            } else {
                KtFile ktFile2 = this.getOrCreateTargetFile(sourceData.getOriginalFile(), psiDirectory, targetFileName);
                if (ktFile2 == null) {
                    throw (Throwable)new IncorrectOperationException("Could not create target file.");
                }
                targetFile2 = ktFile2;
                refactoringResult2 = this.doRefactoringOnElement(sourceData, targetFile2);
            }
            refactoringResult = refactoringResult2;
            KtNamedDeclaration ktNamedDeclaration = refactoringResult.getCopiedDeclaration();
            if (ktNamedDeclaration != null) {
                targetFile2 = ktNamedDeclaration;
                boolean bl = false;
                boolean bl2 = false;
                KtFile newDeclaration = targetFile2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)targetData.getNewName(), (Object)newDeclaration.getName())) {
                    Collection collection = ReferencesSearch.search((PsiElement)((PsiElement)newDeclaration), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)newDeclaration))).findAll();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ReferencesSearch.search(\u2026ewDeclaration)).findAll()");
                    Collection selfReferences = collection;
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(selfReferences, (KtNamedDeclaration)newDeclaration, targetData){
                        final /* synthetic */ Collection $selfReferences;
                        final /* synthetic */ KtNamedDeclaration $newDeclaration;
                        final /* synthetic */ TargetData $targetData$inlined;
                        {
                            this.$selfReferences = collection;
                            this.$newDeclaration = ktNamedDeclaration;
                            this.$targetData$inlined = targetData;
                            super(0);
                        }

                        public final void invoke() {
                            Iterable $this$forEach$iv = this.$selfReferences;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PsiReference it = (PsiReference)element$iv;
                                boolean bl = false;
                                it.handleElementRename(this.$targetData$inlined.getNewName());
                            }
                            this.$newDeclaration.setName(this.$targetData$inlined.getNewName());
                        }
                    });
                }
            }
            if (targetData.getOpenInEditor()) {
                EditorHelper.openInEditor((PsiElement)((PsiElement)refactoringResult.getTargetFile()));
            }
            if ((object = refactoringResult) == null || (object = ((RefactoringResult)object).getRestoredInternalUsages()) == null) return;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            Object object3;
            try {
                Messages.showMessageDialog((Project)sourceData.getProject(), (String)incorrectOperationException.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                object3 = refactoringResult;
                if (object3 == null || (object3 = ((RefactoringResult)object3).getRestoredInternalUsages()) == null) return;
            }
            catch (Throwable throwable) {
                Object object4 = refactoringResult;
                if (object4 == null || (object4 = ((RefactoringResult)object4).getRestoredInternalUsages()) == null) throw throwable;
                Object object5 = object4;
                boolean bl = false;
                boolean bl4 = false;
                Object it = object5;
                boolean bl5 = false;
                MoveUtilsKt.cleanUpInternalUsages((Collection)it);
                throw throwable;
            }
            Object object6 = object3;
            boolean bl = false;
            boolean bl6 = false;
            Object object7 = object6;
            boolean bl7 = false;
            MoveUtilsKt.cleanUpInternalUsages((Collection)object7);
            return;
        }
        Object object8 = object;
        boolean bl = false;
        boolean bl8 = false;
        Object object9 = object8;
        boolean bl9 = false;
        MoveUtilsKt.cleanUpInternalUsages((Collection)object9);
        return;
    }

    private final RefactoringResult doRefactoringOnFile(KtFile fileToCopy, SourceData sourceData, PsiDirectory targetDirectory2, String targetFileName, boolean isSingleDeclarationInFile) {
        KtNamedDeclaration ktNamedDeclaration;
        PsiFile targetFile2 = (PsiFile)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiFile>(targetDirectory2, targetFileName, fileToCopy, sourceData){
            final /* synthetic */ PsiDirectory $targetDirectory;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ KtFile $fileToCopy;
            final /* synthetic */ SourceData $sourceData;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PsiFile invoke() {
                void var2_2;
                FqName fqName2;
                FqName targetDirectoryFqName = PackageUtilsKt.getFqNameWithImplicitPrefix(this.$targetDirectory);
                PsiFile psiFile2 = this.$targetDirectory.copyFileFrom(this.$targetFileName, (PsiFile)this.$fileToCopy);
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"targetDirectory.copyFile\u2026rgetFileName, fileToCopy)");
                PsiFile copiedFile = psiFile2;
                if (copiedFile instanceof KtFile && PackageUtilsKt.packageMatchesDirectoryOrImplicit(this.$fileToCopy) && (fqName2 = targetDirectoryFqName) != null && (fqName2 = UtilsKt.quoteIfNeeded(fqName2)) != null) {
                    FqName fqName3 = fqName2;
                    boolean bl = false;
                    boolean bl2 = false;
                    FqName it = fqName3;
                    boolean bl3 = false;
                    ((KtFile)copiedFile).setPackageFqName(it);
                }
                DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.$sourceData.getProject());
                return var2_2;
            }
            {
                this.$targetDirectory = psiDirectory;
                this.$targetFileName = string;
                this.$fileToCopy = ktFile;
                this.$sourceData = sourceData;
                super(0);
            }
        });
        if (isSingleDeclarationInFile && targetFile2 instanceof KtFile) {
            Object object = CollectionsKt.singleOrNull((List)((KtFile)targetFile2).getDeclarations());
            if (!(object instanceof KtNamedDeclaration)) {
                object = null;
            }
            ktNamedDeclaration = (KtNamedDeclaration)object;
        } else {
            ktNamedDeclaration = null;
        }
        KtNamedDeclaration copiedDeclaration = ktNamedDeclaration;
        return new RefactoringResult(targetFile2, copiedDeclaration, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final RefactoringResult doRefactoringOnElement(SourceData sourceData, KtFile targetFile2) {
        void $this$filterIsInstanceTo$iv$iv;
        ArrayList restoredInternalUsages = new ArrayList();
        HashMap oldToNewElementsMapping = new HashMap();
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(sourceData, targetFile2, oldToNewElementsMapping, restoredInternalUsages){
            final /* synthetic */ SourceData $sourceData;
            final /* synthetic */ KtFile $targetFile;
            final /* synthetic */ HashMap $oldToNewElementsMapping;
            final /* synthetic */ ArrayList $restoredInternalUsages;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$sourceData.getElementsToCopy();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtElement ktElement = (KtElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = this.$targetFile.add(it.copy());
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                    }
                    KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
                    collection.add(ktNamedDeclaration);
                }
                List newElements2 = (List)destination$iv$iv;
                MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.$sourceData.getElementsToCopy(), (Iterable)newElements2), (Map)this.$oldToNewElementsMapping);
                ((Map)this.$oldToNewElementsMapping).put(this.$sourceData.getOriginalFile(), this.$targetFile);
                for (PsiElement newElement2 : this.$oldToNewElementsMapping.values()) {
                    iterable = this.$restoredInternalUsages;
                    PsiElement psiElement3 = newElement2;
                    if (psiElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    }
                    Iterable iterable2 = MoveUtilsKt.restoreInternalUsages((KtElement)psiElement3, this.$oldToNewElementsMapping, true);
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
                    MoveUtilsKt.postProcessMoveUsages$default(this.$restoredInternalUsages, this.$oldToNewElementsMapping, null, 4, null);
                }
                DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.$sourceData.getProject());
            }
            {
                this.$sourceData = sourceData;
                this.$targetFile = ktFile;
                this.$oldToNewElementsMapping = hashMap;
                this.$restoredInternalUsages = arrayList;
                super(0);
            }
        });
        Collection collection = oldToNewElementsMapping.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"oldToNewElementsMapping.values");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtNamedDeclaration copiedDeclaration = (KtNamedDeclaration)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        return new RefactoringResult((PsiFile)targetFile2, copiedDeclaration, restoredInternalUsages);
    }

    private final MultiMap<PsiElement, String> collectConflicts(SourceData sourceData, TargetData targetData, HashSet<UsageInfo> internalUsages) {
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.empty()");
            return multiMap;
        }
        VirtualFile virtualFile2 = targetData.getTargetSourceRoot();
        if (virtualFile2 == null || (virtualFile2 = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile2, sourceData.getProject())) == null) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.empty()");
            return multiMap;
        }
        VirtualFile targetSourceRootPsi = virtualFile2;
        if (Intrinsics.areEqual((Object)sourceData.getProject(), (Object)sourceData.getOriginalFile().getProject()) ^ true) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.empty()");
            return multiMap;
        }
        Project project2 = sourceData.getProject();
        Collection collection = sourceData.getElementsToCopy();
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        VirtualFile virtualFile3 = targetSourceRootPsi.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"targetSourceRootPsi.virtualFile");
        MoveConflictChecker conflictChecker2 = new MoveConflictChecker(project2, collection, new KotlinDirectoryMoveTarget(fqName2, virtualFile3), (KtElement)sourceData.getOriginalFile(), null, null, 48, null);
        MultiMap multiMap = new MultiMap();
        boolean bl = false;
        boolean bl2 = false;
        MultiMap it = multiMap;
        boolean bl3 = false;
        conflictChecker2.checkModuleConflictsInDeclarations((Set<UsageInfo>)internalUsages, (MultiMap<PsiElement, String>)it);
        conflictChecker2.checkVisibilityInDeclarations((MultiMap<PsiElement, String>)it);
        return multiMap;
    }

    public void doClone(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"NEW_NAME");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"NEW_NAME\")");
        newName$delegate = new UserDataProperty(key);
    }

    public static final /* synthetic */ Set access$trackedCopyFiles(CopyKotlinDeclarationsHandler $this, PsiFileSystemItem[] sourceFiles2, PsiDirectory initialTargetDirectory) {
        return $this.trackedCopyFiles(sourceFiles2, initialTargetDirectory);
    }

    public static final /* synthetic */ void access$doRefactor(CopyKotlinDeclarationsHandler $this, SourceData sourceData, TargetData targetData) {
        $this.doRefactor(sourceData, targetData);
    }

    public static final /* synthetic */ void access$setNewName$cp(UserDataProperty userDataProperty) {
        newName$delegate = userDataProperty;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$ExistingFilePolicy;", "", "(Ljava/lang/String;I)V", "APPEND", "OVERWRITE", "SKIP", "kotlin.idea"})
    public static final class ExistingFilePolicy
    extends Enum<ExistingFilePolicy> {
        public static final /* enum */ ExistingFilePolicy APPEND;
        public static final /* enum */ ExistingFilePolicy OVERWRITE;
        public static final /* enum */ ExistingFilePolicy SKIP;
        private static final /* synthetic */ ExistingFilePolicy[] $VALUES;

        static {
            ExistingFilePolicy[] existingFilePolicyArray = new ExistingFilePolicy[3];
            ExistingFilePolicy[] existingFilePolicyArray2 = existingFilePolicyArray;
            existingFilePolicyArray[0] = APPEND = new ExistingFilePolicy();
            existingFilePolicyArray[1] = OVERWRITE = new ExistingFilePolicy();
            existingFilePolicyArray[2] = SKIP = new ExistingFilePolicy();
            $VALUES = existingFilePolicyArray;
        }

        public static ExistingFilePolicy[] values() {
            return (ExistingFilePolicy[])$VALUES.clone();
        }

        public static ExistingFilePolicy valueOf(String string) {
            return Enum.valueOf(ExistingFilePolicy.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "", "openInEditor", "", "newName", "", "targetDirWrapper", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(ZLjava/lang/String;Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getNewName", "()Ljava/lang/String;", "getOpenInEditor", "()Z", "getTargetDirWrapper", "()Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class TargetData {
        private final boolean openInEditor;
        @NotNull
        private final String newName;
        @NotNull
        private final AutocreatingPsiDirectoryWrapper targetDirWrapper;
        @Nullable
        private final VirtualFile targetSourceRoot;

        public final boolean getOpenInEditor() {
            return this.openInEditor;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final AutocreatingPsiDirectoryWrapper getTargetDirWrapper() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile getTargetSourceRoot() {
            return this.targetSourceRoot;
        }

        public TargetData(boolean openInEditor, @NotNull String newName2, @NotNull AutocreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            this.openInEditor = openInEditor;
            this.newName = newName2;
            this.targetDirWrapper = targetDirWrapper;
            this.targetSourceRoot = targetSourceRoot;
        }

        public final boolean component1() {
            return this.openInEditor;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        @NotNull
        public final AutocreatingPsiDirectoryWrapper component3() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile component4() {
            return this.targetSourceRoot;
        }

        @NotNull
        public final TargetData copy(boolean openInEditor, @NotNull String newName2, @NotNull AutocreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            return new TargetData(openInEditor, newName2, targetDirWrapper, targetSourceRoot);
        }

        public static /* synthetic */ TargetData copy$default(TargetData targetData, boolean bl, String string, AutocreatingPsiDirectoryWrapper autocreatingPsiDirectoryWrapper, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = targetData.openInEditor;
            }
            if ((n & 2) != 0) {
                string = targetData.newName;
            }
            if ((n & 4) != 0) {
                autocreatingPsiDirectoryWrapper = targetData.targetDirWrapper;
            }
            if ((n & 8) != 0) {
                virtualFile2 = targetData.targetSourceRoot;
            }
            return targetData.copy(bl, string, autocreatingPsiDirectoryWrapper, virtualFile2);
        }

        @NotNull
        public String toString() {
            return "TargetData(openInEditor=" + this.openInEditor + ", newName=" + this.newName + ", targetDirWrapper=" + this.targetDirWrapper + ", targetSourceRoot=" + this.targetSourceRoot + ")";
        }

        public int hashCode() {
            int n = this.openInEditor ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            String string = this.newName;
            AutocreatingPsiDirectoryWrapper autocreatingPsiDirectoryWrapper = this.targetDirWrapper;
            VirtualFile virtualFile2 = this.targetSourceRoot;
            return ((n * 31 + (string != null ? string.hashCode() : 0)) * 31 + (autocreatingPsiDirectoryWrapper != null ? autocreatingPsiDirectoryWrapper.hashCode() : 0)) * 31 + (virtualFile2 != null ? virtualFile2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TargetData)) break block3;
                    TargetData targetData = (TargetData)object;
                    if (this.openInEditor != targetData.openInEditor || !Intrinsics.areEqual((Object)this.newName, (Object)targetData.newName) || !Intrinsics.areEqual((Object)this.targetDirWrapper, (Object)targetData.targetDirWrapper) || !Intrinsics.areEqual((Object)this.targetSourceRoot, (Object)targetData.targetSourceRoot)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "", "project", "Lcom/intellij/openapi/project/Project;", "singleElementToCopy", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToCopy", "", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiDirectory;)V", "getElementsToCopy", "()Ljava/util/List;", "getInitialTargetDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getOriginalFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSingleElementToCopy", "()Lorg/jetbrains/kotlin/psi/KtElement;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class SourceData {
        @NotNull
        private final Project project;
        @Nullable
        private final KtElement singleElementToCopy;
        @NotNull
        private final List<KtElement> elementsToCopy;
        @NotNull
        private final KtFile originalFile;
        @NotNull
        private final PsiDirectory initialTargetDirectory;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final KtElement getSingleElementToCopy() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> getElementsToCopy() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile getOriginalFile() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory getInitialTargetDirectory() {
            return this.initialTargetDirectory;
        }

        public SourceData(@NotNull Project project2, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile2, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile2, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            this.project = project2;
            this.singleElementToCopy = singleElementToCopy;
            this.elementsToCopy = elementsToCopy;
            this.originalFile = originalFile2;
            this.initialTargetDirectory = initialTargetDirectory;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @Nullable
        public final KtElement component2() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> component3() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile component4() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory component5() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final SourceData copy(@NotNull Project project2, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile2, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile2, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            return new SourceData(project2, singleElementToCopy, elementsToCopy, originalFile2, initialTargetDirectory);
        }

        public static /* synthetic */ SourceData copy$default(SourceData sourceData, Project project2, KtElement ktElement, List list2, KtFile ktFile, PsiDirectory psiDirectory, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = sourceData.project;
            }
            if ((n & 2) != 0) {
                ktElement = sourceData.singleElementToCopy;
            }
            if ((n & 4) != 0) {
                list2 = sourceData.elementsToCopy;
            }
            if ((n & 8) != 0) {
                ktFile = sourceData.originalFile;
            }
            if ((n & 0x10) != 0) {
                psiDirectory = sourceData.initialTargetDirectory;
            }
            return sourceData.copy(project2, ktElement, list2, ktFile, psiDirectory);
        }

        @NotNull
        public String toString() {
            return "SourceData(project=" + this.project + ", singleElementToCopy=" + this.singleElementToCopy + ", elementsToCopy=" + this.elementsToCopy + ", originalFile=" + this.originalFile + ", initialTargetDirectory=" + this.initialTargetDirectory + ")";
        }

        public int hashCode() {
            Project project2 = this.project;
            KtElement ktElement = this.singleElementToCopy;
            List<KtElement> list2 = this.elementsToCopy;
            KtFile ktFile = this.originalFile;
            PsiDirectory psiDirectory = this.initialTargetDirectory;
            return ((((project2 != null ? project2.hashCode() : 0) * 31 + (ktElement != null ? ktElement.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (ktFile != null ? ktFile.hashCode() : 0)) * 31 + (psiDirectory != null ? psiDirectory.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceData)) break block3;
                    SourceData sourceData = (SourceData)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)sourceData.project) || !Intrinsics.areEqual((Object)this.singleElementToCopy, (Object)sourceData.singleElementToCopy) || !Intrinsics.areEqual(this.elementsToCopy, sourceData.elementsToCopy) || !Intrinsics.areEqual((Object)this.originalFile, (Object)sourceData.originalFile) || !Intrinsics.areEqual((Object)this.initialTargetDirectory, (Object)sourceData.initialTargetDirectory)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "", "targetFile", "Lcom/intellij/psi/PsiFile;", "copiedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "restoredInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/List;)V", "getCopiedDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getRestoredInternalUsages", "()Ljava/util/List;", "getTargetFile", "()Lcom/intellij/psi/PsiFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class RefactoringResult {
        @NotNull
        private final PsiFile targetFile;
        @Nullable
        private final KtNamedDeclaration copiedDeclaration;
        @Nullable
        private final List<UsageInfo> restoredInternalUsages;

        @NotNull
        public final PsiFile getTargetFile() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration getCopiedDeclaration() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> getRestoredInternalUsages() {
            return this.restoredInternalUsages;
        }

        public RefactoringResult(@NotNull PsiFile targetFile2, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
            this.targetFile = targetFile2;
            this.copiedDeclaration = copiedDeclaration;
            this.restoredInternalUsages = restoredInternalUsages;
        }

        public /* synthetic */ RefactoringResult(PsiFile psiFile2, KtNamedDeclaration ktNamedDeclaration, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = null;
            }
            this(psiFile2, ktNamedDeclaration, list2);
        }

        @NotNull
        public final PsiFile component1() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration component2() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> component3() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final RefactoringResult copy(@NotNull PsiFile targetFile2, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
            return new RefactoringResult(targetFile2, copiedDeclaration, restoredInternalUsages);
        }

        public static /* synthetic */ RefactoringResult copy$default(RefactoringResult refactoringResult, PsiFile psiFile2, KtNamedDeclaration ktNamedDeclaration, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                psiFile2 = refactoringResult.targetFile;
            }
            if ((n & 2) != 0) {
                ktNamedDeclaration = refactoringResult.copiedDeclaration;
            }
            if ((n & 4) != 0) {
                list2 = refactoringResult.restoredInternalUsages;
            }
            return refactoringResult.copy(psiFile2, ktNamedDeclaration, list2);
        }

        @NotNull
        public String toString() {
            return "RefactoringResult(targetFile=" + this.targetFile + ", copiedDeclaration=" + this.copiedDeclaration + ", restoredInternalUsages=" + this.restoredInternalUsages + ")";
        }

        public int hashCode() {
            PsiFile psiFile2 = this.targetFile;
            KtNamedDeclaration ktNamedDeclaration = this.copiedDeclaration;
            List<UsageInfo> list2 = this.restoredInternalUsages;
            return ((psiFile2 != null ? psiFile2.hashCode() : 0) * 31 + (ktNamedDeclaration != null ? ktNamedDeclaration.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RefactoringResult)) break block3;
                    RefactoringResult refactoringResult = (RefactoringResult)object;
                    if (!Intrinsics.areEqual((Object)this.targetFile, (Object)refactoringResult.targetFile) || !Intrinsics.areEqual((Object)this.copiedDeclaration, (Object)refactoringResult.copiedDeclaration) || !Intrinsics.areEqual(this.restoredInternalUsages, refactoringResult.restoredInternalUsages)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0014H\u0002R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR3\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u00048F@GX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$Companion;", "", "()V", "commandName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getCommandName", "()Ljava/lang/String;", "<set-?>", "newName", "Lcom/intellij/openapi/project/Project;", "getNewName", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "setNewName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "newName$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "getCopyableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/psi/PsiElement;", "getDeclarationsToCopy", "", "kotlin.idea"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "newName", "getNewName(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", 0))};
        }

        private final String getCommandName() {
            String string = RefactoringBundle.message((String)"copy.handler.copy.files.directories");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RefactoringBundle.messag\u2026.copy.files.directories\")");
            return string;
        }

        @Nullable
        public final String getNewName(@NotNull Project $this$newName) {
            Intrinsics.checkNotNullParameter((Object)$this$newName, (String)"$this$newName");
            return (String)newName$delegate.getValue((UserDataHolder)$this$newName, $$delegatedProperties[0]);
        }

        @TestOnly
        public final void setNewName(@NotNull Project $this$newName, @Nullable String string) {
            Intrinsics.checkNotNullParameter((Object)$this$newName, (String)"$this$newName");
            newName$delegate.setValue((UserDataHolder)$this$newName, $$delegatedProperties[0], (Object)string);
        }

        private final KtElement getCopyableElement(PsiElement $this$getCopyableElement) {
            Object v1;
            Object v0;
            block2: {
                Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getCopyableElement);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtFile || it instanceof KtNamedDeclaration && ((KtNamedDeclaration)it).getParent() instanceof KtFile)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof KtElement)) {
                v1 = null;
            }
            return v1;
        }

        /*
         * WARNING - void declaration
         */
        private final List<KtElement> getDeclarationsToCopy(PsiElement $this$getDeclarationsToCopy) {
            List list2;
            KtElement declarationOrFile = this.getCopyableElement($this$getDeclarationsToCopy);
            if (declarationOrFile instanceof KtFile) {
                Collection collection;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((KtFile)declarationOrFile).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    boolean bl = false;
                    collection = CollectionsKt.listOf((Object)declarationOrFile);
                } else {
                    void var3_3;
                    collection = var3_3;
                }
                list2 = (List)collection;
            } else {
                list2 = declarationOrFile instanceof KtNamedDeclaration ? CollectionsKt.listOf((Object)declarationOrFile) : CollectionsKt.emptyList();
            }
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

