/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run.script.standalone;

import com.intellij.DynamicBundle;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.run.script.standalone.KotlinStandaloneScriptRunConfiguration;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

public class KotlinStandaloneScriptRunConfigurationEditor
extends SettingsEditor<KotlinStandaloneScriptRunConfiguration>
implements PanelWithAnchor {
    private JPanel mainPanel;
    private CommonJavaParametersPanel commonProgramParameters;
    private JrePathEditor jrePathEditor;
    private TextFieldWithBrowseButton chooseScriptFileTextField;
    private LabeledComponent<TextFieldWithBrowseButton> chooseScriptFileComponent;
    private LabeledComponent<ShortenCommandLineModeCombo> shortenClasspathModeCombo;
    private JComponent anchor;

    public KotlinStandaloneScriptRunConfigurationEditor(Project project2) {
        this.$$$setupUI$$$();
        this.initChooseFileField(project2);
        this.jrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk((Project)project2));
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.chooseScriptFileComponent, this.commonProgramParameters, this.jrePathEditor, this.shortenClasspathModeCombo});
        this.shortenClasspathModeCombo.setComponent((JComponent)new ShortenCommandLineModeCombo(project2, this.jrePathEditor, () -> null, listener2 -> {}));
    }

    void initChooseFileField(Project project2) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file2 -> file2.isDirectory() || KotlinParserDefinition.STD_SCRIPT_SUFFIX.equals(file2.getExtension())).withTreeRootVisible(true);
        this.chooseScriptFileTextField.addBrowseFolderListener(KotlinJvmBundle.message("script.choose.file", new Object[0]), null, project2, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    protected void resetEditorFrom(@NotNull KotlinStandaloneScriptRunConfiguration configuration2) {
        if (configuration2 == null) {
            KotlinStandaloneScriptRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.commonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration2);
        String path2 = configuration2.filePath;
        this.chooseScriptFileTextField.setText(path2 != null ? path2 : "");
        this.jrePathEditor.setPathOrName(configuration2.getAlternativeJrePath(), configuration2.isAlternativeJrePathEnabled());
        ((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).setSelectedItem((Object)configuration2.getShortenCommandLine());
    }

    protected void applyEditorTo(@NotNull KotlinStandaloneScriptRunConfiguration configuration2) {
        if (configuration2 == null) {
            KotlinStandaloneScriptRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.commonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration2);
        configuration2.setAlternativeJrePath(this.jrePathEditor.getJrePathOrName());
        configuration2.setAlternativeJrePathEnabled(this.jrePathEditor.isAlternativeJreSelected());
        configuration2.filePath = this.chooseScriptFileTextField.getText();
        configuration2.setShortenCommandLine(((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).getSelectedItem());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel2 = this.mainPanel;
        if (jPanel2 == null) {
            KotlinStandaloneScriptRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel2;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.commonProgramParameters.setAnchor(anchor);
        this.jrePathEditor.setAnchor(anchor);
        this.chooseScriptFileComponent.setAnchor(anchor);
        this.shortenClasspathModeCombo.setAnchor(anchor);
    }

    private void createUIComponents() {
        this.chooseScriptFileComponent = new LabeledComponent();
        this.chooseScriptFileTextField = new TextFieldWithBrowseButton();
        this.chooseScriptFileComponent.setComponent((JComponent)this.chooseScriptFileTextField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/run/script/standalone/KotlinStandaloneScriptRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/run/script/standalone/KotlinStandaloneScriptRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JrePathEditor jrePathEditor;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.commonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel2.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.jrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel2.add((Component)jrePathEditor, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent2 = this.chooseScriptFileComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", KotlinStandaloneScriptRunConfigurationEditor.class).getString("configuration.title.script.file"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.shortenClasspathModeCombo = labeledComponent = new LabeledComponent();
        labeledComponent.setEnabled(true);
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinStandaloneScriptRunConfigurationEditor.class).getString("application.configuration.shorten.command.line.label"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

