/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J(\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\n\u001a>\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e0\u000bj\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0011j\b\u0012\u0004\u0012\u00020\u0004`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "", "methods", "", "Lcom/intellij/psi/PsiMethod;", "isOpenClass", "", "referenceSearcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "(Ljava/util/Collection;ZLorg/jetbrains/kotlin/j2k/ReferenceSearcher;)V", "methodToLastParameterDefaults", "Ljava/util/HashMap;", "Ljava/util/ArrayList;", "Lcom/intellij/psi/PsiExpression;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "methodsToDrop", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "buildOverloadEquivalenceMap", "", "Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "calcTargetParameterDefaults", "", "method", "target", "targetCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "dropOverloadsForDefaultValues", "", "equivalenceMap", "findEquivalentOverload", "overloads", "getAnnotationsFingerprint", "parameterDefault", "parameterIndex", "", "shouldDropMethod", "shouldSkipOverload", "EquivalentOverloadInfo", "kotlin.j2k.old"})
public final class OverloadReducer {
    private final HashMap<PsiMethod, ArrayList<PsiExpression>> methodToLastParameterDefaults;
    private final HashSet<PsiMethod> methodsToDrop;
    private final Collection<PsiMethod> methods;
    private final boolean isOpenClass;
    private final ReferenceSearcher referenceSearcher;

    public final boolean shouldDropMethod(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.methodsToDrop.contains(method);
    }

    @Nullable
    public final PsiExpression parameterDefault(@NotNull PsiMethod method, int parameterIndex2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ArrayList<PsiExpression> arrayList = this.methodToLastParameterDefaults.get(method);
        if (arrayList == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"methodToLastParameterDef\u2026ts[method] ?: return null");
        ArrayList<PsiExpression> defaults2 = arrayList;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        int index2 = psiParameterList.getParametersCount() - parameterIndex2 - 1;
        return index2 < defaults2.size() ? defaults2.get(index2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PsiMethod, EquivalentOverloadInfo> buildOverloadEquivalenceMap() {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.methods;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            List key$iv$iv = CollectionsKt.listOf((Object[])new Object[]{it.isConstructor() ? null : it.getName(), UtilsKt.accessModifier((PsiModifierListOwner)it), it.getReturnType(), it.hasModifierProperty("static"), this.getAnnotationsFingerprint((PsiMethod)it)});
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterNotTo$iv$iv;
            it = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = (Iterable)it;
            boolean $i$f$filterNot = false;
            Iterable $i$f$getOrPut = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                PsiMethod it2 = (PsiMethod)element$iv$iv;
                boolean bl3 = false;
                if (this.shouldSkipOverload(it2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            object.add(list2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overloadGroups = (List)destination$iv$iv;
        HashMap map2 = new HashMap();
        for (List group : overloadGroups) {
            for (PsiMethod method : group) {
                EquivalentOverloadInfo overloadInfo;
                if (this.findEquivalentOverload(method, group) == null) {
                    continue;
                }
                EquivalentOverloadInfo furtherOverloadInfo = (EquivalentOverloadInfo)map2.get(overloadInfo.getMethod());
                EquivalentOverloadInfo resultOverloadInfo = furtherOverloadInfo != null ? new EquivalentOverloadInfo(furtherOverloadInfo.getMethod(), CollectionsKt.plus((Collection)overloadInfo.getParameterDefaults(), (Iterable)furtherOverloadInfo.getParameterDefaults())) : overloadInfo;
                ((Map)map2).put(method, resultOverloadInfo);
                for (Map.Entry entry : map2.entrySet()) {
                    if (!Intrinsics.areEqual((Object)((EquivalentOverloadInfo)entry.getValue()).getMethod(), (Object)method)) continue;
                    List newParameterDefaults = CollectionsKt.plus((Collection)((EquivalentOverloadInfo)entry.getValue()).getParameterDefaults(), (Iterable)resultOverloadInfo.getParameterDefaults());
                    entry.setValue(new EquivalentOverloadInfo(resultOverloadInfo.getMethod(), newParameterDefaults));
                }
            }
        }
        return map2;
    }

    private final boolean shouldSkipOverload(PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        if (method.hasModifierProperty("native")) {
            return true;
        }
        if (method.hasModifierProperty("synchronized")) {
            return true;
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = method.getHierarchicalMethodSignature();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature, (String)"method.hierarchicalMethodSignature");
        List list2 = hierarchicalMethodSignature.getSuperSignatures();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"method.hierarchicalMethodSignature.superSignatures");
        Collection collection = list2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        return this.isOpenClass && this.referenceSearcher.hasOverrides(method);
    }

    private final EquivalentOverloadInfo findEquivalentOverload(PsiMethod method, Collection<? extends PsiMethod> overloads) {
        String string;
        PsiExpression psiExpression;
        PsiStatement statement;
        PsiStatement psiStatement = method.getBody();
        if (psiStatement == null || (psiStatement = psiStatement.getStatements()) == null || (psiStatement = (PsiStatement)ArraysKt.singleOrNull((Object[])psiStatement)) == null) {
            return null;
        }
        PsiStatement psiStatement2 = statement = psiStatement;
        if (!((psiStatement2 instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : (psiExpression = psiStatement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null)) instanceof PsiMethodCallExpression)) {
            psiExpression = null;
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiExpression;
        if (psiMethodCallExpression == null) {
            return null;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        if (method.isConstructor()) {
            string = "this";
        } else {
            String string2 = method.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name");
        }
        String expectedMethodName = string;
        PsiReferenceExpression psiReferenceExpression = methodCall.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"methodCall.methodExpression");
        PsiReferenceExpression refExpr = psiReferenceExpression;
        if (refExpr.isQualified() || Intrinsics.areEqual((Object)refExpr.getReferenceName(), (Object)expectedMethodName) ^ true) {
            return null;
        }
        PsiElement psiElement2 = refExpr.resolve();
        if (!(psiElement2 instanceof PsiMethod)) {
            psiElement2 = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement2;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod target2 = psiMethod;
        if (!overloads.contains(target2)) {
            return null;
        }
        List<PsiExpression> list2 = this.calcTargetParameterDefaults(method, target2, methodCall);
        if (list2 == null) {
            return null;
        }
        List<PsiExpression> parameterDefaults = list2;
        return new EquivalentOverloadInfo(target2, parameterDefaults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiExpression> calcTargetParameterDefaults(PsiMethod method, PsiMethod target2, PsiMethodCallExpression targetCall) {
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] parameters2 = psiParameterList.getParameters();
        PsiParameterList psiParameterList2 = target2.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"target.parameterList");
        PsiParameter[] targetParameters = psiParameterList2.getParameters();
        if (parameters2.length >= targetParameters.length) {
            return null;
        }
        PsiExpressionList psiExpressionList = targetCall.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionList, (String)"targetCall.argumentList");
        Object[] args2 = psiExpressionList.getExpressions();
        if (args2.length != targetParameters.length) {
            return null;
        }
        int n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)parameters2, (String)"parameters");
        int n2 = parameters2.length;
        while (n < n2) {
            void i2;
            PsiParameter parameter = parameters2[i2];
            PsiParameter targetParameter = targetParameters[i2];
            PsiParameter psiParameter = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"parameter");
            String string = psiParameter.getName();
            PsiParameter psiParameter2 = targetParameter;
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter2, (String)"targetParameter");
            if (Intrinsics.areEqual((Object)string, (Object)psiParameter2.getName()) ^ true || Intrinsics.areEqual((Object)parameter.getType(), (Object)targetParameter.getType()) ^ true) {
                return null;
            }
            Object arg = args2[i2];
            if (!(arg instanceof PsiReferenceExpression) || Intrinsics.areEqual((Object)((PsiReferenceExpression)arg).resolve(), (Object)parameter) ^ true) {
                return null;
            }
            ++i2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)args2, (String)"args");
        return ArraysKt.drop((Object[])args2, (int)parameters2.length);
    }

    /*
     * WARNING - void declaration
     */
    private final void dropOverloadsForDefaultValues(Map<PsiMethod, EquivalentOverloadInfo> equivalenceMap) {
        void $this$mapTo$iv$iv22;
        Map<PsiMethod, EquivalentOverloadInfo> $this$map$iv = equivalenceMap;
        boolean $i$f$map = false;
        Map<PsiMethod, EquivalentOverloadInfo> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv22;
        boolean bl = false;
        Iterator iterator = var8_9.entrySet().iterator();
        while (iterator.hasNext()) {
            void it22;
            Map.Entry item$iv$iv22;
            Map.Entry entry = item$iv$iv22 = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            PsiMethod psiMethod = (PsiMethod)it22.getKey();
            collection.add(psiMethod);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        boolean $this$mapTo$iv$iv22 = false;
        List dropCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PsiMethod it = (PsiMethod)b;
                boolean bl2 = false;
                PsiParameterList psiParameterList = it.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"it.parameterList");
                it = (PsiMethod)a;
                Comparable comparable = Integer.valueOf(psiParameterList.getParametersCount());
                bl2 = false;
                PsiParameterList psiParameterList2 = it.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"it.parameterList");
                Integer n = psiParameterList2.getParametersCount();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        block1: for (PsiMethod method : dropCandidates) {
            Object object;
            void $this$getOrPut$iv22;
            EquivalentOverloadInfo targetInfo;
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
            int paramCount = psiParameterList.getParametersCount();
            Intrinsics.checkNotNull((Object)equivalenceMap.get(method));
            PsiParameterList psiParameterList2 = targetInfo.getMethod().getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"targetInfo.method.parameterList");
            int targetParamCount = psiParameterList2.getParametersCount();
            boolean bl3 = paramCount < targetParamCount;
            bl = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean item$iv$iv22 = false;
                String item$iv$iv22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)item$iv$iv22));
            }
            List<PsiExpression> defaults2 = targetInfo.getParameterDefaults();
            bl = defaults2.size() == targetParamCount - paramCount;
            bl4 = false;
            boolean item$iv$iv22 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean it22 = false;
                String it22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)it22));
            }
            Map map3 = this.methodToLastParameterDefaults;
            PsiMethod key$iv = targetInfo.getMethod();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl5 = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList targetDefaults = (ArrayList)object;
            int $this$getOrPut$iv22 = 0;
            int n = ((Collection)defaults2).size();
            while ($this$getOrPut$iv22 < n) {
                void i2;
                PsiExpression psiExpression = defaults2.get(defaults2.size() - i2 - 1);
                if (i2 < targetDefaults.size()) {
                    Object e = targetDefaults.get((int)i2);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"targetDefaults[i]");
                    if (Intrinsics.areEqual((Object)((PsiExpression)e).getText(), (Object)psiExpression.getText()) ^ true) {
                        continue block1;
                    }
                } else {
                    targetDefaults.add(psiExpression);
                }
                ++i2;
            }
            this.methodsToDrop.add(method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object getAnnotationsFingerprint(PsiMethod method) {
        void $this$mapTo$iv$iv;
        PsiModifierList psiModifierList = method.getModifierList();
        Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"method.modifierList");
        PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"method.modifierList.annotations");
        PsiAnnotation[] $this$map$iv = psiAnnotationArray;
        boolean $i$f$map = false;
        PsiAnnotation[] psiAnnotationArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            String string = v2.getText();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public OverloadReducer(@NotNull Collection<? extends PsiMethod> methods2, boolean isOpenClass, @NotNull ReferenceSearcher referenceSearcher) {
        Intrinsics.checkNotNullParameter(methods2, (String)"methods");
        Intrinsics.checkNotNullParameter((Object)referenceSearcher, (String)"referenceSearcher");
        this.methods = methods2;
        this.isOpenClass = isOpenClass;
        this.referenceSearcher = referenceSearcher;
        this.methodToLastParameterDefaults = new HashMap();
        this.methodsToDrop = new HashSet();
        Map<PsiMethod, EquivalentOverloadInfo> map2 = this.buildOverloadEquivalenceMap();
        this.dropOverloadsForDefaultValues(map2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "", "method", "Lcom/intellij/psi/PsiMethod;", "parameterDefaults", "", "Lcom/intellij/psi/PsiExpression;", "(Lcom/intellij/psi/PsiMethod;Ljava/util/List;)V", "getMethod", "()Lcom/intellij/psi/PsiMethod;", "getParameterDefaults", "()Ljava/util/List;", "kotlin.j2k.old"})
    private static final class EquivalentOverloadInfo {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final List<PsiExpression> parameterDefaults;

        @NotNull
        public final PsiMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final List<PsiExpression> getParameterDefaults() {
            return this.parameterDefaults;
        }

        public EquivalentOverloadInfo(@NotNull PsiMethod method, @NotNull List<? extends PsiExpression> parameterDefaults) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(parameterDefaults, (String)"parameterDefaults");
            this.method = method;
            this.parameterDefaults = parameterDefaults;
        }
    }
}

