/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import com.intellij.openapi.util.io.JarUtil;
import java.io.File;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\rJ\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader;", "", "()V", "CLASS_SUFFIX", "", "MINIMAL_SUPPORTED_VERSION", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getMINIMAL_SUPPORTED_VERSION", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "REQUIRE_KOTLIN_VERSION", "Ljava/util/jar/Attributes$Name;", "VERSIONS_SLICE", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "minVersionForInlineClasses", "getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin", "canSupportInlineClasses", "", "module", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVersionsForCurrentModule", "getVersionsForCurrentModuleFromContext", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getVersionsForCurrentModuleFromTrace", "getVersionsFromManifest", "runtimeLibraryPath", "Ljava/io/File;", "RuntimeVersions", "kotlinx-serialization-compiler-plugin"})
public final class VersionReader {
    @NotNull
    public static final VersionReader INSTANCE = new VersionReader();
    @NotNull
    private static final ApiVersion MINIMAL_SUPPORTED_VERSION;
    @NotNull
    private static final Attributes.Name REQUIRE_KOTLIN_VERSION;
    @NotNull
    private static final String CLASS_SUFFIX = "!/kotlinx/serialization/KSerializer.class";
    @NotNull
    private static final WritableSlice<ModuleDescriptor, RuntimeVersions> VERSIONS_SLICE;
    @NotNull
    private static final ApiVersion minVersionForInlineClasses;

    private VersionReader() {
    }

    @NotNull
    public final RuntimeVersions getVersionsFromManifest(@NotNull File runtimeLibraryPath) {
        ApiVersion apiVersion2;
        boolean bl;
        Object object;
        String string;
        ApiVersion apiVersion3;
        Intrinsics.checkNotNullParameter((Object)runtimeLibraryPath, (String)"runtimeLibraryPath");
        String string2 = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string2 == null) {
            apiVersion3 = null;
        } else {
            string = string2;
            object = ApiVersion.Companion;
            boolean bl2 = false;
            bl = false;
            String p0 = string;
            boolean bl3 = false;
            apiVersion3 = object.parse(p0);
        }
        ApiVersion version2 = apiVersion3;
        string = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)REQUIRE_KOTLIN_VERSION);
        if (string == null) {
            apiVersion2 = null;
        } else {
            object = string;
            ApiVersion.Companion companion = ApiVersion.Companion;
            bl = false;
            boolean bl4 = false;
            Object p0 = object;
            boolean bl5 = false;
            apiVersion2 = companion.parse((String)p0);
        }
        ApiVersion kotlinVersion2 = apiVersion2;
        return new RuntimeVersions(version2, kotlinVersion2);
    }

    @NotNull
    public final ApiVersion getMINIMAL_SUPPORTED_VERSION() {
        return MINIMAL_SUPPORTED_VERSION;
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModuleFromTrace(@NotNull ModuleDescriptor module2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        RuntimeVersions runtimeVersions = (RuntimeVersions)trace.get((ReadOnlySlice)VERSIONS_SLICE, (Object)module2);
        if (runtimeVersions != null) {
            RuntimeVersions runtimeVersions2 = runtimeVersions;
            boolean bl = false;
            boolean bl2 = false;
            RuntimeVersions it = runtimeVersions2;
            boolean bl3 = false;
            return it;
        }
        RuntimeVersions runtimeVersions3 = this.getVersionsForCurrentModule(module2);
        if (runtimeVersions3 == null) {
            return null;
        }
        RuntimeVersions versions = runtimeVersions3;
        trace.record(VERSIONS_SLICE, (Object)module2, (Object)versions);
        return versions;
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModuleFromContext(@NotNull ModuleDescriptor module2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RuntimeVersions runtimeVersions = (RuntimeVersions)context2.get((ReadOnlySlice)VERSIONS_SLICE, (Object)module2);
        if (runtimeVersions != null) {
            RuntimeVersions runtimeVersions2 = runtimeVersions;
            boolean bl = false;
            boolean bl2 = false;
            RuntimeVersions it = runtimeVersions2;
            boolean bl3 = false;
            return it;
        }
        return this.getVersionsForCurrentModule(module2);
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModule(@NotNull ModuleDescriptor module2) {
        String string;
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ClassDescriptor markerClass = SearchUtilsKt.getClassFromSerializationPackage(module2, "KSerializer");
        SourceElement sourceElement = markerClass.getSource();
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement2 = kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
        String string2 = kotlinJvmBinarySourceElement == null ? null : (string = (sourceElement = kotlinJvmBinarySourceElement.getBinaryClass()) == null ? null : sourceElement.getLocation());
        if (string == null) {
            return null;
        }
        String location2 = string;
        String jarFile = StringsKt.removeSuffix((String)location2, (CharSequence)CLASS_SUFFIX);
        if (!StringsKt.endsWith$default((String)jarFile, (String)".jar", (boolean)false, (int)2, null)) {
            return null;
        }
        File file2 = new File(jarFile);
        if (!file2.exists()) {
            return null;
        }
        return this.getVersionsFromManifest(file2);
    }

    @NotNull
    public final ApiVersion getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin() {
        return minVersionForInlineClasses;
    }

    public final boolean canSupportInlineClasses(@NotNull ModuleDescriptor module2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        RuntimeVersions runtimeVersions = this.getVersionsForCurrentModuleFromTrace(module2, trace);
        if (runtimeVersions == null) {
            return true;
        }
        RuntimeVersions currentVersion = runtimeVersions;
        ApiVersion apiVersion2 = currentVersion.getImplementationVersion();
        if (apiVersion2 == null) {
            return false;
        }
        ApiVersion implVersion = apiVersion2;
        return implVersion.compareTo(minVersionForInlineClasses) >= 0;
    }

    static {
        ApiVersion apiVersion2 = ApiVersion.Companion.parse("1.0-M1-SNAPSHOT");
        Intrinsics.checkNotNull((Object)apiVersion2);
        MINIMAL_SUPPORTED_VERSION = apiVersion2;
        REQUIRE_KOTLIN_VERSION = new Attributes.Name("Require-Kotlin-Version");
        apiVersion2 = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue((Object)apiVersion2, (String)"createSimpleSlice()");
        VERSIONS_SLICE = apiVersion2;
        apiVersion2 = ApiVersion.Companion.parse("1.1-M1-SNAPSHOT");
        Intrinsics.checkNotNull((Object)apiVersion2);
        minVersionForInlineClasses = apiVersion2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\rJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "", "implementationVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "requireKotlinVersion", "(Lorg/jetbrains/kotlin/config/ApiVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getImplementationVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getRequireKotlinVersion", "component1", "component2", "copy", "currentCompilerMatchRequired", "", "equals", "other", "hashCode", "", "implementationVersionMatchSupported", "toString", "", "kotlinx-serialization-compiler-plugin"})
    public static final class RuntimeVersions {
        @Nullable
        private final ApiVersion implementationVersion;
        @Nullable
        private final ApiVersion requireKotlinVersion;

        public RuntimeVersions(@Nullable ApiVersion implementationVersion, @Nullable ApiVersion requireKotlinVersion) {
            this.implementationVersion = implementationVersion;
            this.requireKotlinVersion = requireKotlinVersion;
        }

        @Nullable
        public final ApiVersion getImplementationVersion() {
            return this.implementationVersion;
        }

        @Nullable
        public final ApiVersion getRequireKotlinVersion() {
            return this.requireKotlinVersion;
        }

        public final boolean currentCompilerMatchRequired() {
            boolean bl;
            boolean bl2;
            ApiVersion apiVersion2;
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                apiVersion2 = null;
            } else {
                String string2 = string;
                ApiVersion.Companion companion = ApiVersion.Companion;
                bl2 = false;
                bl = false;
                String p0 = string2;
                boolean bl3 = false;
                apiVersion2 = companion.parse(p0);
            }
            string = apiVersion2;
            boolean bl4 = false;
            boolean bl5 = false;
            bl5 = false;
            bl2 = false;
            if (string == null) {
                bl = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String current = string;
            return this.requireKotlinVersion == null || this.requireKotlinVersion.compareTo((ApiVersion)current) <= 0;
        }

        public final boolean implementationVersionMatchSupported() {
            return this.implementationVersion != null && this.implementationVersion.compareTo(INSTANCE.getMINIMAL_SUPPORTED_VERSION()) >= 0;
        }

        @Nullable
        public final ApiVersion component1() {
            return this.implementationVersion;
        }

        @Nullable
        public final ApiVersion component2() {
            return this.requireKotlinVersion;
        }

        @NotNull
        public final RuntimeVersions copy(@Nullable ApiVersion implementationVersion, @Nullable ApiVersion requireKotlinVersion) {
            return new RuntimeVersions(implementationVersion, requireKotlinVersion);
        }

        public static /* synthetic */ RuntimeVersions copy$default(RuntimeVersions runtimeVersions, ApiVersion apiVersion2, ApiVersion apiVersion3, int n, Object object) {
            if ((n & 1) != 0) {
                apiVersion2 = runtimeVersions.implementationVersion;
            }
            if ((n & 2) != 0) {
                apiVersion3 = runtimeVersions.requireKotlinVersion;
            }
            return runtimeVersions.copy(apiVersion2, apiVersion3);
        }

        @NotNull
        public String toString() {
            return "RuntimeVersions(implementationVersion=" + this.implementationVersion + ", requireKotlinVersion=" + this.requireKotlinVersion + ')';
        }

        public int hashCode() {
            int result2 = this.implementationVersion == null ? 0 : this.implementationVersion.hashCode();
            result2 = result2 * 31 + (this.requireKotlinVersion == null ? 0 : this.requireKotlinVersion.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RuntimeVersions)) {
                return false;
            }
            RuntimeVersions runtimeVersions = (RuntimeVersions)other;
            if (!Intrinsics.areEqual((Object)this.implementationVersion, (Object)runtimeVersions.implementationVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.requireKotlinVersion, (Object)runtimeVersions.requireKotlinVersion);
        }
    }
}

