/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;

public class RecompilationSpec {
    private final Set<String> classesToCompile = new LinkedHashSet<String>();
    private final Collection<String> classesToProcess = new LinkedHashSet<String>();
    private final Collection<GeneratedResource> resourcesToGenerate = new LinkedHashSet<GeneratedResource>();
    private final Set<String> relativeSourcePathsToCompile = new LinkedHashSet<String>();
    private final PreviousCompilation previousCompilation;
    private String fullRebuildCause;

    public RecompilationSpec(PreviousCompilation previousCompilation) {
        this.previousCompilation = previousCompilation;
    }

    public String toString() {
        return "RecompilationSpec{classesToCompile=" + this.classesToCompile + ", classesToProcess=" + this.classesToProcess + ", resourcesToGenerate=" + this.resourcesToGenerate + ", relativeSourcePathsToCompile=" + this.relativeSourcePathsToCompile + ", fullRebuildCause='" + this.fullRebuildCause + '\'' + ", buildNeeded=" + this.isBuildNeeded() + ", fullRebuildNeeded=" + this.isFullRebuildNeeded() + '}';
    }

    public void addClassesToCompile(Collection<String> classes) {
        this.classesToCompile.addAll(classes);
    }

    public Set<String> getClassesToCompile() {
        return Collections.unmodifiableSet(this.classesToCompile);
    }

    public PreviousCompilation getPreviousCompilation() {
        return this.previousCompilation;
    }

    public void addRelativeSourcePathsToCompile(Collection<String> paths) {
        this.relativeSourcePathsToCompile.addAll(paths);
    }

    public void addRelativeSourcePathToCompile(String path) {
        this.relativeSourcePathsToCompile.add(path);
    }

    public Set<String> getRelativeSourcePathsToCompile() {
        return Collections.unmodifiableSet(this.relativeSourcePathsToCompile);
    }

    public void addClassesToProcess(Collection<String> classes) {
        this.classesToProcess.addAll(classes);
    }

    public Collection<String> getClassesToProcess() {
        return Collections.unmodifiableCollection(this.classesToProcess);
    }

    public void addResourcesToGenerate(Collection<GeneratedResource> resources) {
        this.resourcesToGenerate.addAll(resources);
    }

    public Collection<GeneratedResource> getResourcesToGenerate() {
        return Collections.unmodifiableCollection(this.resourcesToGenerate);
    }

    public boolean isBuildNeeded() {
        return this.isFullRebuildNeeded() || !this.classesToCompile.isEmpty() || !this.classesToProcess.isEmpty() || !this.relativeSourcePathsToCompile.isEmpty();
    }

    public boolean isFullRebuildNeeded() {
        return this.fullRebuildCause != null;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public void setFullRebuildCause(String description) {
        this.fullRebuildCause = description;
    }
}

