/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.util.internal.RelativePathUtil;

public class DefaultBasePluginExtension
implements BasePluginExtension {
    private final Project project;
    private final DirectoryProperty distsDirectory;
    private final DirectoryProperty libsDirectory;
    private final Property<String> archivesName;

    public DefaultBasePluginExtension(Project project) {
        this.project = project;
        this.distsDirectory = project.getObjects().directoryProperty();
        this.libsDirectory = project.getObjects().directoryProperty();
        this.archivesName = project.getObjects().property(String.class);
    }

    @Override
    public DirectoryProperty getDistsDirectory() {
        return this.distsDirectory;
    }

    @Override
    public DirectoryProperty getLibsDirectory() {
        return this.libsDirectory;
    }

    @Override
    public Property<String> getArchivesName() {
        return this.archivesName;
    }

    @Override
    public String getDistsDirName() {
        File buildDir = ((Directory)this.project.getLayout().getBuildDirectory().get()).getAsFile();
        File distsDir = ((Directory)this.getDistsDirectory().get()).getAsFile();
        return RelativePathUtil.relativePath(buildDir, distsDir);
    }

    @Override
    public void setDistsDirName(String distsDirName) {
        this.getDistsDirectory().set(this.project.getLayout().getBuildDirectory().dir(distsDirName));
    }

    @Override
    public String getLibsDirName() {
        File buildDir = ((Directory)this.project.getLayout().getBuildDirectory().get()).getAsFile();
        File libsDir = ((Directory)this.getLibsDirectory().get()).getAsFile();
        return RelativePathUtil.relativePath(buildDir, libsDir);
    }

    @Override
    public void setLibsDirName(String libsDirName) {
        this.getLibsDirectory().set(this.project.getLayout().getBuildDirectory().dir(libsDirName));
    }

    @Override
    public String getArchivesBaseName() {
        return (String)this.getArchivesName().get();
    }

    @Override
    public void setArchivesBaseName(String archivesBaseName) {
        this.getArchivesName().set(archivesBaseName);
    }
}

