/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.GUtil;

public abstract class AbstractArchiveTask
extends AbstractCopyTask {
    private final DirectoryProperty archiveDestinationDirectory;
    private final RegularFileProperty archiveFile;
    private final Property<String> archiveName;
    private final Property<String> archiveBaseName;
    private final Property<String> archiveAppendix;
    private final Property<String> archiveVersion;
    private final Property<String> archiveExtension;
    private final Property<String> archiveClassifier;
    private final Property<Boolean> archivePreserveFileTimestamps;
    private final Property<Boolean> archiveReproducibleFileOrder;

    public AbstractArchiveTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.archiveDestinationDirectory = objectFactory.directoryProperty();
        this.archiveBaseName = objectFactory.property(String.class);
        this.archiveAppendix = objectFactory.property(String.class);
        this.archiveVersion = objectFactory.property(String.class);
        this.archiveExtension = objectFactory.property(String.class);
        this.archiveClassifier = objectFactory.property(String.class).convention("");
        this.archiveName = objectFactory.property(String.class);
        this.archiveName.convention(this.getProject().provider(() -> {
            String name = GUtil.elvis((String)this.archiveBaseName.getOrNull(), "");
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveAppendix.getOrNull());
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveVersion.getOrNull());
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveClassifier.getOrNull());
            String extension = (String)this.archiveExtension.getOrNull();
            name = name + (GUtil.isTrue(extension) ? "." + extension : "");
            return name;
        }));
        this.archiveFile = objectFactory.fileProperty();
        this.archiveFile.convention(this.archiveDestinationDirectory.file(this.archiveName));
        this.archivePreserveFileTimestamps = objectFactory.property(Boolean.class).convention(true);
        this.archiveReproducibleFileOrder = objectFactory.property(Boolean.class).convention(false);
    }

    private static String maybe(@Nullable String prefix, @Nullable String value) {
        if (GUtil.isTrue(value)) {
            if (GUtil.isTrue(prefix)) {
                return "-".concat(value);
            }
            return value;
        }
        return "";
    }

    @Deprecated
    @ReplacedBy(value="archiveFileName")
    public String getArchiveName() {
        return (String)this.archiveName.get();
    }

    @Deprecated
    public void setArchiveName(String name) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "archiveName").replaceWith("archiveFileName")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.archiveName.convention(name);
        this.archiveName.set(name);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveFileName() {
        return this.archiveName;
    }

    @Deprecated
    @ReplacedBy(value="archiveFile")
    public File getArchivePath() {
        return this.getArchiveFile().get().getAsFile();
    }

    @OutputFile
    public Provider<RegularFile> getArchiveFile() {
        return this.archiveFile;
    }

    @Deprecated
    @ReplacedBy(value="destinationDirectory")
    public File getDestinationDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "destinationDir").replaceWith("destinationDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
        return this.archiveDestinationDirectory.getAsFile().get();
    }

    @Deprecated
    public void setDestinationDir(File destinationDir) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "destinationDir").replaceWith("destinationDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.archiveDestinationDirectory.set(this.getProject().file(destinationDir));
    }

    @Internal(value="Represented by the archiveFile")
    public DirectoryProperty getDestinationDirectory() {
        return this.archiveDestinationDirectory;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="archiveBaseName")
    public String getBaseName() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "baseName").replaceWith("archiveBaseName")).willBeRemovedInGradle8().withDslReference().nagUser();
        return (String)this.archiveBaseName.getOrNull();
    }

    @Deprecated
    public void setBaseName(@Nullable String baseName) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "baseName").replaceWith("archiveBaseName")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.archiveBaseName.convention(baseName);
        this.archiveBaseName.set(baseName);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveBaseName() {
        return this.archiveBaseName;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="archiveAppendix")
    public String getAppendix() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "appendix").replaceWith("archiveAppendix")).willBeRemovedInGradle8().withDslReference().nagUser();
        return (String)this.archiveAppendix.getOrNull();
    }

    @Deprecated
    public void setAppendix(@Nullable String appendix) {
        this.archiveAppendix.convention(appendix);
        this.archiveAppendix.set(appendix);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveAppendix() {
        return this.archiveAppendix;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="archiveVersion")
    public String getVersion() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "version").replaceWith("archiveVersion")).willBeRemovedInGradle8().withDslReference().nagUser();
        return (String)this.archiveVersion.getOrNull();
    }

    @Deprecated
    public void setVersion(@Nullable String version) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "version").replaceWith("archiveVersion")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.archiveVersion.convention(version);
        this.archiveVersion.set(version);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveVersion() {
        return this.archiveVersion;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="archiveExtension")
    public String getExtension() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "extension").replaceWith("archiveExtension")).willBeRemovedInGradle8().withDslReference().nagUser();
        return (String)this.archiveExtension.getOrNull();
    }

    @Deprecated
    public void setExtension(@Nullable String extension) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "extension").replaceWith("archiveExtension")).willBeRemovedInGradle8().withDslReference().nagUser();
        this.archiveExtension.convention(extension);
        this.archiveExtension.set(extension);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveExtension() {
        return this.archiveExtension;
    }

    @Nullable
    @Deprecated
    @ReplacedBy(value="archiveClassifier")
    public String getClassifier() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractArchiveTask.class, "classifier").replaceWith("archiveClassifier")).willBeRemovedInGradle8().withDslReference().nagUser();
        return (String)this.archiveClassifier.getOrNull();
    }

    @Deprecated
    public void setClassifier(@Nullable String classifier) {
        this.archiveClassifier.convention(classifier);
        this.archiveClassifier.set(classifier);
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveClassifier() {
        return this.archiveClassifier;
    }

    @Override
    public AbstractArchiveTask into(Object destPath) {
        super.into(destPath);
        return this;
    }

    @Override
    public AbstractArchiveTask into(Object destPath, Closure configureClosure) {
        super.into(destPath, configureClosure);
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        super.into(destPath, copySpec);
        return this;
    }

    @Input
    public boolean isPreserveFileTimestamps() {
        return (Boolean)this.archivePreserveFileTimestamps.get();
    }

    public void setPreserveFileTimestamps(boolean preserveFileTimestamps) {
        this.archivePreserveFileTimestamps.set(preserveFileTimestamps);
    }

    @Input
    public boolean isReproducibleFileOrder() {
        return (Boolean)this.archiveReproducibleFileOrder.get();
    }

    public void setReproducibleFileOrder(boolean reproducibleFileOrder) {
        this.archiveReproducibleFileOrder.set(reproducibleFileOrder);
    }

    @Override
    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, fileSystem, this.isReproducibleFileOrder(), this.getDocumentationRegistry());
    }
}

