/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Function;
import org.gradle.BuildResult;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildOperationFiringBuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.DefaultBuildTreeLifecycleController;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractCompositeParticipantBuildState
implements RootBuildState,
Stoppable {
    private final ListenerManager listenerManager;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildLifecycleController buildLifecycleController;
    private final DefaultBuildTreeLifecycleController buildController;
    private boolean completed;

    DefaultRootBuildState(BuildDefinition buildDefinition, BuildTreeState buildTree, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ListenerManager listenerManager, ProjectStateRegistry projectStateRegistry) {
        this.listenerManager = listenerManager;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, this, null, buildScopeServices);
        IncludedBuildControllers controllers = buildScopeServices.get(IncludedBuildControllers.class);
        WorkerLeaseService workerLeaseService = buildScopeServices.get(WorkerLeaseService.class);
        ExceptionAnalyser exceptionAnalyser = buildScopeServices.get(ExceptionAnalyser.class);
        BuildOperationExecutor buildOperationExecutor = buildScopeServices.get(BuildOperationExecutor.class);
        BuildOperationFiringBuildTreeWorkExecutor workExecutor = new BuildOperationFiringBuildTreeWorkExecutor(new DefaultBuildTreeWorkExecutor(controllers, this.buildLifecycleController), buildOperationExecutor);
        this.buildController = new DefaultBuildTreeLifecycleController(this.buildLifecycleController, workerLeaseService, workExecutor, controllers, exceptionAnalyser);
    }

    @Override
    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    @Override
    public Path getIdentityPath() {
        return Path.ROOT;
    }

    @Override
    public boolean isImplicitBuild() {
        return false;
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    @Override
    public File getBuildRootDir() {
        return this.buildLifecycleController.getGradle().getServices().get(BuildLayout.class).getRootDirectory();
    }

    @Override
    public void stop() {
        this.buildLifecycleController.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Function<? super BuildTreeLifecycleController, T> action) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for a build.");
        }
        try {
            T t;
            RootBuildLifecycleListener buildLifecycleListener = this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
            buildLifecycleListener.afterStart();
            try {
                GradleInternal gradle = this.buildLifecycleController.getGradle();
                final DefaultDeploymentRegistry deploymentRegistry = gradle.getServices().get(DefaultDeploymentRegistry.class);
                gradle.addBuildListener(new InternalBuildAdapter(){

                    @Override
                    public void buildFinished(BuildResult result) {
                        deploymentRegistry.buildFinished(result);
                    }
                });
                t = action.apply(this.buildController);
                buildLifecycleListener.beforeComplete();
            }
            catch (Throwable throwable) {
                buildLifecycleListener.beforeComplete();
                throw throwable;
            }
            return t;
        }
        finally {
            this.completed = true;
        }
    }

    @Override
    public StartParameterInternal getStartParameter() {
        return this.buildLifecycleController.getGradle().getStartParameter();
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.buildLifecycleController.getGradle().getSettings();
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return Path.ROOT;
    }

    @Override
    public Path getIdentityPathForProject(Path path) {
        return path;
    }

    @Override
    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    @Override
    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }
}

