/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.ProgressBar;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.FlushOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;

public class BuildStatusRenderer
implements OutputEventListener {
    public static final int PROGRESS_BAR_WIDTH = 13;
    public static final String PROGRESS_BAR_PREFIX = "<";
    public static final char PROGRESS_BAR_COMPLETE_CHAR = '=';
    public static final char PROGRESS_BAR_INCOMPLETE_CHAR = '-';
    public static final String PROGRESS_BAR_SUFFIX = ">";
    private final OutputEventListener listener;
    private final StyledLabel buildStatusLabel;
    private final Console console;
    private final ConsoleMetaData consoleMetaData;
    private OperationIdentifier buildProgressOperationId;
    private Phase currentPhase;
    private final Set<OperationIdentifier> currentPhaseChildren = new HashSet<OperationIdentifier>();
    private long currentTimePeriod;
    private ProgressBar progressBar;
    private long buildStartTimestamp;
    private boolean timerEnabled;

    public BuildStatusRenderer(OutputEventListener listener, StyledLabel buildStatusLabel, Console console, ConsoleMetaData consoleMetaData) {
        this.listener = listener;
        this.buildStatusLabel = buildStatusLabel;
        this.console = console;
        this.consoleMetaData = consoleMetaData;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (startEvent.isBuildOperationStart()) {
                if (this.buildStartTimestamp == 0L && startEvent.getParentProgressOperationId() == null) {
                    this.buildStartTimestamp = startEvent.getTimestamp();
                    this.buildProgressOperationId = startEvent.getProgressOperationId();
                    this.phaseStarted(startEvent, Phase.Initializing);
                } else if (startEvent.getBuildOperationCategory() == BuildOperationCategory.CONFIGURE_ROOT_BUILD) {
                    this.phaseStarted(startEvent, Phase.Configuring);
                } else if (startEvent.getBuildOperationCategory() == BuildOperationCategory.CONFIGURE_BUILD && this.currentPhase == Phase.Configuring) {
                    this.phaseHasMoreProgress(startEvent);
                } else if (startEvent.getBuildOperationCategory() == BuildOperationCategory.CONFIGURE_PROJECT && this.currentPhase == Phase.Configuring) {
                    this.currentPhaseChildren.add(startEvent.getProgressOperationId());
                } else if (startEvent.getBuildOperationCategory() == BuildOperationCategory.RUN_MAIN_TASKS) {
                    this.phaseStarted(startEvent, Phase.Executing);
                } else if (startEvent.getBuildOperationCategory() == BuildOperationCategory.RUN_WORK && this.currentPhase == Phase.Executing) {
                    this.phaseHasMoreProgress(startEvent);
                } else if (startEvent.getBuildOperationCategory().isTopLevelWorkItem() && this.currentPhase == Phase.Executing) {
                    this.currentPhaseChildren.add(startEvent.getProgressOperationId());
                }
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            if (completeEvent.getProgressOperationId().equals(this.buildProgressOperationId)) {
                this.buildEnded();
            } else if (this.currentPhaseChildren.remove(completeEvent.getProgressOperationId())) {
                this.phaseProgressed(completeEvent);
            }
        }
        this.listener.onOutput(event);
        if (event instanceof UpdateNowEvent) {
            this.currentTimePeriod = ((UpdateNowEvent)event).getTimestamp();
            this.renderNow(this.currentTimePeriod);
        } else if (event instanceof EndOutputEvent || event instanceof FlushOutputEvent) {
            this.renderNow(this.currentTimePeriod);
        }
    }

    private void renderNow(long now) {
        if (this.progressBar != null) {
            this.buildStatusLabel.setText(this.progressBar.formatProgress(this.timerEnabled, now - this.buildStartTimestamp));
        }
        this.console.flush();
    }

    private void phaseStarted(ProgressStartEvent progressStartEvent, Phase phase) {
        this.timerEnabled = true;
        this.currentPhase = phase;
        this.currentPhaseChildren.clear();
        this.progressBar = this.newProgressBar(phase.name().toUpperCase(), 0, progressStartEvent.getTotalProgress());
    }

    private void phaseHasMoreProgress(ProgressStartEvent progressStartEvent) {
        this.progressBar.moreProgress(progressStartEvent.getTotalProgress());
    }

    private void phaseProgressed(ProgressCompleteEvent progressEvent) {
        if (this.progressBar != null) {
            this.progressBar.update(progressEvent.isFailed());
        }
    }

    private void buildEnded() {
        this.progressBar = this.newProgressBar("WAITING", 0, 1);
        this.currentPhase = null;
        this.buildProgressOperationId = null;
        this.currentPhaseChildren.clear();
        this.timerEnabled = false;
    }

    @VisibleForTesting
    public ProgressBar newProgressBar(String initialSuffix, int initialProgress, int totalProgress) {
        return new ProgressBar(this.consoleMetaData, PROGRESS_BAR_PREFIX, 13, PROGRESS_BAR_SUFFIX, '=', '-', initialSuffix, initialProgress, totalProgress);
    }

    private static enum Phase {
        Initializing,
        Configuring,
        Executing;

    }
}

