/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.IdeActivityKt;
import com.intellij.internal.statistic.IdeActivityState;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.TimeoutUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Deprecated(message="Use com.intellij.internal.statistic.StructuredIdeActivity instead. It allows us to generate events scheme from the product code and ensures that only data matching the scheme is being sent.")
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0000J\u0016\u0010\u0011\u001a\u00020\u00002\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u00020\u00002\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0000J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013J \u0010\u001a\u001a\u00020\u00002\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001d0\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/internal/statistic/IdeActivity;", "", "projectOrNullForApplication", "Lcom/intellij/openapi/project/Project;", "group", "", "activityName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "id", "", "startedTimestamp", "", "state", "Lcom/intellij/internal/statistic/IdeActivityState;", "appendActivityName", "createDataWithActivityId", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "finished", "consumer", "Ljava/util/function/Consumer;", "stageStarted", "stageClass", "Ljava/lang/Class;", "stageName", "started", "startedWithData", "startedWithDataAsync", "dataSupplier", "Lkotlin/Function1;", "Lorg/jetbrains/concurrency/Promise;", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class IdeActivity {
    private final int id;
    private IdeActivityState state;
    private long startedTimestamp;
    private final Project projectOrNullForApplication;
    private final String group;
    private final String activityName;
    private static final AtomicInteger counter;
    @NotNull
    public static final String STARTED_EVENT_ID = "started";
    @NotNull
    public static final Companion Companion;

    private final FeatureUsageData createDataWithActivityId() {
        return new FeatureUsageData().addData("ide_activity_id", this.id);
    }

    @NotNull
    public final IdeActivity started() {
        return this.startedWithData(started.1.INSTANCE);
    }

    @NotNull
    public final IdeActivity startedWithData(@NotNull Consumer<FeatureUsageData> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!IdeActivityKt.access$getLOG$p().assertTrue(this.state == IdeActivityState.NOT_STARTED, (Object)this.state.name())) {
            return this;
        }
        this.state = IdeActivityState.STARTED;
        FeatureUsageData data = this.createDataWithActivityId();
        consumer.accept(data);
        this.startedTimestamp = System.nanoTime();
        FUCounterUsageLogger.getInstance().logEvent(this.projectOrNullForApplication, this.group, this.appendActivityName(STARTED_EVENT_ID), data);
        return this;
    }

    @NotNull
    public final IdeActivity startedWithDataAsync(@NotNull Function1<? super FeatureUsageData, ? extends Promise<FeatureUsageData>> dataSupplier) {
        Intrinsics.checkNotNullParameter(dataSupplier, (String)"dataSupplier");
        if (!IdeActivityKt.access$getLOG$p().assertTrue(this.state == IdeActivityState.NOT_STARTED, (Object)this.state.name())) {
            return this;
        }
        this.state = IdeActivityState.STARTED;
        this.startedTimestamp = System.nanoTime();
        ((Promise)dataSupplier.invoke((Object)this.createDataWithActivityId())).then(new Function(this){
            final /* synthetic */ IdeActivity this$0;

            public final void fun(FeatureUsageData data) {
                FUCounterUsageLogger.getInstance().logEvent(IdeActivity.access$getProjectOrNullForApplication$p(this.this$0), IdeActivity.access$getGroup$p(this.this$0), IdeActivity.access$appendActivityName(this.this$0, "started"), data);
            }
            {
                this.this$0 = ideActivity;
            }
        });
        return this;
    }

    @NotNull
    public final IdeActivity stageStarted(@NotNull String stageName) {
        Intrinsics.checkNotNullParameter((Object)stageName, (String)"stageName");
        if (!IdeActivityKt.access$getLOG$p().assertTrue(this.state == IdeActivityState.STARTED, (Object)this.state.name())) {
            return this;
        }
        FUCounterUsageLogger.getInstance().logEvent(this.projectOrNullForApplication, this.group, this.appendActivityName(stageName), this.createDataWithActivityId());
        return this;
    }

    @NotNull
    public final IdeActivity stageStarted(@NotNull Class<?> stageClass) {
        Intrinsics.checkNotNullParameter(stageClass, (String)"stageClass");
        if (!IdeActivityKt.access$getLOG$p().assertTrue(this.state == IdeActivityState.STARTED, (Object)this.state.name())) {
            return this;
        }
        FeatureUsageData featureUsageData = this.createDataWithActivityId();
        String string = stageClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stageClass.name");
        FeatureUsageData data = featureUsageData.addData("stage_class", string);
        FUCounterUsageLogger.getInstance().logEvent(this.projectOrNullForApplication, this.group, this.appendActivityName("stage"), data);
        return this;
    }

    @NotNull
    public final IdeActivity finished() {
        return this.finished(null);
    }

    @NotNull
    public final IdeActivity finished(@Nullable Consumer<FeatureUsageData> consumer) {
        if (!IdeActivityKt.access$getLOG$p().assertTrue(this.state == IdeActivityState.STARTED, (Object)this.state.name())) {
            return this;
        }
        this.state = IdeActivityState.FINISHED;
        FeatureUsageData data = this.createDataWithActivityId();
        Consumer<FeatureUsageData> consumer2 = consumer;
        if (consumer2 != null) {
            consumer2.accept(data);
        }
        long duration = TimeoutUtil.getDurationMillis((long)this.startedTimestamp);
        FUCounterUsageLogger.getInstance().logEvent(this.projectOrNullForApplication, this.group, this.appendActivityName("finished"), data.addData("duration_ms", duration));
        return this;
    }

    private final String appendActivityName(String state) {
        if (this.activityName == null) {
            return state;
        }
        return this.activityName + '.' + state;
    }

    @JvmOverloads
    public IdeActivity(@Nullable Project projectOrNullForApplication, @NotNull String group, @Nullable String activityName) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.projectOrNullForApplication = projectOrNullForApplication;
        this.group = group;
        this.activityName = activityName;
        this.id = counter.incrementAndGet();
        this.state = IdeActivityState.NOT_STARTED;
    }

    public /* synthetic */ IdeActivity(Project project, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(project, string, string2);
    }

    @JvmOverloads
    public IdeActivity(@Nullable Project projectOrNullForApplication, @NotNull String group) {
        this(projectOrNullForApplication, group, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        counter = new AtomicInteger(0);
    }

    public static final /* synthetic */ Project access$getProjectOrNullForApplication$p(IdeActivity $this) {
        return $this.projectOrNullForApplication;
    }

    public static final /* synthetic */ String access$getGroup$p(IdeActivity $this) {
        return $this.group;
    }

    public static final /* synthetic */ String access$appendActivityName(IdeActivity $this, String state) {
        return $this.appendActivityName(state);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IdeActivity started(@Nullable Project projectOrNullForApplication, @NotNull String group, @Nullable String activityName) {
        return Companion.started(projectOrNullForApplication, group, activityName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IdeActivity started(@Nullable Project projectOrNullForApplication, @NotNull String group) {
        return com.intellij.internal.statistic.IdeActivity$Companion.started$default(Companion, projectOrNullForApplication, group, null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000b\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\f2\u000f\b\u0002\u0010\r\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/IdeActivity$Companion;", "", "()V", "STARTED_EVENT_ID", "", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "started", "Lcom/intellij/internal/statistic/IdeActivity;", "projectOrNullForApplication", "Lcom/intellij/openapi/project/Project;", "group", "Lorg/jetbrains/annotations/NonNls;", "activityName", "intellij.platform.statistics"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IdeActivity started(@Nullable Project projectOrNullForApplication, @NotNull String group, @Nullable String activityName) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            return new IdeActivity(projectOrNullForApplication, group, activityName).started();
        }

        public static /* synthetic */ IdeActivity started$default(Companion companion, Project project, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.started(project, string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IdeActivity started(@Nullable Project projectOrNullForApplication, @NotNull String group) {
            return com.intellij.internal.statistic.IdeActivity$Companion.started$default(this, projectOrNullForApplication, group, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

