/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.remote;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebugger;

public class RemoteDebuggerClient
implements Debugger {
    private final RemoteDebugger myRemote;
    private final String myAccessToken;
    private final BreakpointManager myBreakpointManager;
    private final OutputEventQueue myEventQueue;

    public RemoteDebuggerClient(int port, String accessToken) throws IOException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(port);
        this.myRemote = (RemoteDebugger)registry.lookup("XsltDebugger");
        this.myAccessToken = accessToken;
        RemoteBreakpointManager manager = this.myRemote.getBreakpointManager();
        this.myBreakpointManager = new MyBreakpointManager(manager);
        RemoteDebugger.EventQueue eventQueue = this.myRemote.getEventQueue();
        this.myEventQueue = new MyOutputEventQueue(eventQueue);
    }

    @Override
    public boolean ping() {
        try {
            return this.myRemote.ping();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public Debugger.State getState() {
        try {
            return this.myRemote.getState();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public void stop(boolean force) {
        try {
            this.myRemote.stop(force);
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    static RuntimeException handleRemoteException(RemoteException e) {
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof SocketException) && !(t instanceof EOFException)) continue;
            throw new DebuggerStoppedException();
        }
        return e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e);
    }

    @Override
    public Debugger.State waitForStateChange(Debugger.State state) {
        try {
            return this.myRemote.waitForStateChange(state);
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public boolean waitForDebuggee() {
        try {
            return this.myRemote.waitForDebuggee();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public boolean start() {
        try {
            return this.myRemote.start();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public void step() {
        try {
            this.myRemote.step();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public void stepInto() {
        try {
            this.myRemote.stepInto();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public void resume() {
        try {
            this.myRemote.resume();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public void pause() {
        try {
            this.myRemote.pause();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public boolean isStopped() {
        try {
            return this.myRemote.isStopped();
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public Debugger.StyleFrame getCurrentFrame() {
        try {
            return new MyFrame(this.myRemote.getCurrentFrame());
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public Debugger.SourceFrame getSourceFrame() {
        try {
            return new MySourceFrame(this.myRemote.getSourceFrame());
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public Value eval(String expr) throws Debugger.EvaluationException {
        try {
            return this.myRemote.eval(expr, this.myAccessToken);
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public List<Debugger.Variable> getGlobalVariables() {
        try {
            return MyVariable.convert(this.myRemote.getGlobalVariables());
        }
        catch (RemoteException e) {
            throw RemoteDebuggerClient.handleRemoteException(e);
        }
    }

    @Override
    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    @Override
    public OutputEventQueue getEventQueue() {
        return this.myEventQueue;
    }

    private static class MyOutputEventQueue
    implements OutputEventQueue {
        private final RemoteDebugger.EventQueue myEventQueue;

        MyOutputEventQueue(RemoteDebugger.EventQueue eventQueue) {
            this.myEventQueue = eventQueue;
        }

        @Override
        public void setEnabled(boolean b) {
            try {
                this.myEventQueue.setEnabled(b);
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public List<OutputEventQueue.NodeEvent> getEvents() {
            try {
                return this.myEventQueue.getEvents();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }
    }

    private static class MyVariable
    implements Debugger.Variable {
        private final RemoteDebugger.Variable myVariable;

        MyVariable(RemoteDebugger.Variable variable) {
            this.myVariable = variable;
        }

        @Override
        public String getURI() {
            try {
                return this.myVariable.getURI();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public int getLineNumber() {
            try {
                return this.myVariable.getLineNumber();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public boolean isGlobal() {
            try {
                return this.myVariable.isGlobal();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public Debugger.Variable.Kind getKind() {
            try {
                return this.myVariable.getKind();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public String getName() {
            try {
                return this.myVariable.getName();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public Value getValue() {
            try {
                return this.myVariable.getValue();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        static List<Debugger.Variable> convert(List<? extends RemoteDebugger.Variable> list) {
            ArrayList<Debugger.Variable> variables = new ArrayList<Debugger.Variable>(list.size());
            for (RemoteDebugger.Variable variable : list) {
                variables.add(new MyVariable(variable));
            }
            return variables;
        }
    }

    private class MySourceFrame
    extends MyAbstractFrame<Debugger.SourceFrame>
    implements Debugger.SourceFrame {
        protected MySourceFrame(RemoteDebugger.Frame frame) {
            super(frame);
        }

        @Override
        public Debugger.SourceFrame createImpl(RemoteDebugger.Frame frame) {
            return this.create(frame);
        }

        public Debugger.SourceFrame create(RemoteDebugger.Frame currentFrame) {
            return currentFrame != null ? new MySourceFrame(currentFrame) : null;
        }
    }

    private class MyFrame
    extends MyAbstractFrame<Debugger.StyleFrame>
    implements Debugger.StyleFrame {
        protected MyFrame(RemoteDebugger.Frame frame) {
            super(frame);
        }

        @Override
        public String getInstruction() {
            try {
                return this.myFrame.getInstruction();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        protected Debugger.StyleFrame createImpl(RemoteDebugger.Frame frame) {
            return this.create(frame);
        }

        public Debugger.StyleFrame create(RemoteDebugger.Frame currentFrame) {
            return currentFrame != null ? new MyFrame(currentFrame) : null;
        }
    }

    private abstract class MyAbstractFrame<F extends Debugger.Frame<?>>
    implements Debugger.Frame<F> {
        protected final RemoteDebugger.Frame myFrame;

        protected MyAbstractFrame(RemoteDebugger.Frame frame) {
            this.myFrame = frame;
        }

        @Override
        public int getLineNumber() {
            try {
                return this.myFrame.getLineNumber();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public String getURI() {
            try {
                return this.myFrame.getURI();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public F getNext() {
            try {
                return this.createImpl(this.myFrame.getNext());
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public F getPrevious() {
            try {
                return this.createImpl(this.myFrame.getPrevious());
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        protected abstract F createImpl(RemoteDebugger.Frame var1);

        public String getXPath() {
            try {
                return this.myFrame.getXPath();
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        public Value eval(String expr) throws Debugger.EvaluationException {
            try {
                return this.myFrame.eval(expr, RemoteDebuggerClient.this.myAccessToken);
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        public List<Debugger.Variable> getVariables() {
            try {
                return MyVariable.convert(this.myFrame.getVariables());
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }
    }

    private static class MyBreakpointManager
    implements BreakpointManager {
        private final RemoteBreakpointManager myManager;

        MyBreakpointManager(RemoteBreakpointManager manager) {
            this.myManager = manager;
        }

        @Override
        public Breakpoint setBreakpoint(File file, int line) {
            try {
                return new MyBreakpoint(this.myManager.setBreakpoint(file, line));
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public Breakpoint setBreakpoint(String uri, int line) {
            try {
                return new MyBreakpoint(this.myManager.setBreakpoint(uri, line));
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public void removeBreakpoint(Breakpoint bp) {
            try {
                this.myManager.removeBreakpoint(bp.getUri(), bp.getLine());
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public void removeBreakpoint(String uri, int line) {
            try {
                this.myManager.removeBreakpoint(uri, line);
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public List<Breakpoint> getBreakpoints() {
            try {
                List<RemoteBreakpoint> list = this.myManager.getBreakpoints();
                ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(list.size());
                for (RemoteBreakpoint breakpoint : list) {
                    breakpoints.add(new MyBreakpoint(breakpoint));
                }
                return breakpoints;
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        @Override
        public Breakpoint getBreakpoint(String uri, int lineNumber) {
            try {
                RemoteBreakpoint breakpoint = this.myManager.getBreakpoint(uri, lineNumber);
                return breakpoint != null ? new MyBreakpoint(breakpoint) : null;
            }
            catch (RemoteException e) {
                throw RemoteDebuggerClient.handleRemoteException(e);
            }
        }

        private static class MyBreakpoint
        implements Breakpoint {
            private final RemoteBreakpoint myBreakpoint;

            MyBreakpoint(RemoteBreakpoint breakpoint) {
                this.myBreakpoint = breakpoint;
            }

            @Override
            public String getUri() {
                try {
                    return this.myBreakpoint.getUri();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public int getLine() {
                try {
                    return this.myBreakpoint.getLine();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public boolean isEnabled() {
                try {
                    return this.myBreakpoint.isEnabled();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public String getCondition() {
                try {
                    return this.myBreakpoint.getCondition();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public String getLogMessage() {
                try {
                    return this.myBreakpoint.getLogMessage();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public void setCondition(String expr) {
                try {
                    this.myBreakpoint.setCondition(expr);
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                try {
                    this.myBreakpoint.setEnabled(enabled);
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public void setLogMessage(String expr) {
                try {
                    this.myBreakpoint.setLogMessage(expr);
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public String getTraceMessage() {
                try {
                    return this.myBreakpoint.getTraceMessage();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public void setTraceMessage(String expr) {
                try {
                    this.myBreakpoint.setTraceMessage(expr);
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public boolean isSuspend() {
                try {
                    return this.myBreakpoint.isSuspend();
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }

            @Override
            public void setSuspend(boolean suspend) {
                try {
                    this.myBreakpoint.setSuspend(suspend);
                }
                catch (RemoteException e) {
                    throw RemoteDebuggerClient.handleRemoteException(e);
                }
            }
        }
    }
}

