/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.DownloadArtifactEvent;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemotePullUtil;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;

public class MavenServerDownloadListenerWrapper
extends MavenRemoteObject
implements MavenServerDownloadListener,
MavenPullDownloadListener {
    private final ConcurrentLinkedQueue<DownloadArtifactEvent> myPullingQueue = new ConcurrentLinkedQueue();

    public void artifactDownloaded(File file, String relativePath) throws RemoteException {
        this.myPullingQueue.add(new DownloadArtifactEvent(file.getAbsolutePath(), relativePath));
    }

    @Nullable
    public List<DownloadArtifactEvent> pull() {
        return MavenRemotePullUtil.pull(this.myPullingQueue);
    }
}

