/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays;

import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"VIEWPORT_INLAY_RANGE", "", "calculateInlayExpansionRange", "Lkotlin/ranges/IntRange;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "viewportRange", "calculateViewportRange", "intellij.notebooks.visualization"})
public final class InlayEditorManagerKt {
    public static final int VIEWPORT_INLAY_RANGE = 20;

    @NotNull
    public static final IntRange calculateViewportRange(@NotNull EditorImpl editor) {
        JViewport viewport;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        JViewport jViewport = viewport = jScrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
        int yMin = jViewport.getViewPosition().y;
        int yMax = yMin + viewport.getHeight();
        return RangesKt.until((int)yMin, (int)yMax);
    }

    @NotNull
    public static final IntRange calculateInlayExpansionRange(@NotNull EditorImpl editor, @NotNull IntRange viewportRange) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)viewportRange, (String)"viewportRange");
        int startLine = editor.xyToLogicalPosition((Point)new Point((int)0, (int)viewportRange.getFirst())).line;
        int endLine = editor.xyToLogicalPosition((Point)new Point((int)0, (int)(viewportRange.getLast() + 1))).line;
        int n = startLine - 20;
        int n2 = 0;
        int n3 = 0;
        int startOffset = editor.getDocument().getLineStartOffset(Math.max(n, n2));
        DocumentEx documentEx = editor.getDocument();
        n2 = endLine + 20;
        DocumentEx documentEx2 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"editor.document");
        n3 = documentEx2.getLineCount() - 1;
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        bl = false;
        int endOffset = documentEx.getLineStartOffset(Math.max(n2, n3));
        n2 = startOffset;
        return new IntRange(n2, endOffset);
    }
}

