/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.TextTransferable;
import icons.VisualisationIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.datavis.r.VisualizationBundle;
import org.intellij.datavis.r.inlays.ClipboardUtils;
import org.intellij.datavis.r.inlays.components.ToolBarProvider;
import org.intellij.datavis.r.inlays.dataframe.DataFrame;
import org.intellij.datavis.r.inlays.dataframe.columns.Column;
import org.intellij.datavis.r.inlays.dataframe.columns.DoubleType;
import org.intellij.datavis.r.inlays.dataframe.columns.IntType;
import org.intellij.datavis.r.inlays.table.DataFrameColumnModel;
import org.intellij.datavis.r.inlays.table.DataFrameTableModel;
import org.intellij.datavis.r.inlays.table.DoubleTableCellRenderer;
import org.intellij.datavis.r.inlays.table.IntegerTableCellRenderer;
import org.intellij.datavis.r.inlays.table.StringTableCellRenderer;
import org.intellij.datavis.r.inlays.table.filters.gui.TableFilterHeader;
import org.intellij.datavis.r.inlays.table.paging.TablePaginator;
import org.intellij.datavis.r.ui.MaterialTable;
import org.intellij.datavis.r.ui.MaterialTableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020$H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/datavis/r/inlays/components/InlayTablePage;", "Ljavax/swing/JPanel;", "Lorg/intellij/datavis/r/inlays/components/ToolBarProvider;", "()V", "filterHeader", "Lorg/intellij/datavis/r/inlays/table/filters/gui/TableFilterHeader;", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "paginator", "Lorg/intellij/datavis/r/inlays/table/paging/TablePaginator;", "preferredHeight", "", "getPreferredHeight", "()I", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "table", "Lorg/intellij/datavis/r/ui/MaterialTable;", "addTableFilterHeader", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "saveAsCsv", "project", "Lcom/intellij/openapi/project/Project;", "setDataFrame", "dataFrame", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "setupSelectAllAction", "Ljavax/swing/JTable;", "setupTablePopupMenu", "NumberComparator", "TableCopyProvider", "intellij.notebooks.visualization"})
public final class InlayTablePage
extends JPanel
implements ToolBarProvider {
    @Nullable
    private Function0<Unit> onChange;
    private final MaterialTable table = new MaterialTable();
    @NotNull
    private final JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.table));
    private TableFilterHeader filterHeader;
    private TablePaginator paginator;

    @Nullable
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function0<Unit> function0) {
        this.onChange = function0;
    }

    @NotNull
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final int getPreferredHeight() {
        return this.table.getPreferredSize().height;
    }

    private final void setupTablePopupMenu(JTable table) {
        JMenuItem copyAll = new JMenuItem(VisualizationBundle.INSTANCE.message("inlay.table.copy.all", new Object[0]));
        copyAll.addActionListener(new ActionListener(table){
            final /* synthetic */ JTable $table;

            public final void actionPerformed(ActionEvent it) {
                ClipboardUtils.copyAllToClipboard$default(ClipboardUtils.INSTANCE, this.$table, null, 0, 6, null);
            }
            {
                this.$table = jTable;
            }
        });
        JMenuItem copySelected = new JMenuItem(VisualizationBundle.INSTANCE.message("inlay.table.copy.selected", new Object[0]));
        copySelected.addActionListener(new ActionListener(table){
            final /* synthetic */ JTable $table;

            public final void actionPerformed(ActionEvent it) {
                ClipboardUtils.copySelectedToClipboard$default(ClipboardUtils.INSTANCE, this.$table, null, 2, null);
            }
            {
                this.$table = jTable;
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(copyAll);
        popupMenu.add(copySelected);
        table.setComponentPopupMenu(popupMenu);
    }

    private final void setupSelectAllAction(JTable table) {
        String actionName = VisualizationBundle.INSTANCE.message("action.name.table.select.all", new Object[0]);
        AbstractAction action2 = new AbstractAction(table, actionName, actionName){
            final /* synthetic */ JTable $table;
            final /* synthetic */ String $actionName;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$table.setRowSelectionInterval(0, this.$table.getRowCount() - 1);
                this.$table.setColumnSelectionInterval(0, this.$table.getColumnCount() - 1);
            }
            {
                this.$table = $captured_local_variable$0;
                this.$actionName = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        table.getActionMap().put(actionName, action2);
        table.getInputMap(0).put(KeyStroke.getKeyStroke(65, 2), actionName);
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.table.setColumnModel(new DataFrameColumnModel(dataFrame));
        this.table.setModel(new DataFrameTableModel(dataFrame));
        int n = 0;
        int n2 = ((Collection)dataFrame.getColumns()).size();
        while (n < n2) {
            void i;
            TableColumn tableColumn = this.table.getColumnModel().getColumn((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table.columnModel.getColumn(i)");
            tableColumn.setCellRenderer(Intrinsics.areEqual(dataFrame.get((int)i).getType(), (Object)IntType.INSTANCE) ? (TableCellRenderer)new IntegerTableCellRenderer() : (Intrinsics.areEqual(dataFrame.get((int)i).getType(), (Object)DoubleType.INSTANCE) ? (TableCellRenderer)new DoubleTableCellRenderer() : (TableCellRenderer)new StringTableCellRenderer()));
            ++i;
        }
        MaterialTableUtils.fitColumnsWidth$default(MaterialTableUtils.INSTANCE, (JTable)((Object)this.table), 0, null, 6, null);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.table.getModel());
        tableRowSorter.setSortsOnUpdates(true);
        n2 = 0;
        for (Column column : (Iterable)dataFrame.getColumns()) {
            void i;
            if (column.getType() instanceof IntType) {
                tableRowSorter.setComparator((int)i, new NumberComparator());
            } else if (column.getType() instanceof DoubleType) {
                tableRowSorter.setComparator((int)i, new NumberComparator());
            }
            ++i;
        }
        this.table.setRowSorter(tableRowSorter);
    }

    private final void addTableFilterHeader() {
        TableFilterHeader tableFilterHeader = this.filterHeader = new TableFilterHeader();
        Intrinsics.checkNotNull((Object)tableFilterHeader);
        tableFilterHeader.setTable((JTable)((Object)this.table));
    }

    @Override
    @NotNull
    public List<AnAction> createActions() {
        DumbAwareAction actionSaveAsCsv2 = new DumbAwareAction(this, VisualizationBundle.INSTANCE.message("inlay.table.export.as.text", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.table.export.as.description", new Object[0]), AllIcons.ToolbarDecorator.Export){
            final /* synthetic */ InlayTablePage this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
                InlayTablePage.access$saveAsCsv(this.this$0, project);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        DumbAwareToggleAction filterTable2 = new DumbAwareToggleAction(this, VisualizationBundle.INSTANCE.message("inlay.table.filter.text", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.table.filter.description", new Object[0]), AllIcons.Actions.Find){
            final /* synthetic */ InlayTablePage this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return InlayTablePage.access$getFilterHeader$p(this.this$0) != null;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (state) {
                    InlayTablePage.access$addTableFilterHeader(this.this$0);
                } else {
                    TableFilterHeader tableFilterHeader = InlayTablePage.access$getFilterHeader$p(this.this$0);
                    if (tableFilterHeader != null) {
                        tableFilterHeader.setTable(null);
                    }
                    InlayTablePage.access$setFilterHeader$p(this.this$0, null);
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        DumbAwareToggleAction paginateTable2 = new DumbAwareToggleAction(this, VisualizationBundle.INSTANCE.message("inlay.table.pagination.text", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.table.pagination.description", new Object[0]), VisualisationIcons.Table.Pagination){
            final /* synthetic */ InlayTablePage this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return InlayTablePage.access$getPaginator$p(this.this$0) != null;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (state) {
                    InlayTablePage.access$setPaginator$p(this.this$0, new TablePaginator());
                    TablePaginator tablePaginator = InlayTablePage.access$getPaginator$p(this.this$0);
                    Intrinsics.checkNotNull((Object)tablePaginator);
                    tablePaginator.setTable((JTable)((Object)InlayTablePage.access$getTable$p(this.this$0)));
                } else {
                    TablePaginator tablePaginator = InlayTablePage.access$getPaginator$p(this.this$0);
                    if (tablePaginator != null) {
                        tablePaginator.setTable(null);
                    }
                    InlayTablePage.access$setPaginator$p(this.this$0, null);
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        List<AnAction> list = Arrays.asList((AnAction)actionSaveAsCsv2, (AnAction)filterTable2, (AnAction)paginateTable2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(actionSaveAsCsv, \u2026lterTable, paginateTable)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveAsCsv(Project project) {
        FileSaverDescriptor descriptor = new FileSaverDescriptor(VisualizationBundle.INSTANCE.message("inlay.table.export.as.csv.text", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.table.export.as.csv.description", new Object[0]), new String[]{"csv", "tsv"});
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026eDialog(descriptor, this)");
        FileSaverDialog chooser = fileSaverDialog;
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return");
        String basePath = string;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(basePath));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "table.csv");
        if (virtualFileWrapper == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileWrapper, (String)"chooser.save(virtualBase\u2026r, \"table.csv\") ?: return");
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        Function2<BufferedWriter, String, Unit> $fun$saveSelection$1 = new Function2<BufferedWriter, String, Unit>(this){
            final /* synthetic */ InlayTablePage this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferedWriter out, @NotNull String cellBreak) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
                int selectedColumnCount = InlayTablePage.access$getTable$p(this.this$0).getSelectedColumnCount();
                int selectedRowCount = InlayTablePage.access$getTable$p(this.this$0).getSelectedRowCount();
                int[] selectedRows = InlayTablePage.access$getTable$p(this.this$0).getSelectedRows();
                int[] selectedColumns = InlayTablePage.access$getTable$p(this.this$0).getSelectedColumns();
                int n = 0;
                int n2 = selectedRowCount;
                while (n < n2) {
                    void i;
                    int n3 = 0;
                    int n4 = selectedColumnCount;
                    while (n3 < n4) {
                        void j;
                        Object object = InlayTablePage.access$getTable$p(this.this$0).getValueAt(selectedRows[i], selectedColumns[j]);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"table.getValueAt(selecte\u2026s[i], selectedColumns[j])");
                        out.write(ClipboardUtils.escape$default(ClipboardUtils.INSTANCE, object, null, 2, null));
                        if (j < selectedColumnCount - 1) {
                            out.write(cellBreak);
                        }
                        ++j;
                    }
                    if (i < InlayTablePage.access$getTable$p(this.this$0).getRowCount() - 1) {
                        out.append("\r");
                    }
                    ++i;
                }
            }
            {
                this.this$0 = inlayTablePage;
                super(2);
            }
        };
        Function2<BufferedWriter, String, Unit> $fun$saveAll$2 = new Function2<BufferedWriter, String, Unit>(this){
            final /* synthetic */ InlayTablePage this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferedWriter out, @NotNull String cellBreak) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
                int n = 0;
                int n2 = InlayTablePage.access$getTable$p(this.this$0).getRowCount();
                while (n < n2) {
                    void i;
                    int n3 = 0;
                    int n4 = InlayTablePage.access$getTable$p(this.this$0).getColumnCount();
                    while (n3 < n4) {
                        void j;
                        Object object = InlayTablePage.access$getTable$p(this.this$0).getValueAt((int)i, (int)j);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"table.getValueAt(i, j)");
                        out.write(ClipboardUtils.escape$default(ClipboardUtils.INSTANCE, object, null, 2, null));
                        if (j < InlayTablePage.access$getTable$p(this.this$0).getColumnCount() - 1) {
                            out.write(cellBreak);
                        }
                        ++j;
                    }
                    if (i < InlayTablePage.access$getTable$p(this.this$0).getRowCount() - 1) {
                        out.append("\r");
                    }
                    ++i;
                }
            }
            {
                this.this$0 = inlayTablePage;
                super(2);
            }
        };
        File file = fileWrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileWrapper.file");
        Object object = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            String cellBreak;
            BufferedWriter out = (BufferedWriter)object;
            boolean bl5 = false;
            File file2 = fileWrapper.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"fileWrapper.file");
            String string2 = cellBreak = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"csv") ? ";" : "\t";
            if (this.table.getSelectedColumnCount() == 0 || this.table.getSelectedRowCount() == 0) {
                $fun$saveAll$2.invoke(out, cellBreak);
            } else {
                $fun$saveSelection$1.invoke(out, cellBreak);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public InlayTablePage() {
        super(new BorderLayout());
        this.table.putClientProperty("AuxEditorComponent", true);
        this.scrollPane.setBorder(IdeBorderFactory.createBorder((int)4));
        this.scrollPane.setViewportBorder(IdeBorderFactory.createBorder((int)13));
        this.setupTablePopupMenu((JTable)((Object)this.table));
        this.setupSelectAllAction((JTable)((Object)this.table));
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (filterHeader == null) {
                    char c = e.getKeyChar();
                    boolean bl = false;
                    if (Character.isLetterOrDigit(c)) {
                        this.addTableFilterHeader();
                    }
                }
            }
        });
        DataManager.registerDataProvider((JComponent)((JComponent)((Object)this.table)), (DataProvider)new DataProvider(){

            @Nullable
            public final Object getData(@NotNull String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? new TableCopyProvider(table) : null;
            }
        });
        this.add((Component)this.scrollPane, "Center");
    }

    public static final /* synthetic */ void access$saveAsCsv(InlayTablePage $this, Project project) {
        $this.saveAsCsv(project);
    }

    public static final /* synthetic */ void access$setFilterHeader$p(InlayTablePage $this, TableFilterHeader tableFilterHeader) {
        $this.filterHeader = tableFilterHeader;
    }

    public static final /* synthetic */ TablePaginator access$getPaginator$p(InlayTablePage $this) {
        return $this.paginator;
    }

    public static final /* synthetic */ void access$setPaginator$p(InlayTablePage $this, TablePaginator tablePaginator) {
        $this.paginator = tablePaginator;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/datavis/r/inlays/components/InlayTablePage$TableCopyProvider;", "Lcom/intellij/ide/CopyProvider;", "table", "Lcom/intellij/ui/table/JBTable;", "(Lcom/intellij/ui/table/JBTable;)V", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "", "intellij.notebooks.visualization"})
    public static final class TableCopyProvider
    implements CopyProvider {
        private final JBTable table;

        public void performCopy(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            String copySelectedToString = ClipboardUtils.copySelectedToString$default(ClipboardUtils.INSTANCE, (JTable)this.table, null, 2, null);
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(copySelectedToString));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return this.table.getSelectedRowCount() > 0;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return true;
        }

        public TableCopyProvider(@NotNull JBTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            this.table = table;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/intellij/datavis/r/inlays/components/InlayTablePage$NumberComparator;", "T", "", "Ljava/util/Comparator;", "(Lorg/intellij/datavis/r/inlays/components/InlayTablePage;)V", "compare", "", "o1", "o2", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)I", "intellij.notebooks.visualization"})
    private final class NumberComparator<T extends Comparable<?>>
    implements Comparator<T> {
        @Override
        public int compare(@NotNull T o1, @NotNull T o2) {
            Intrinsics.checkNotNullParameter(o1, (String)"o1");
            Intrinsics.checkNotNullParameter(o2, (String)"o2");
            return ComparisonsKt.compareValues(o1, o2);
        }
    }
}

