/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.dataframe;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.inlays.dataframe.DataFrame;
import org.intellij.datavis.r.inlays.dataframe.DataFrameImpl;
import org.intellij.datavis.r.inlays.dataframe.columns.Column;
import org.intellij.datavis.r.inlays.dataframe.columns.DoubleType;
import org.intellij.datavis.r.inlays.dataframe.columns.IntType;
import org.intellij.datavis.r.inlays.dataframe.columns.StringType;
import org.intellij.datavis.r.inlays.dataframe.columns.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/intellij/datavis/r/inlays/dataframe/DataFrameCSVAdapter;", "", "()V", "ColumnInfo", "Companion", "intellij.notebooks.visualization"})
public final class DataFrameCSVAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/intellij/datavis/r/inlays/dataframe/DataFrameCSVAdapter$ColumnInfo;", "", "name", "", "type", "Lorg/intellij/datavis/r/inlays/dataframe/columns/Type;", "(Ljava/lang/String;Lorg/intellij/datavis/r/inlays/dataframe/columns/Type;)V", "getName", "()Ljava/lang/String;", "getType", "()Lorg/intellij/datavis/r/inlays/dataframe/columns/Type;", "setType", "(Lorg/intellij/datavis/r/inlays/dataframe/columns/Type;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.notebooks.visualization"})
    public static final class ColumnInfo {
        @NotNull
        private final String name;
        @Nullable
        private Type<?> type;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Type<?> getType() {
            return this.type;
        }

        public final void setType(@Nullable Type<?> type) {
            this.type = type;
        }

        public ColumnInfo(@NotNull String name, @Nullable Type<?> type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.type = type;
        }

        public /* synthetic */ ColumnInfo(String string, Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                type = null;
            }
            this(string, type);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Type<?> component2() {
            return this.type;
        }

        @NotNull
        public final ColumnInfo copy(@NotNull String name, @Nullable Type<?> type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ColumnInfo(name, type);
        }

        public static /* synthetic */ ColumnInfo copy$default(ColumnInfo columnInfo, String string, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                string = columnInfo.name;
            }
            if ((n & 2) != 0) {
                type = columnInfo.type;
            }
            return columnInfo.copy(string, type);
        }

        @NotNull
        public String toString() {
            return "ColumnInfo(name=" + this.name + ", type=" + this.type + ")";
        }

        public int hashCode() {
            String string = this.name;
            Type<?> type = this.type;
            return (string != null ? string.hashCode() : 0) * 31 + (type != null ? type.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ColumnInfo)) break block3;
                    ColumnInfo columnInfo = (ColumnInfo)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)columnInfo.name) || !Intrinsics.areEqual(this.type, columnInfo.type)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/intellij/datavis/r/inlays/dataframe/DataFrameCSVAdapter$Companion;", "", "()V", "fromCsvString", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "data", "", "getCellType", "Lorg/intellij/datavis/r/inlays/dataframe/columns/Type;", "getColumnType", "columnType", "cellType", "getColumnsInfo", "", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrameCSVAdapter$ColumnInfo;", "readData", "Ljava/util/ArrayList;", "Lorg/intellij/datavis/r/inlays/dataframe/columns/Column;", "columnsInfo", "intellij.notebooks.visualization"})
    public static final class Companion {
        private final Type<?> getCellType(String data) {
            return Intrinsics.areEqual((Object)data, (Object)"null") ? null : (StringsKt.toIntOrNull((String)data) != null ? (Type)IntType.INSTANCE : (StringsKt.toDoubleOrNull((String)data) != null ? (Type)DoubleType.INSTANCE : (Type)StringType.INSTANCE));
        }

        private final Type<?> getColumnType(Type<?> columnType, Type<?> cellType) {
            if (columnType == null) {
                return cellType;
            }
            return columnType.upgrade(cellType);
        }

        /*
         * WARNING - void declaration
         */
        private final List<ColumnInfo> getColumnsInfo(String data) {
            int n;
            ArrayList<ColumnInfo> columnsInfo = new ArrayList<ColumnInfo>();
            int previous = 0;
            int n2 = 0;
            int n3 = data.length();
            while (n2 < n3) {
                void i;
                if (data.charAt((int)i) == '\n' || data.charAt((int)i) == '\t') {
                    String string = data;
                    n = 0;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(previous, (int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    columnsInfo.add(new ColumnInfo(string3, null, 2, null));
                    previous = i + true;
                    if (data.charAt((int)i) == '\n') break;
                }
                ++i;
            }
            int column = 0;
            int linesCount = 0;
            int n4 = previous;
            n = data.length();
            while (n4 < n) {
                void i;
                if (data.charAt((int)i) == '\n' || data.charAt((int)i) == '\t') {
                    Type<?> cellType = null;
                    if (previous == i) {
                        cellType = null;
                    } else {
                        String string = data;
                        boolean bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(previous, (int)i);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        cellType = this.getCellType(string5);
                    }
                    Type<?> columnType = ((ColumnInfo)columnsInfo.get(column)).getType();
                    if (Intrinsics.areEqual(columnType, (Object)cellType) ^ true) {
                        ((ColumnInfo)columnsInfo.get(column)).setType(this.getColumnType(columnType, cellType));
                    }
                    previous = i + true;
                    if (data.charAt((int)i) == '\n') {
                        column = 0;
                        ++linesCount;
                    } else {
                        ++column;
                    }
                }
                ++i;
            }
            for (ColumnInfo columnInfo : columnsInfo) {
                if (columnInfo.getType() != null) continue;
                columnInfo.setType(StringType.INSTANCE);
            }
            return columnsInfo;
        }

        /*
         * WARNING - void declaration
         */
        private final ArrayList<Column<?>> readData(String data, List<ColumnInfo> columnsInfo) {
            ArrayList columns = new ArrayList(columnsInfo.size());
            int n = 0;
            int n2 = columnsInfo.size();
            while (n < n2) {
                void i;
                Type<?> type = columnsInfo.get((int)i).getType();
                Intrinsics.checkNotNull(type);
                columns.add(type.createDataArray());
                ++i;
            }
            int previous = StringsKt.indexOf$default((CharSequence)data, (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
            int column = 0;
            int n3 = previous;
            int n4 = data.length();
            while (n3 < n4) {
                void i;
                if (data.charAt((int)i) == '\n' || data.charAt((int)i) == '\t') {
                    Type<?> type = columnsInfo.get(column).getType();
                    Intrinsics.checkNotNull(type);
                    Object e = columns.get(column);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"columns[column]");
                    ArrayList arrayList = (ArrayList)e;
                    String string = data;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(previous, (int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    type.appendToDataArray(arrayList, string3);
                    previous = i + true;
                    if (data.charAt((int)i) == '\n') {
                        while (column + 1 < columnsInfo.size()) {
                            Type<?> type2 = columnsInfo.get(++column).getType();
                            Intrinsics.checkNotNull(type2);
                            Object e2 = columns.get(column);
                            Intrinsics.checkNotNullExpressionValue(e2, (String)"columns[column]");
                            type2.appendToDataArray((ArrayList)e2, "");
                        }
                        column = 0;
                    } else {
                        ++column;
                    }
                }
                ++i;
            }
            ArrayList realColumns = new ArrayList(columnsInfo.size());
            n4 = 0;
            int n5 = columnsInfo.size();
            while (n4 < n5) {
                void i;
                Type<?> type = columnsInfo.get((int)i).getType();
                Intrinsics.checkNotNull(type);
                String string = columnsInfo.get((int)i).getName();
                Object e = columns.get((int)i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"columns[i]");
                realColumns.add(type.createDataColumn(string, (ArrayList)e));
                ++i;
            }
            return realColumns;
        }

        @NotNull
        public final DataFrame fromCsvString(@NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String innerData = data;
            CharSequence charSequence = data;
            boolean bl = false;
            if (!(charSequence.length() == 0) && data.charAt(data.length() - 1) != '\n') {
                innerData = innerData + '\n';
            }
            List<ColumnInfo> columnsInfo = this.getColumnsInfo(innerData);
            ArrayList<Column<?>> res = this.readData(innerData, columnsInfo);
            return new DataFrameImpl(res);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

