/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0013R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/datavis/r/ui/InlineToolbar;", "Ljavax/swing/JPanel;", "cell", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "actionToolBar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "Lorg/jetbrains/annotations/NotNull;", "getCell", "()Lcom/intellij/psi/PsiElement;", "couldUpdateBound", "", "numSoftWraps", "", "addSoftWrapListener", "", "paint", "g", "Ljava/awt/Graphics;", "updateBounds", "intellij.notebooks.visualization"})
public final class InlineToolbar
extends JPanel {
    private int numSoftWraps;
    private boolean couldUpdateBound;
    private final ActionToolbar actionToolBar;
    @NotNull
    private final PsiElement cell;
    private final Editor editor;

    private final void addSoftWrapListener() {
        SoftWrapModel softWrapModel = this.editor.getSoftWrapModel();
        if (softWrapModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.SoftWrapModelImpl");
        }
        SoftWrapModelImpl softWrapModel2 = (SoftWrapModelImpl)softWrapModel;
        softWrapModel2.addSoftWrapChangeListener(new SoftWrapChangeListener(this, softWrapModel2){
            final /* synthetic */ InlineToolbar this$0;
            final /* synthetic */ SoftWrapModelImpl $softWrapModel;

            public void softWrapsChanged() {
                if (!this.$softWrapModel.isSoftWrappingEnabled() && InlineToolbar.access$getNumSoftWraps$p(this.this$0) > 0) {
                    InlineToolbar.access$setNumSoftWraps$p(this.this$0, 0);
                    this.this$0.updateBounds();
                }
            }

            public void recalculationEnds() {
                int newNumSoftWraps = this.$softWrapModel.getRegisteredSoftWraps().size();
                if (this.$softWrapModel.isSoftWrappingEnabled() && InlineToolbar.access$getNumSoftWraps$p(this.this$0) != newNumSoftWraps) {
                    InlineToolbar.access$setNumSoftWraps$p(this.this$0, newNumSoftWraps);
                    this.this$0.updateBounds();
                }
            }
            {
                this.this$0 = this$0;
                this.$softWrapModel = $captured_local_variable$1;
            }
        });
        this.numSoftWraps = softWrapModel2.isSoftWrappingEnabled() ? softWrapModel2.getRegisteredSoftWraps().size() : 0;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Composite oldComposite = ((Graphics2D)g).getComposite();
        ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
        super.paint(g);
        ((Graphics2D)g).setComposite(oldComposite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateBounds() {
        if (this.editor.isDisposed() || !this.cell.isValid()) {
            return;
        }
        JComponent jComponent = this.actionToolBar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"actionToolBar.component");
        int toolbarWidth = jComponent.getPreferredSize().width;
        JComponent jComponent2 = this.actionToolBar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"actionToolBar.component");
        int toolbarHeight = jComponent2.getPreferredSize().height;
        EditorGutter editorGutter = this.editor.getGutter();
        if (editorGutter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        }
        int gutterWidth = ((EditorGutterComponentEx)editorGutter).getWidth();
        JComponent jComponent3 = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"editor.component");
        Rectangle editorBounds = jComponent3.getBounds();
        int deltaY = (toolbarHeight - this.editor.getLineHeight()) / 2;
        int newToolbarX = editorBounds.x + editorBounds.width - toolbarWidth - gutterWidth;
        TextRange textRange = this.cell.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"cell.textRange");
        VisualPosition visualPosition = this.editor.offsetToVisualPosition(textRange.getEndOffset() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"editor.offsetToVisualPos\u2026.textRange.endOffset - 1)");
        VisualPosition visual = visualPosition;
        int newToolbarY = this.editor.visualLineToY(visual.line) - deltaY;
        try {
            this.couldUpdateBound = true;
            this.setBounds(new Rectangle(newToolbarX, newToolbarY, toolbarWidth, toolbarHeight));
        }
        finally {
            this.couldUpdateBound = false;
        }
        this.invalidate();
        this.repaint();
    }

    @NotNull
    public final PsiElement getCell() {
        return this.cell;
    }

    /*
     * WARNING - void declaration
     */
    public InlineToolbar(@NotNull PsiElement cell, @NotNull Editor editor, @NotNull ActionGroup toolbarActions) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        super(new BorderLayout());
        this.cell = cell;
        this.editor = editor;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("InlineToolbar", toolbarActions, true);
        boolean bl = false;
        boolean bl2 = false;
        ActionToolbar actionToolbar2 = actionToolbar;
        InlineToolbar inlineToolbar = this;
        boolean bl3 = false;
        $this$apply.setTargetComponent(this.editor.getContentComponent());
        Unit unit = Unit.INSTANCE;
        ActionToolbar actionToolbar3 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar3, (String)"ActionManager.getInstanc\u2026tor.contentComponent)\n  }");
        inlineToolbar.actionToolBar = actionToolbar3;
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        JComponent jComponent = this.actionToolBar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"actionToolBar.component");
        JComponent component = jComponent;
        component.setOpaque(false);
        component.setBackground(new Color(0, 0, 0, 0));
        component.setCursor(Cursor.getPredefinedCursor(12));
        this.add(component);
        this.addSoftWrapListener();
    }

    public static final /* synthetic */ int access$getNumSoftWraps$p(InlineToolbar $this) {
        return $this.numSoftWraps;
    }

    public static final /* synthetic */ void access$setNumSoftWraps$p(InlineToolbar $this, int n) {
        $this.numSoftWraps = n;
    }
}

