/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor.outputs.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.inlays.ResizeController;
import org.intellij.datavis.r.ui.UiCustomizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearanceProviderKt;
import org.jetbrains.plugins.notebooks.editor.outputs.impl.CollapsingComponent;
import org.jetbrains.plugins.notebooks.editor.outputs.impl.NotebookOutputCollapseSingleInCellAction;
import org.jetbrains.plugins.notebooks.editor.outputs.impl.NotebookOutputInlayControllerImplUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0011\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020$H\u0016J\u0006\u0010)\u001a\u00020!J\b\u0010*\u001a\u00020!H\u0016R\u0019\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/impl/CollapsingComponent;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "child", "Ljavax/swing/JComponent;", "resizable", "", "collapsedTextSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljavax/swing/JComponent;ZLkotlin/jvm/functions/Function0;)V", "value", "isSeen", "()Z", "setSeen", "(Z)V", "isWorthCollapsing", "mainComponent", "getMainComponent", "()Ljavax/swing/JComponent;", "oldPredefinedPreferredSize", "Ljava/awt/Dimension;", "resizeController", "Lorg/intellij/datavis/r/inlays/ResizeController;", "getResizeController", "()Lorg/intellij/datavis/r/inlays/ResizeController;", "resizeController$delegate", "Lkotlin/Lazy;", "stubComponent", "getStubComponent", "paintGutter", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "yOffset", "", "g", "Ljava/awt/Graphics;", "remove", "index", "updateStubIfCollapsed", "updateUI", "Companion", "StubComponent", "intellij.notebooks.visualization"})
public final class CollapsingComponent
extends JPanel {
    private final Lazy resizeController$delegate;
    private Dimension oldPredefinedPreferredSize;
    private final boolean resizable;
    private final Function0<String> collapsedTextSupplier;
    public static final int MIN_HEIGHT_TO_COLLAPSE = 50;
    public static final int COLLAPSING_RECT_WIDTH = 22;
    private static final int COLLAPSING_RECT_MARGIN_Y_BOTTOM = 5;
    private static final Lazy LOG$delegate;
    @NotNull
    public static final Companion Companion;

    private final ResizeController getResizeController() {
        Lazy lazy = this.resizeController$delegate;
        CollapsingComponent collapsingComponent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ResizeController)lazy.getValue();
    }

    public final boolean isSeen() {
        return this.getMainComponent().isVisible();
    }

    public final void setSeen(boolean value) {
        this.getMainComponent().setVisible(value);
        this.getStubComponent().setVisible(!value);
        if (this.resizable) {
            if (value) {
                this.addMouseListener(this.getResizeController());
                this.addMouseMotionListener(this.getResizeController());
                this.setPreferredSize(this.oldPredefinedPreferredSize);
                this.oldPredefinedPreferredSize = null;
            } else {
                this.removeMouseListener(this.getResizeController());
                this.removeMouseMotionListener(this.getResizeController());
                this.oldPredefinedPreferredSize = this.isPreferredSizeSet() ? this.getPreferredSize() : null;
                this.setPreferredSize(null);
            }
        }
        if (!value) {
            JComponent jComponent = this.getStubComponent();
            if (jComponent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.editor.outputs.impl.CollapsingComponent.StubComponent");
            }
            ((StubComponent)jComponent).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
    }

    @Override
    public void remove(int index) {
        CollapsingComponent.Companion.getLOG().error("Components should not be deleted from " + this, new Throwable());
        super.remove(index);
    }

    @NotNull
    public final JComponent getMainComponent() {
        Component component = this.getComponent(0);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        return (JComponent)component;
    }

    @NotNull
    public final JComponent getStubComponent() {
        Component component = this.getComponent(1);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        return (JComponent)component;
    }

    public final boolean isWorthCollapsing() {
        return !this.isSeen() || this.getMainComponent().getHeight() >= 50;
    }

    /*
     * WARNING - void declaration
     */
    public final void paintGutter(@NotNull EditorEx editor, int yOffset, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        NotebookEditorAppearance notebookAppearance = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor);
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        Color backgroundColor = notebookAppearance.getCodeCellBackground(editorColorsScheme);
        if (backgroundColor != null && this.isWorthCollapsing()) {
            void rectTop;
            int x = Companion.collapseRectHorizontalLeft(editor);
            Insets insets = this.getInsets();
            boolean bl = false;
            boolean bl2 = false;
            Insets it = insets;
            boolean bl3 = false;
            Pair pair = TuplesKt.to((Object)(yOffset + this.getY() + it.top), (Object)(this.getHeight() - it.top - it.bottom));
            int n = ((Number)pair.component1()).intValue();
            int rectHeight = ((Number)pair.component2()).intValue();
            g.setColor(backgroundColor);
            EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"editor.gutterComponentEx");
            if (NotebookOutputInlayControllerImplUtilKt.getHoveredCollapsingComponentRect(editorGutterComponentEx) == this) {
                g.fillRect(x, (int)rectTop, 22, rectHeight);
            }
            if (!this.isSeen()) {
                int outputAdjacentRectWidth = notebookAppearance.getLeftBorderWidth();
                g.setColor(UiCustomizer.Companion.getInstance().getTextOutputBackground((Editor)editor));
                EditorGutterComponentEx editorGutterComponentEx2 = editor.getGutterComponentEx();
                Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx2, (String)"editor.gutterComponentEx");
                g.fillRect(editorGutterComponentEx2.getWidth() - outputAdjacentRectWidth, (int)rectTop, outputAdjacentRectWidth, rectHeight);
            }
            Icon icon = this.isSeen() ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"if (isSeen) UIUtil.getTr\u2026il.getTreeCollapsedIcon()");
            Icon icon2 = icon;
            int iconOffset = (22 - icon2.getIconWidth()) / 2;
            icon2.paintIcon(this, g, x + iconOffset + 1, yOffset + this.getY() + 5 + iconOffset);
        }
    }

    public final void updateStubIfCollapsed() {
        if (!this.isSeen()) {
            JComponent jComponent = this.getStubComponent();
            if (jComponent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.editor.outputs.impl.CollapsingComponent.StubComponent");
            }
            ((StubComponent)jComponent).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    public CollapsingComponent(@NotNull EditorImpl editor, @NotNull JComponent child, boolean resizable2, @NotNull Function0<String> collapsedTextSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter(collapsedTextSupplier, (String)"collapsedTextSupplier");
        super(new BorderLayout());
        this.resizable = resizable2;
        this.collapsedTextSupplier = collapsedTextSupplier;
        this.resizeController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResizeController>(this, editor){
            final /* synthetic */ CollapsingComponent this$0;
            final /* synthetic */ EditorImpl $editor;

            @NotNull
            public final ResizeController invoke() {
                return new ResizeController(this.this$0, (Editor)this.$editor, null, 4, null);
            }
            {
                this.this$0 = collapsingComponent;
                this.$editor = editorImpl;
                super(0);
            }
        }));
        this.add((Component)child, "Center");
        this.add((Component)new StubComponent(editor), "North");
        this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(0, 0, 10, 0)));
        this.setSeen(true);
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    @JvmStatic
    public static final int collapseRectHorizontalLeft(@NotNull EditorEx editor) {
        return Companion.collapseRectHorizontalLeft(editor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/impl/CollapsingComponent$StubComponent;", "Ljavax/swing/JLabel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "onClick", "", "e", "Ljava/awt/event/MouseEvent;", "updateUI", "updateUIFromEditor", "intellij.notebooks.visualization"})
    private static final class StubComponent
    extends JLabel {
        private final EditorImpl editor;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setOpaque(true);
            if (this.editor != null) {
                this.updateUIFromEditor();
            }
        }

        private final void onClick(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            Container container = this.getParent();
            if (!(container instanceof CollapsingComponent)) {
                container = null;
            }
            CollapsingComponent collapsingComponent = (CollapsingComponent)container;
            if (collapsingComponent == null) {
                return;
            }
            CollapsingComponent parent = collapsingComponent;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction(NotebookOutputCollapseSingleInCellAction.class.getSimpleName());
            Intrinsics.checkNotNull((Object)anAction);
            AnAction action2 = anAction;
            ActionCallback actionCallback = actionManager.tryToExecute(action2, (InputEvent)e, (Component)parent, null, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"actionManager.tryToExecu\u2026n, e, parent, null, true)");
            if (actionCallback.isProcessed()) {
                e.consume();
            }
        }

        private final void updateUIFromEditor() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
            int fontType = textAttributes != null ? textAttributes.getFontType() : 0;
            this.setForeground(JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
            this.setBackground(UiCustomizer.Companion.getInstance().getTextOutputBackground((Editor)this.editor));
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            FontInfo fontInfo = EditorUtil.fontForChar((char)StringsKt.first((CharSequence)string), (int)fontType, (Editor)((Editor)this.editor));
            Intrinsics.checkNotNullExpressionValue((Object)fontInfo, (String)"EditorUtil.fontForChar(t\u2026irst(), fontType, editor)");
            this.setFont(fontInfo.getFont());
        }

        public StubComponent(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super("...");
            this.editor = editor;
            this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(7, 0, 7, 0)));
            this.updateUIFromEditor();
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.onClick(e);
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/impl/CollapsingComponent$Companion;", "", "()V", "COLLAPSING_RECT_MARGIN_Y_BOTTOM", "", "COLLAPSING_RECT_WIDTH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "MIN_HEIGHT_TO_COLLAPSE", "collapseRectHorizontalLeft", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @JvmStatic
        public final int collapseRectHorizontalLeft(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"editor.gutterComponentEx");
            return editorGutterComponentEx.getWidth() - 22 - NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor).getLINE_NUMBERS_MARGIN() - NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor).getCODE_CELL_LEFT_LINE_PADDING();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

