/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.editor.ui.NotebookEditorUiUtilKt;
import org.jetbrains.plugins.notebooks.editor.ui.NotebookEditorUiUtilKt$registerEditorSizeWatcher$1$$special$;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u001a\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002\u001a@\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001a\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"textEditingAreaWidth", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getTextEditingAreaWidth", "(Lcom/intellij/openapi/editor/ex/EditorEx;)I", "registerEditorSizeWatcher", "", "component", "Ljavax/swing/JComponent;", "updateHandler", "Lkotlin/Function0;", "updateUiOnParentResizeImpl", "parent", "childRef", "Ljava/lang/ref/WeakReference;", "addComponentInlay", "Lcom/intellij/openapi/editor/Inlay;", "isRelatedToPrecedingText", "", "showAbove", "showWhenFolded", "priority", "offset", "yOffsetFromEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "intellij.notebooks.visualization"})
public final class NotebookEditorUiUtilKt {
    @NotNull
    public static final Inlay<?> addComponentInlay(@NotNull EditorEx $this$addComponentInlay, @NotNull JComponent component, boolean isRelatedToPrecedingText, boolean showAbove, boolean showWhenFolded, int priority, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$addComponentInlay, (String)"$this$addComponentInlay");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Inlay inlay = EditorEmbeddedComponentManager.getInstance().addComponent($this$addComponentInlay, component, new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, isRelatedToPrecedingText, showAbove, showWhenFolded, priority, offset));
        Intrinsics.checkNotNull((Object)inlay);
        Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"EditorEmbeddedComponentM\u2026      offset,\n    )\n  )!!");
        Inlay inlay2 = inlay;
        Container container = component.getParent();
        if (container == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        NotebookEditorUiUtilKt.updateUiOnParentResizeImpl((JComponent)container, new WeakReference<JComponent>(component));
        return inlay2;
    }

    public static /* synthetic */ Inlay addComponentInlay$default(EditorEx editorEx, JComponent jComponent, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl3 = true;
        }
        return NotebookEditorUiUtilKt.addComponentInlay(editorEx, jComponent, bl, bl2, bl3, n, n2);
    }

    private static final void updateUiOnParentResizeImpl(JComponent parent, WeakReference<JComponent> childRef) {
        ComponentAdapter listener2 = new ComponentAdapter(childRef, parent){
            final /* synthetic */ WeakReference $childRef;
            final /* synthetic */ JComponent $parent;

            public void componentResized(@Nullable ComponentEvent e) {
                JComponent child = (JComponent)this.$childRef.get();
                if (child != null) {
                    child.updateUI();
                } else {
                    this.$parent.removeComponentListener(this);
                }
            }
            {
                this.$childRef = $captured_local_variable$0;
                this.$parent = $captured_local_variable$1;
            }
        };
        parent.addComponentListener(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEditorSizeWatcher(@NotNull JComponent component, @NotNull Function0<Unit> updateHandler) {
        void editorComponent;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(updateHandler, (String)"updateHandler");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        updateHandler.invoke();
        ComponentAdapter editorResizeListener2 = new ComponentAdapter(updateHandler){
            final /* synthetic */ Function0 $updateHandler;

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$updateHandler.invoke();
            }
            {
                this.$updateHandler = $captured_local_variable$0;
            }
        };
        component.addHierarchyListener(new HierarchyListener(component, (Ref.ObjectRef)editorComponent, editorResizeListener2, updateHandler){
            final /* synthetic */ JComponent $component;
            final /* synthetic */ Ref.ObjectRef $editorComponent;
            final /* synthetic */ registerEditorSizeWatcher.editorResizeListener.1 $editorResizeListener;
            final /* synthetic */ Function0 $updateHandler;

            public final void hierarchyChanged(HierarchyEvent event) {
                HierarchyEvent hierarchyEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)hierarchyEvent, (String)"event");
                if ((hierarchyEvent.getChangeFlags() & 1L) != 0L) {
                    Sequence $this$filterIsInstance$iv = SequencesKt.generateSequence((Object)this.$component.getParent(), (Function1)registerEditorSizeWatcher.newEditor.1.INSTANCE);
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)registerEditorSizeWatcher$1$$special$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    EditorComponentImpl newEditor2 = (EditorComponentImpl)SequencesKt.firstOrNull((Sequence)sequence);
                    if ((EditorComponentImpl)this.$editorComponent.element != newEditor2) {
                        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)this.$editorComponent.element;
                        if (editorComponentImpl != null) {
                            editorComponentImpl.removeComponentListener((ComponentListener)this.$editorResizeListener);
                        }
                        this.$editorComponent.element = newEditor2;
                        EditorComponentImpl editorComponentImpl2 = (EditorComponentImpl)this.$editorComponent.element;
                        if (editorComponentImpl2 != null) {
                            editorComponentImpl2.addComponentListener((ComponentListener)this.$editorResizeListener);
                        }
                        this.$updateHandler.invoke();
                    }
                }
            }
            {
                this.$component = jComponent;
                this.$editorComponent = objectRef;
                this.$editorResizeListener = var3_3;
                this.$updateHandler = function0;
            }
        });
    }

    public static final int getTextEditingAreaWidth(@NotNull EditorEx $this$textEditingAreaWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$textEditingAreaWidth, (String)"$this$textEditingAreaWidth");
        ScrollingModelEx scrollingModelEx = $this$textEditingAreaWidth.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"scrollingModel");
        int n = scrollingModelEx.getVisibleArea().width;
        JScrollPane jScrollPane = $this$textEditingAreaWidth.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"scrollPane");
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
        return n - jScrollBar.getWidth();
    }

    @Nullable
    public static final Integer yOffsetFromEditor(@NotNull JComponent $this$yOffsetFromEditor, @NotNull Editor editor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$yOffsetFromEditor, (String)"$this$yOffsetFromEditor");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Integer n2 = SwingUtilities.convertPoint((Component)((Component)$this$yOffsetFromEditor), (int)0, (int)0, (Component)((Component)editor.getContentComponent())).y;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 != null) {
            n2 = n3;
            bl = false;
            bl2 = false;
            it = ((Number)n2).intValue();
            boolean bl4 = false;
            n = it + $this$yOffsetFromEditor.getInsets().top;
        } else {
            n = null;
        }
        return n;
    }
}

