/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.content;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import libraries.io.blobs.BlobUtils;
import libraries.io.blobs.ContentDigest;
import libraries.io.blobs.MessageDigestPool;
import libraries.io.blobs.MessageDigestsPools;
import libraries.io.content.BlobContent;
import libraries.io.content.Digest;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Llibraries/io/content/DigestContent;", "Llibraries/io/content/BlobContent;", "delegate", "algorithm", "", "length", "", "contentType", "(Llibraries/io/content/BlobContent;Ljava/lang/String;JLjava/lang/String;)V", "getContentType", "()Ljava/lang/String;", "digest", "Llibraries/io/content/Digest;", "getDigest", "()Llibraries/io/content/Digest;", "getLength", "()J", "payload", "Lkotlinx/coroutines/flow/Flow;", "Ljava/nio/ByteBuffer;", "getPayload", "()Lkotlinx/coroutines/flow/Flow;", "payloadDigest", "Llibraries/io/blobs/ContentDigest;", "initializeAndRecycle", "", "messageDigest", "Ljava/security/MessageDigest;", "digestPool", "Llibraries/io/blobs/MessageDigestPool;", "Companion", "libraries-io"})
public final class DigestContent
implements BlobContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlobContent delegate;
    @NotNull
    private final String algorithm;
    private final long length;
    @NotNull
    private final String contentType;
    private ContentDigest payloadDigest;
    @NotNull
    private static final KLogger logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(DigestContent.class));

    public DigestContent(@NotNull BlobContent delegate, @NotNull String algorithm, long length, @NotNull String contentType2) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.delegate = delegate;
        this.algorithm = algorithm;
        this.length = length;
        this.contentType = contentType2;
    }

    public /* synthetic */ DigestContent(BlobContent blobContent, String string2, long l, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = blobContent.getLength();
        }
        if ((n & 8) != 0) {
            string3 = blobContent.getContentType();
        }
        this(blobContent, string2, l, string3);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final Digest getDigest() {
        ContentDigest contentDigest;
        ContentDigest contentDigest2;
        ContentDigest contentDigest3 = this.payloadDigest;
        if (contentDigest3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadDigest");
            contentDigest2 = null;
        } else {
            contentDigest2 = contentDigest3;
        }
        String string2 = contentDigest2.getAlgorithm();
        contentDigest3 = this.payloadDigest;
        if (contentDigest3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadDigest");
            contentDigest = null;
        } else {
            contentDigest = contentDigest3;
        }
        return new Digest(string2, contentDigest.getValue());
    }

    @Override
    @NotNull
    public Flow<ByteBuffer> getPayload() {
        MessageDigestPool digestPool = MessageDigestsPools.INSTANCE.getPool(this.algorithm);
        MessageDigest messageDigest = (MessageDigest)digestPool.borrow();
        Flow flow2 = FlowKt.onCompletion((Flow)FlowKt.onEach(this.delegate.getPayload(), (Function2)((Function2)new Function2<ByteBuffer, Continuation<? super Unit>, Object>(messageDigest, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ MessageDigest $messageDigest;
            {
                this.$messageDigest = $messageDigest;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ByteBuffer chunk = (ByteBuffer)this.L$0;
                        this.$messageDigest.update(chunk);
                        chunk.flip();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<ByteBuffer, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ByteBuffer p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super ByteBuffer>, Throwable, Continuation<? super Unit>, Object>(this, messageDigest, digestPool, null){
            int label;
            final /* synthetic */ DigestContent this$0;
            final /* synthetic */ MessageDigest $messageDigest;
            final /* synthetic */ MessageDigestPool $digestPool;
            {
                this.this$0 = $receiver;
                this.$messageDigest = $messageDigest;
                this.$digestPool = $digestPool;
                super(3, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DigestContent.access$initializeAndRecycle(this.this$0, this.$messageDigest, this.$digestPool);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ByteBuffer> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend((Object)Unit.INSTANCE);
            }
        }));
        if (this.payloadDigest == null) {
            KLogger this_$iv = logger;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = "Uninitialized payload digest access - set empty content digest";
                kLogger.warn(string2);
            }
            this.initializeAndRecycle(messageDigest, digestPool);
        }
        return flow2;
    }

    private final void initializeAndRecycle(MessageDigest messageDigest, MessageDigestPool digestPool) {
        this.payloadDigest = BlobUtils.INSTANCE.getDigest(messageDigest);
        digestPool.recycle(messageDigest);
    }

    public static final /* synthetic */ void access$initializeAndRecycle(DigestContent $this, MessageDigest messageDigest, MessageDigestPool digestPool) {
        $this.initializeAndRecycle(messageDigest, digestPool);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llibraries/io/content/DigestContent$Companion;", "", "()V", "logger", "Llibraries/klogging/KLogger;", "libraries-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

