/*
 * Decompiled with CFR 0.152.
 */
package libraries.process;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import libraries.io.CheckedOutputStream;
import libraries.io.FileUtil;
import libraries.io.StreamsKt;
import libraries.io.ThreadUtil;
import libraries.klogging.KLogger;
import libraries.klogging.MDC;
import libraries.process.Cancellation;
import libraries.process.ProcessHandle;
import libraries.process.ProcessOutputWatcher;
import libraries.process.ProcessRunner;
import libraries.process.ProcessRunnerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002;<B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0082\bJ\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\rJb\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020\u0007J\u0086\u0001\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0016\u0010(\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030*\u0012\u0004\u0012\u00020+0)2\u0016\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030*\u0012\u0004\u0012\u00020+0)2\u0016\u0010-\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030*\u0012\u0004\u0012\u00020+0)2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u000200H\u0002JD\u00101\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020/H\u0002J\"\u00107\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u00108\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J<\u00109\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u00020\u001f2\u0006\u00103\u001a\u00020:2\u0006\u00105\u001a\u00020+H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Llibraries/process/ProcessRunner;", "Ljava/io/Closeable;", "nThreads", "", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "logEnv", "", "(ILjava/util/concurrent/ThreadFactory;Z)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "catchAll", "", "action", "Lkotlin/Function0;", "close", "destroy", "executeProcess", "Llibraries/process/ProcessHandle;", "processId", "", "workdir", "Ljava/io/File;", "argz", "", "environmentPatch", "", "idleTimeout", "", "stdIn", "Ljava/io/InputStream;", "stdOut", "Llibraries/io/CheckedOutputStream;", "stdErr", "redirectErrorStream", "handle", "startNano", "process", "Ljava/lang/Process;", "myStdErrThread", "Lkotlin/Pair;", "Ljava/util/concurrent/Future;", "Ljava/util/concurrent/atomic/AtomicLong;", "myStdInThread", "myStdOutThread", "idleProcessWatcher", "Llibraries/process/ProcessOutputWatcher;", "Llibraries/process/ProcessRunner$StreamAccumulator;", "readStream", "streamName", "outputStream", "inputStream", "counter", "processOutputWatcher", "submit", "name", "writeStream", "Ljava/io/OutputStream;", "SleepSequence", "StreamAccumulator", "libraries-process"})
public final class ProcessRunner
implements Closeable {
    private final boolean logEnv;
    private final ExecutorService executor;

    public ProcessRunner(int nThreads, @NotNull ThreadFactory threadFactory, boolean logEnv) {
        Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
        this.logEnv = logEnv;
        this.executor = Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public /* synthetic */ ProcessRunner(int n, ThreadFactory threadFactory, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(n, threadFactory, bl);
    }

    public final void destroy() {
        this.executor.shutdown();
    }

    @Override
    public void close() {
        this.destroy();
    }

    private final Future<?> submit(String name2, Function0<Unit> action2) {
        MDC.StickyMDC mdc = MDC.INSTANCE.copy();
        Future<?> future = this.executor.submit(() -> ProcessRunner.submit$lambda-1(name2, mdc, action2));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit {\n      \u2026}\n            }\n        }");
        return future;
    }

    private final void catchAll(Function0<Unit> action2) {
        block2: {
            boolean $i$f$catchAll = false;
            try {
                action2.invoke();
            }
            catch (Throwable t) {
                KLogger this_$iv = ProcessRunnerKt.access$getLog$p();
                boolean $i$f$trace = false;
                if (!this_$iv.isTraceEnabled()) break block2;
                Throwable throwable = t;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t.getMessage());
                kLogger.trace(throwable, string2);
            }
        }
    }

    @NotNull
    public final ProcessHandle executeProcess(@NotNull String processId, @NotNull File workdir, @NotNull List<String> argz, @NotNull Map<String, String> environmentPatch, long idleTimeout, @NotNull InputStream stdIn, @NotNull CheckedOutputStream stdOut, @NotNull CheckedOutputStream stdErr, boolean redirectErrorStream) throws IOException {
        boolean $i$f$debug;
        KLogger this_$iv;
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)workdir, (String)"workdir");
        Intrinsics.checkNotNullParameter(argz, (String)"argz");
        Intrinsics.checkNotNullParameter(environmentPatch, (String)"environmentPatch");
        Intrinsics.checkNotNullParameter((Object)stdIn, (String)"stdIn");
        Intrinsics.checkNotNullParameter((Object)stdOut, (String)"stdOut");
        Intrinsics.checkNotNullParameter((Object)stdErr, (String)"stdErr");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(workdir);
        pb.command(new ArrayList(argz));
        pb.environment().putAll((Map<String, String>)new LinkedHashMap<String, String>(environmentPatch));
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)pb.environment().keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key2 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key");
            if (StringsKt.startsWith$default((String)key2, (String)"Apple_", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"XDG_", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"JAVA_MAIN_CLASS_", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"GNOME", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"XPC_", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"__CF_", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"SSH", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"DISPLAY", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"DBUS", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"DESKTOP", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"GTK", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"QT", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"SESSION", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"XAUTHORITY", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"XDG", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (StringsKt.startsWith$default((String)key2, (String)"GIT_TRACE", (boolean)false, (int)2, null)) {
                pb.environment().remove(key2);
                continue;
            }
            if (!StringsKt.startsWith$default((String)key2, (String)"GIT_", (boolean)false, (int)2, null) || environmentPatch.containsKey(key2)) continue;
            pb.environment().remove(key2);
        }
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        if (redirectErrorStream) {
            pb.redirectErrorStream(true);
        }
        String message2 = "Process " + processId + '[' + CollectionsKt.joinToString$default((Iterable)argz, (CharSequence)" ", null, null, (int)0, null, (Function1)executeProcess.message.1.INSTANCE, (int)30, null) + ']';
        if (this.logEnv) {
            this_$iv = ProcessRunnerKt.access$getLog$p();
            $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = message2 + " env: " + environmentPatch;
                kLogger.debug(string2);
            }
        } else {
            this_$iv = ProcessRunnerKt.access$getLog$p();
            $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string3 = message2;
                kLogger.debug(string3);
            }
        }
        StreamAccumulator accStdErr = new StreamAccumulator(stdErr);
        long start2 = System.nanoTime();
        Process process2 = pb.start();
        try {
            AtomicLong stdInCounter = new AtomicLong(0L);
            AtomicLong stdOutCounter = new AtomicLong(0L);
            AtomicLong stdErrCounter = new AtomicLong(0L);
            ProcessOutputWatcher idleProcessWatcher = new ProcessOutputWatcher(idleTimeout);
            String string4 = processId + '(' + CollectionsKt.take((Iterable)argz, (int)2) + ')';
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            OutputStream outputStream = process2.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"process.outputStream");
            Future<?> myStdInThread = this.writeStream(string4, "stdin", process2, stdIn, outputStream, stdInCounter);
            String string5 = processId + '(' + CollectionsKt.take((Iterable)argz, (int)2) + ')';
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            Future<?> myStdOutThread = this.readStream(string5, "stdout", process2, stdOut, inputStream, stdOutCounter, idleProcessWatcher);
            String string6 = processId + '(' + CollectionsKt.take((Iterable)argz, (int)2) + ')';
            CheckedOutputStream checkedOutputStream = StreamsKt.checkedStream$default(accStdErr, null, 1, null);
            InputStream inputStream2 = process2.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
            Future<?> myStdErrThread = this.readStream(string6, "stderr", process2, checkedOutputStream, inputStream2, stdErrCounter, idleProcessWatcher);
            return this.handle(start2, processId, process2, TuplesKt.to(myStdErrThread, (Object)stdErrCounter), TuplesKt.to(myStdInThread, (Object)stdInCounter), TuplesKt.to(myStdOutThread, (Object)stdOutCounter), argz, idleProcessWatcher, accStdErr);
        }
        catch (Throwable t) {
            ProcessRunnerKt.access$getLog$p().warn('[' + processId + "] Failed to start process: " + t.getMessage());
            process2.destroyForcibly();
            throw new IOException("Failed to start process " + processId + '(' + CollectionsKt.take((Iterable)argz, (int)2) + ") stream processing tasks. " + t.getMessage(), t);
        }
    }

    public static /* synthetic */ ProcessHandle executeProcess$default(ProcessRunner processRunner2, String string2, File file2, List list, Map map2, long l, InputStream inputStream, CheckedOutputStream checkedOutputStream, CheckedOutputStream checkedOutputStream2, boolean bl, int n, Object object) throws IOException {
        if ((n & 0x100) != 0) {
            bl = false;
        }
        return processRunner2.executeProcess(string2, file2, list, map2, l, inputStream, checkedOutputStream, checkedOutputStream2, bl);
    }

    private final ProcessHandle handle(long startNano, String processId, Process process2, Pair<? extends Future<?>, ? extends AtomicLong> myStdErrThread, Pair<? extends Future<?>, ? extends AtomicLong> myStdInThread, Pair<? extends Future<?>, ? extends AtomicLong> myStdOutThread, List<String> argz, ProcessOutputWatcher idleProcessWatcher, StreamAccumulator stdErr) {
        return new ProcessHandle(process2, myStdInThread, myStdOutThread, myStdErrThread, idleProcessWatcher, processId, argz, stdErr, this, startNano){
            @NotNull
            private final AtomicBoolean isClosed;
            final /* synthetic */ Process $process;
            final /* synthetic */ Pair<Future<?>, AtomicLong> $myStdInThread;
            final /* synthetic */ Pair<Future<?>, AtomicLong> $myStdOutThread;
            final /* synthetic */ Pair<Future<?>, AtomicLong> $myStdErrThread;
            final /* synthetic */ ProcessOutputWatcher $idleProcessWatcher;
            final /* synthetic */ String $processId;
            final /* synthetic */ List<String> $argz;
            final /* synthetic */ StreamAccumulator $stdErr;
            final /* synthetic */ ProcessRunner this$0;
            final /* synthetic */ long $startNano;
            {
                this.$process = $process;
                this.$myStdInThread = $myStdInThread;
                this.$myStdOutThread = $myStdOutThread;
                this.$myStdErrThread = $myStdErrThread;
                this.$idleProcessWatcher = $idleProcessWatcher;
                this.$processId = $processId;
                this.$argz = $argz;
                this.$stdErr = $stdErr;
                this.this$0 = $receiver;
                this.$startNano = $startNano;
                this.isClosed = new AtomicBoolean(false);
            }

            public boolean isAlive() {
                return this.$process.isAlive();
            }

            public int getExitCode() {
                return this.$process.exitValue();
            }

            public long getStdInCounter() {
                return ((AtomicLong)this.$myStdInThread.getSecond()).get();
            }

            public long getStdOutCounter() {
                return ((AtomicLong)this.$myStdOutThread.getSecond()).get();
            }

            public long getStdErrCounter() {
                return ((AtomicLong)this.$myStdErrThread.getSecond()).get();
            }

            public void waitFor(@Nullable Function0<Cancellation> cancel) {
                block30: {
                    if (!this.isClosed.compareAndSet(false, true)) {
                        return;
                    }
                    try {
                        Object object;
                        block26: {
                            ProcessRunner this_$iv;
                            String string2;
                            boolean bl;
                            KLogger kLogger;
                            boolean $i$f$trace;
                            KLogger this_$iv$iv;
                            boolean $i$f$catchAll;
                            block25: {
                                block24: {
                                    block23: {
                                        String message2;
                                        Object object2;
                                        boolean bl2;
                                        int step = 1;
                                        do {
                                            Cancellation cancellation;
                                            long l = 100L;
                                            long l2 = this.$idleProcessWatcher.getIdleTimeout() / 3L;
                                            bl2 = false;
                                            long waitMillis = Math.min(l, l2);
                                            if (this.$process.waitFor(waitMillis, TimeUnit.MILLISECONDS)) break block23;
                                            int n = step;
                                            step = n + 1;
                                            object2 = cancel;
                                            Cancellation cancellation2 = object2 == null ? null : (Cancellation)object2.invoke();
                                            Cancellation cancellation3 = cancellation = cancellation2 == null ? Cancellation.Companion.getDoNotCancel() : cancellation2;
                                            if (!cancellation.getCancel()) continue;
                                            message2 = "Process " + this.$processId + '(' + CollectionsKt.take((Iterable)this.$argz, (int)2) + ") is cancelled (" + cancellation.getReason() + ')';
                                            object2 = '\n' + message2 + " and will be terminated\n";
                                            Charset charset = Charsets.UTF_8;
                                            bl2 = false;
                                            Object object3 = object2;
                                            if (object3 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                            }
                                            byte[] byArray = ((String)object3).getBytes(charset);
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                                            this.$stdErr.write(byArray);
                                            this.$stdErr.flush();
                                            throw new IOException(message2);
                                        } while (step <= 2 || !this.$idleProcessWatcher.isIdle());
                                        message2 = "Process " + this.$processId + '(' + CollectionsKt.take((Iterable)this.$argz, (int)2) + ") doesn't produce any output for " + this.$idleProcessWatcher.getIdleTimeout() + "ms";
                                        object2 = '\n' + message2 + ", it will be terminated\n";
                                        Charset charset = Charsets.UTF_8;
                                        bl2 = false;
                                        Object object4 = object2;
                                        if (object4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                        }
                                        byte[] byArray = ((String)object4).getBytes(charset);
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                                        this.$stdErr.write(byArray);
                                        this.$stdErr.flush();
                                        throw new IOException(message2);
                                    }
                                    ProcessRunner waitMillis = this.this$0;
                                    object = this.$myStdErrThread;
                                    $i$f$catchAll = false;
                                    try {
                                        boolean bl3 = false;
                                        ((Future)object.getFirst()).get();
                                    }
                                    catch (Throwable t$iv) {
                                        this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                        $i$f$trace = false;
                                        if (!this_$iv$iv.isTraceEnabled()) break block24;
                                        Throwable bl3 = t$iv;
                                        kLogger = this_$iv$iv;
                                        bl = false;
                                        string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                        kLogger.trace(bl3, string2);
                                    }
                                }
                                this_$iv = this.this$0;
                                object = this.$myStdOutThread;
                                $i$f$catchAll = false;
                                try {
                                    boolean bl4 = false;
                                    ((Future)object.getFirst()).get();
                                }
                                catch (Throwable t$iv) {
                                    this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                    $i$f$trace = false;
                                    if (!this_$iv$iv.isTraceEnabled()) break block25;
                                    Throwable bl4 = t$iv;
                                    kLogger = this_$iv$iv;
                                    bl = false;
                                    string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                    kLogger.trace(bl4, string2);
                                }
                            }
                            this_$iv = this.this$0;
                            object = this.$myStdInThread;
                            $i$f$catchAll = false;
                            try {
                                boolean bl5 = false;
                                ((Future)object.getFirst()).cancel(true);
                            }
                            catch (Throwable t$iv) {
                                this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                $i$f$trace = false;
                                if (!this_$iv$iv.isTraceEnabled()) break block26;
                                Throwable bl5 = t$iv;
                                kLogger = this_$iv$iv;
                                bl = false;
                                string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                kLogger.trace(bl5, string2);
                            }
                        }
                        if (this.getExitCode() == 0) {
                            ProcessRunnerKt.access$getLog$p().debug("Process " + this.$processId + '(' + CollectionsKt.take((Iterable)this.$argz, (int)2) + ") exited with code " + this.getExitCode() + ". Transferred " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdInCounter(), 0, false, 6, null) + " to stdin, " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdOutCounter(), 0, false, 6, null) + " from stdout, " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdErrCounter(), 0, false, 6, null) + " from stderr. Took " + this.getElapsedMs() + " ms");
                        } else {
                            object = this.$stdErr.getBuffer().toByteArray();
                            Intrinsics.checkNotNullExpressionValue(object, (String)"stdErr.buffer.toByteArray()");
                            Charset $i$f$catchAll22 = Charsets.UTF_8;
                            boolean bl5 = false;
                            boolean t$iv = false;
                            object = new String((byte[])object, $i$f$catchAll22);
                            boolean $i$f$catchAll22 = false;
                            String stdErrContents = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                            object = stdErrContents;
                            $i$f$catchAll22 = false;
                            ProcessRunnerKt.access$getLog$p().warn("Process " + this.$processId + '(' + CollectionsKt.take((Iterable)this.$argz, (int)2) + ") exited with error code " + this.getExitCode() + ". Transferred " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdInCounter(), 0, false, 6, null) + " to stdin, " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdOutCounter(), 0, false, 6, null) + " from stdout, " + FileUtil.formatFileSize$default(FileUtil.INSTANCE, this.getStdErrCounter(), 0, false, 6, null) + " from stderr.\nstderr: " + (object.length() == 0 ? "<empty>" : Intrinsics.stringPlus((String)"\n", (Object)stdErrContents)) + ". Took " + this.getElapsedMs() + " ms");
                        }
                    }
                    catch (Throwable ie) {
                        String string3;
                        boolean bl;
                        KLogger kLogger;
                        boolean $i$f$trace;
                        KLogger this_$iv$iv;
                        boolean $i$f$catchAll;
                        ProcessRunner this_$iv;
                        Pair<Future<?>, AtomicLong> pair;
                        block29: {
                            block28: {
                                block27: {
                                    KLogger stdErrContents = ProcessRunnerKt.access$getLog$p();
                                    pair = this.$processId;
                                    List<String> $i$f$catchAll22 = this.$argz;
                                    boolean $i$f$warn = false;
                                    if (((KLogger)((Object)this_$iv)).isWarnEnabled()) {
                                        Throwable throwable = ie;
                                        void var13_56 = this_$iv;
                                        boolean bl6 = false;
                                        String string4 = "Process " + (String)pair + '(' + CollectionsKt.take((Iterable)$i$f$catchAll22, (int)2) + ") terminated by exception after " + this.getElapsedMs() + " ms. " + ie.getMessage();
                                        var13_56.warn(throwable, string4);
                                    }
                                    this_$iv = this.this$0;
                                    pair = this.$process;
                                    $i$f$catchAll = false;
                                    try {
                                        boolean bl7 = false;
                                        pair.destroyForcibly().waitFor();
                                    }
                                    catch (Throwable t$iv) {
                                        this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                        $i$f$trace = false;
                                        if (!this_$iv$iv.isTraceEnabled()) break block27;
                                        Throwable bl7 = t$iv;
                                        kLogger = this_$iv$iv;
                                        bl = false;
                                        string3 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                        kLogger.trace(bl7, string3);
                                    }
                                }
                                this_$iv = this.this$0;
                                pair = this.$myStdInThread;
                                $i$f$catchAll = false;
                                try {
                                    boolean bl8 = false;
                                    ((Future)pair.getFirst()).cancel(true);
                                }
                                catch (Throwable t$iv) {
                                    this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                    $i$f$trace = false;
                                    if (!this_$iv$iv.isTraceEnabled()) break block28;
                                    Throwable bl8 = t$iv;
                                    kLogger = this_$iv$iv;
                                    bl = false;
                                    string3 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                    kLogger.trace(bl8, string3);
                                }
                            }
                            this_$iv = this.this$0;
                            pair = this.$myStdErrThread;
                            $i$f$catchAll = false;
                            try {
                                boolean bl9 = false;
                                ((Future)pair.getFirst()).cancel(true);
                            }
                            catch (Throwable t$iv) {
                                this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                $i$f$trace = false;
                                if (!this_$iv$iv.isTraceEnabled()) break block29;
                                Throwable bl9 = t$iv;
                                kLogger = this_$iv$iv;
                                bl = false;
                                string3 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                kLogger.trace(bl9, string3);
                            }
                        }
                        this_$iv = this.this$0;
                        pair = this.$myStdOutThread;
                        $i$f$catchAll = false;
                        try {
                            boolean bl10 = false;
                            ((Future)pair.getFirst()).cancel(true);
                        }
                        catch (Throwable t$iv) {
                            this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                            $i$f$trace = false;
                            if (!this_$iv$iv.isTraceEnabled()) break block30;
                            Throwable throwable = t$iv;
                            kLogger = this_$iv$iv;
                            bl = false;
                            string3 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                            kLogger.trace(throwable, string3);
                        }
                    }
                }
            }

            private final long getElapsedMs() {
                return (System.nanoTime() - this.$startNano) / (long)1000000;
            }
        };
    }

    private final Future<?> readStream(String processId, String streamName, Process process2, CheckedOutputStream outputStream, InputStream inputStream, AtomicLong counter2, ProcessOutputWatcher processOutputWatcher) {
        return this.submit("reading " + processId + ' ' + streamName, (Function0<Unit>)((Function0)new Function0<Unit>(inputStream, streamName, processOutputWatcher, outputStream, counter2, process2, this){
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ String $streamName;
            final /* synthetic */ ProcessOutputWatcher $processOutputWatcher;
            final /* synthetic */ CheckedOutputStream $outputStream;
            final /* synthetic */ AtomicLong $counter;
            final /* synthetic */ Process $process;
            final /* synthetic */ ProcessRunner this$0;
            {
                this.$inputStream = $inputStream;
                this.$streamName = $streamName;
                this.$processOutputWatcher = $processOutputWatcher;
                this.$outputStream = $outputStream;
                this.$counter = $counter;
                this.$process = $process;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                KLogger this_$iv$iv;
                boolean $i$f$catchAll;
                byte[] myBuff = new byte[4096];
                long[] lArray = new long[]{0L, 1L, 5L, 10L, 67L, 147L, 333L, 765L};
                SleepSequence sleepSequence = new SleepSequence(lArray);
                long gracefulShutdownTimeout = 3000L;
                try {
                    block25: while (!Thread.currentThread().isInterrupted()) {
                        block35: {
                            int available22;
                            boolean updated = false;
                            while ((available22 = this.$inputStream.available()) > 0) {
                                int n = myBuff.length;
                                boolean bl = false;
                                int read2 = this.$inputStream.read(myBuff, 0, Math.min(available22, n));
                                if (read2 < 0) {
                                    ProcessRunnerKt.access$getLog$p().trace(Intrinsics.stringPlus((String)this.$streamName, (Object)" eof"));
                                    break block25;
                                }
                                if (read2 == 0) break;
                                updated = true;
                                this.$processOutputWatcher.onRead();
                                this.$outputStream.write(myBuff, 0, read2);
                                this.$counter.set(this.$counter.get() + (long)read2);
                                Thread.yield();
                            }
                            if (updated) {
                                this.$outputStream.flush();
                                sleepSequence.reset();
                                Thread.yield();
                                continue;
                            }
                            if (this.$process.waitFor(sleepSequence.next(), TimeUnit.MILLISECONDS)) break;
                            if (this.$outputStream.isOpen()) continue;
                            ProcessRunner available22 = this.this$0;
                            InputStream read2 = this.$inputStream;
                            boolean $i$f$catchAll2 = false;
                            try {
                                boolean bl = false;
                                read2.close();
                            }
                            catch (Throwable t$iv) {
                                KLogger this_$iv$iv2 = ProcessRunnerKt.access$getLog$p();
                                boolean $i$f$trace2 = false;
                                if (!this_$iv$iv2.isTraceEnabled()) break block35;
                                Throwable bl = t$iv;
                                KLogger kLogger = this_$iv$iv2;
                                boolean $i$a$-trace-ProcessRunner$catchAll$1$iv2 = false;
                                String string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                kLogger.trace(bl, string2);
                            }
                        }
                        if (this.$process.waitFor(gracefulShutdownTimeout, TimeUnit.MILLISECONDS)) break;
                        throw new Error(Intrinsics.stringPlus((String)this.$streamName, (Object)" is closed"));
                    }
                    if (this.$outputStream.isOpen()) {
                        int bytes22;
                        while (!Thread.currentThread().isInterrupted() && (bytes22 = this.$inputStream.read(myBuff, 0, myBuff.length)) > 0) {
                            this.$outputStream.write(myBuff, 0, bytes22);
                            this.$counter.set(this.$counter.get() + (long)bytes22);
                            Thread.yield();
                        }
                        ProcessRunner bytes22 = this.this$0;
                        CheckedOutputStream this_$iv2 = this.$outputStream;
                        $i$f$catchAll = false;
                        try {
                            boolean bl = false;
                            this_$iv2.flush();
                        }
                        catch (Throwable t$iv) {
                            this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                            boolean $i$f$trace = false;
                            if (this_$iv$iv.isTraceEnabled()) {
                                Throwable bl = t$iv;
                                KLogger $i$f$trace2 = this_$iv$iv;
                                boolean bl2 = false;
                                String $i$a$-trace-ProcessRunner$catchAll$1$iv2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                $i$f$trace2.trace(bl, $i$a$-trace-ProcessRunner$catchAll$1$iv2);
                            }
                        }
                    }
                }
                catch (InterruptedException this_$iv) {
                }
                catch (InterruptedIOException this_$iv) {
                }
                catch (Throwable t) {
                    if (this.$process.isAlive()) {
                        Object this_$iv2 = ProcessRunnerKt.access$getLog$p();
                        Object $i$f$catchAll3 = this.$streamName;
                        boolean $i$f$warn = false;
                        if (((KLogger)this_$iv2).isWarnEnabled()) {
                            Throwable throwable = t;
                            Object object = this_$iv2;
                            boolean bl = false;
                            String string3 = "Failed to complete IO in " + (String)$i$f$catchAll3 + ". " + t.getMessage() + ". Process will be killed";
                            ((KLogger)object).warn(throwable, string3);
                        }
                        this_$iv2 = this.this$0;
                        $i$f$catchAll3 = this.$process;
                        boolean $i$f$catchAll4 = false;
                        try {
                            boolean bl = false;
                            ((Process)$i$f$catchAll3).destroyForcibly();
                        }
                        catch (Throwable t$iv) {
                            KLogger this_$iv$iv3 = ProcessRunnerKt.access$getLog$p();
                            boolean $i$f$trace = false;
                            if (this_$iv$iv3.isTraceEnabled()) {
                                Throwable bl = t$iv;
                                KLogger $i$a$-trace-ProcessRunner$catchAll$1$iv3 = this_$iv$iv3;
                                $i$a$-trace-ProcessRunner$catchAll$1$iv = false;
                                String string4 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                $i$a$-trace-ProcessRunner$catchAll$1$iv3.trace(bl, string4);
                            }
                        }
                    }
                }
                finally {
                    block37: {
                        ProcessRunner this_$iv = this.this$0;
                        InputStream this_$iv2 = this.$inputStream;
                        $i$f$catchAll = false;
                        try {
                            boolean bl = false;
                            this_$iv2.close();
                        }
                        catch (Throwable t$iv) {
                            this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                            boolean $i$f$trace = false;
                            if (!this_$iv$iv.isTraceEnabled()) break block37;
                            Throwable bl = t$iv;
                            KLogger $i$f$trace2 = this_$iv$iv;
                            $i$a$-trace-ProcessRunner$catchAll$1$iv = false;
                            String $i$a$-trace-ProcessRunner$catchAll$1$iv2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                            $i$f$trace2.trace(bl, $i$a$-trace-ProcessRunner$catchAll$1$iv2);
                        }
                    }
                }
            }
        }));
    }

    private final Future<?> writeStream(String processId, String streamName, Process process2, InputStream inputStream, OutputStream outputStream, AtomicLong counter2) {
        return this.submit("writing " + processId + ' ' + streamName, (Function0<Unit>)((Function0)new Function0<Unit>(inputStream, streamName, outputStream, counter2, this, process2){
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ String $streamName;
            final /* synthetic */ OutputStream $outputStream;
            final /* synthetic */ AtomicLong $counter;
            final /* synthetic */ ProcessRunner this$0;
            final /* synthetic */ Process $process;
            {
                this.$inputStream = $inputStream;
                this.$streamName = $streamName;
                this.$outputStream = $outputStream;
                this.$counter = $counter;
                this.this$0 = $receiver;
                this.$process = $process;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                block30: {
                    Object this_$iv;
                    byte[] buffer2 = new byte[4096];
                    long[] lArray = new long[]{0L, 1L, 5L, 10L, 67L, 147L, 333L, 765L};
                    SleepSequence sleepSequence = new SleepSequence(lArray);
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            while (true) {
                                block31: {
                                    int read2;
                                    if ((read2 = this.$inputStream.read(buffer2, 0, buffer2.length)) < 0) {
                                        ProcessRunnerKt.access$getLog$p().trace(Intrinsics.stringPlus((String)this.$streamName, (Object)" eof"));
                                        break block30;
                                    }
                                    if (read2 == 0) break;
                                    this.$outputStream.write(buffer2, 0, read2);
                                    this.$counter.set(this.$counter.get() + (long)read2);
                                    ProcessRunner processRunner2 = this.this$0;
                                    OutputStream outputStream = this.$outputStream;
                                    boolean $i$f$catchAll = false;
                                    try {
                                        boolean bl = false;
                                        outputStream.flush();
                                    }
                                    catch (Throwable t$iv) {
                                        KLogger this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                        boolean $i$f$trace2 = false;
                                        if (!this_$iv$iv.isTraceEnabled()) break block31;
                                        Throwable bl = t$iv;
                                        KLogger kLogger = this_$iv$iv;
                                        boolean $i$a$-trace-ProcessRunner$catchAll$1$iv2 = false;
                                        String string2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                        kLogger.trace(bl, string2);
                                    }
                                }
                                sleepSequence.reset();
                                Thread.yield();
                            }
                            if (!this.$process.waitFor(sleepSequence.next(), TimeUnit.MILLISECONDS)) continue;
                            break;
                        }
                    }
                    catch (InterruptedException t) {
                        if (this.$process.isAlive()) {
                            this_$iv = ProcessRunnerKt.access$getLog$p();
                            String $i$f$catchAll = this.$streamName;
                            boolean $i$f$debug = false;
                            if (((KLogger)this_$iv).isDebugEnabled()) {
                                Throwable throwable = t;
                                Object object = this_$iv;
                                boolean bl = false;
                                String string3 = Intrinsics.stringPlus((String)"Failed to complete IO in ", (Object)$i$f$catchAll);
                                ((KLogger)object).debug(throwable, string3);
                            }
                        }
                    }
                    catch (InterruptedIOException t) {
                        if (this.$process.isAlive()) {
                            KLogger this_$iv2 = ProcessRunnerKt.access$getLog$p();
                            String $i$f$catchAll = this.$streamName;
                            boolean $i$f$debug = false;
                            if (this_$iv2.isDebugEnabled()) {
                                Throwable throwable = t;
                                KLogger kLogger = this_$iv2;
                                boolean bl = false;
                                String string4 = Intrinsics.stringPlus((String)"Failed to complete IO in ", (Object)$i$f$catchAll);
                                kLogger.debug(throwable, string4);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (this.$process.isAlive()) {
                            KLogger this_$iv3 = ProcessRunnerKt.access$getLog$p();
                            String $i$f$catchAll = this.$streamName;
                            boolean $i$f$warn = false;
                            if (this_$iv3.isWarnEnabled()) {
                                Throwable throwable = t;
                                KLogger kLogger = this_$iv3;
                                boolean bl = false;
                                String string5 = Intrinsics.stringPlus((String)"Failed to complete IO in ", (Object)$i$f$catchAll);
                                kLogger.warn(throwable, string5);
                            }
                        }
                    }
                    finally {
                        block32: {
                            ProcessRunner t = this.this$0;
                            this_$iv = this.$outputStream;
                            boolean $i$f$catchAll = false;
                            try {
                                boolean bl = false;
                                ((OutputStream)this_$iv).close();
                            }
                            catch (Throwable t$iv) {
                                KLogger this_$iv$iv = ProcessRunnerKt.access$getLog$p();
                                boolean $i$f$trace = false;
                                if (!this_$iv$iv.isTraceEnabled()) break block32;
                                Throwable bl = t$iv;
                                KLogger $i$f$trace2 = this_$iv$iv;
                                boolean bl2 = false;
                                String $i$a$-trace-ProcessRunner$catchAll$1$iv2 = Intrinsics.stringPlus((String)"Error. ", (Object)t$iv.getMessage());
                                $i$f$trace2.trace(bl, $i$a$-trace-ProcessRunner$catchAll$1$iv2);
                            }
                        }
                    }
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void submit$lambda-1(String $name, MDC.StickyMDC $mdc, Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$mdc, (String)"$mdc");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        ThreadUtil this_$iv = ThreadUtil.INSTANCE;
        boolean $i$f$threadName = false;
        Thread thread$iv = Thread.currentThread();
        String oldName$iv = thread$iv.getName();
        thread$iv.setName($name + " @ " + oldName$iv);
        try {
            boolean bl = false;
            $mdc.syncWrapped((Function0)new Function0<Unit>((Function0<Unit>)$action, $name){
                final /* synthetic */ Function0<Unit> $action;
                final /* synthetic */ String $name;
                {
                    this.$action = $action;
                    this.$name = $name;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block2: {
                        try {
                            this.$action.invoke();
                        }
                        catch (Throwable t) {
                            void this_$iv;
                            KLogger kLogger = ProcessRunnerKt.access$getLog$p();
                            String string2 = this.$name;
                            boolean $i$f$warn = false;
                            if (!this_$iv.isWarnEnabled()) break block2;
                            Throwable throwable = t;
                            void var6_6 = this_$iv;
                            boolean bl = false;
                            String string3 = "Failed to complete IO " + string2 + " task. " + t.getMessage();
                            var6_6.warn(throwable, string3);
                        }
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            thread$iv.setName(oldName$iv);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Llibraries/process/ProcessRunner$SleepSequence;", "", "sleepTimes", "", "", "([J)V", "idx", "", "getSleepTimes", "()[J", "next", "reset", "", "libraries-process"})
    private static final class SleepSequence {
        @NotNull
        private final long[] sleepTimes;
        private int idx;

        public SleepSequence(long ... sleepTimes) {
            Intrinsics.checkNotNullParameter((Object)sleepTimes, (String)"sleepTimes");
            this.sleepTimes = sleepTimes;
        }

        @NotNull
        public final long[] getSleepTimes() {
            return this.sleepTimes;
        }

        public final long next() {
            long l;
            if (this.idx >= this.sleepTimes.length) {
                l = ArraysKt.last((long[])this.sleepTimes);
            } else {
                SleepSequence sleepSequence = this;
                int n = sleepSequence.idx;
                sleepSequence.idx = n + 1;
                l = this.sleepTimes[n];
            }
            return l;
        }

        public final void reset() {
            this.idx = 0;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Llibraries/process/ProcessRunner$StreamAccumulator;", "Ljava/io/OutputStream;", "stream", "(Ljava/io/OutputStream;)V", "buffer", "Ljava/io/ByteArrayOutputStream;", "getBuffer", "()Ljava/io/ByteArrayOutputStream;", "getStream", "()Ljava/io/OutputStream;", "write", "", "b", "", "off", "", "len", "libraries-process"})
    private static final class StreamAccumulator
    extends OutputStream {
        @NotNull
        private final OutputStream stream;
        @NotNull
        private final ByteArrayOutputStream buffer;

        public StreamAccumulator(@NotNull OutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            this.stream = stream;
            this.buffer = new ByteArrayOutputStream();
        }

        @NotNull
        public final OutputStream getStream() {
            return this.stream;
        }

        @NotNull
        public final ByteArrayOutputStream getBuffer() {
            return this.buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.write(b);
            this.stream.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off2, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.buffer.write(b, off2, len);
            this.stream.write(b, off2, len);
        }
    }
}

