/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.json.JsonArray;
import runtime.json.JsonArrayBuilderContext;
import runtime.json.JsonArrayBuilderContextImpl;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonBuilderContextImpl;
import runtime.json.JsonDslKt;
import runtime.json.JsonObject;
import runtime.json.JsonValueBuilderContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B8\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\"\u0010\u0014\u001a\u00020\b2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\b\u0017H\u0096\u0004J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001cJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001dJ\"\u0010\u0018\u001a\u00020\b2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\b\u0017H\u0096\u0004J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lruntime/json/JsonValueBuilderContextImpl;", "Lruntime/json/JsonValueBuilderContext;", "nodeSetter", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JsonNode;", "Lkotlin/ParameterName;", "name", "node", "", "factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lkotlin/jvm/functions/Function1;Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getFactory", "()Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getNodeSetter", "()Lkotlin/jvm/functions/Function1;", "array", "worker", "Lruntime/json/JsonArrayBuilderContext;", "Lkotlin/ExtensionFunctionType;", "value", "arg", "", "", "", "Lruntime/json/JsonArray;", "Lruntime/json/JsonBuilderContext;", "Lruntime/json/JsonObject;", "platform-runtime"})
public final class JsonValueBuilderContextImpl
implements JsonValueBuilderContext {
    @NotNull
    private final Function1<JsonNode, Unit> nodeSetter;
    @NotNull
    private final JsonNodeFactory factory;
    @NotNull
    private final ObjectMapper mapper;

    public JsonValueBuilderContextImpl(@NotNull Function1<? super JsonNode, Unit> nodeSetter, @NotNull JsonNodeFactory factory, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter(nodeSetter, (String)"nodeSetter");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.nodeSetter = nodeSetter;
        this.factory = factory;
        this.mapper = mapper;
    }

    @NotNull
    public final Function1<JsonNode, Unit> getNodeSetter() {
        return this.nodeSetter;
    }

    @NotNull
    public final JsonNodeFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    public final void value(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        TextNode textNode = this.factory.textNode(arg);
        Intrinsics.checkNotNullExpressionValue((Object)textNode, (String)"factory.textNode(arg)");
        this.nodeSetter.invoke((Object)textNode);
    }

    public final void value(int arg) {
        NumericNode numericNode = this.factory.numberNode(arg);
        Intrinsics.checkNotNullExpressionValue((Object)numericNode, (String)"factory.numberNode(arg)");
        this.nodeSetter.invoke((Object)numericNode);
    }

    @Override
    public void value(@Nullable Object arg) {
        JsonNode jsonNode;
        JsonNode jsonNode2 = this.mapper.valueToTree(arg);
        if (jsonNode2 == null) {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkNotNullExpressionValue((Object)nullNode, (String)"instance");
            jsonNode = (JsonNode)nullNode;
        } else {
            jsonNode = jsonNode2;
        }
        this.nodeSetter.invoke((Object)jsonNode);
    }

    public final void value(@NotNull JsonObject arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.nodeSetter.invoke((Object)JsonDslKt.node(arg));
    }

    public final void value(@NotNull JsonArray arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.nodeSetter.invoke((Object)JsonDslKt.node(arg));
    }

    @Override
    public void value(@NotNull Function1<? super JsonBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ObjectNode objNode = this.factory.objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonBuilderContextImpl(objNode, this.factory, this.mapper));
        this.nodeSetter.invoke((Object)objNode);
    }

    @Override
    public void array(@NotNull Function1<? super JsonArrayBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ArrayNode objNode = this.factory.arrayNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonArrayBuilderContextImpl(objNode, this.factory, this.mapper));
        this.nodeSetter.invoke((Object)objNode);
    }
}

