/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import klogging.MDCUtilsKt;
import klogging.PlatformMDCKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import libraries.klogging.MDCKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.ScalarsKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.SuppressedConnectionErrors;
import runtime.logging.SuppressedError;
import runtime.system.JStack;
import runtime.utils.HostKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0019J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0014J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u001c\u0010(\u001a\u00020\u001c2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020-H\u0002JK\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00052\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020-2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001c04H\u0002\u00a2\u0006\u0002\u00105J,\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000507*\u00020!2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000507H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0016\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lruntime/logging/JsonLogEventsLayout;", "Lch/qos/logback/core/LayoutBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "app", "", "getApp", "()Ljava/lang/String;", "setApp", "(Ljava/lang/String;)V", "hostName", "getHostName", "setHostName", "mdcKeysAsFields", "", "Llibraries/klogging/MDCKey;", "getMdcKeysAsFields", "()Ljava/util/List;", "region", "getRegion", "suppressedConnectionErrors", "Lruntime/logging/SuppressedConnectionErrors;", "suppressedErrors", "Ljava/util/HashMap;", "", "Lruntime/logging/SuppressedError;", "Lkotlin/collections/HashMap;", "addSuppressedConnectionErrors", "", "addSuppressedError", "suppressedError", "customJsonFields", "jsonBuilderContext", "Lruntime/json/JsonBuilderContext;", "event", "doLayout", "isOOM", "", "isSuppressed", "maybeThreadDump", "print", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "th", "Lch/qos/logback/classic/spi/IThrowableProxy;", "printEnclosedStackTrace", "caption", "enclosingTrace", "", "Lch/qos/logback/classic/spi/StackTraceElementProxy;", "used", "Ljava/util/IdentityHashMap;", "(Ljava/lang/String;Ljava/lang/StringBuilder;Lch/qos/logback/classic/spi/IThrowableProxy;[Lch/qos/logback/classic/spi/StackTraceElementProxy;Ljava/util/IdentityHashMap;)V", "preProcessMDCMap", "", "initialMDCMap", "platform-runtime"})
public class JsonLogEventsLayout
extends LayoutBase<ILoggingEvent> {
    @Nullable
    private final String region = HostKt.getApplication_region();
    @Nullable
    private String hostName;
    @Nullable
    private String app;
    @NotNull
    private final SuppressedConnectionErrors suppressedConnectionErrors = new SuppressedConnectionErrors();
    @NotNull
    private final HashMap<String, List<SuppressedError>> suppressedErrors;
    @NotNull
    private final List<MDCKey> mdcKeysAsFields;

    public JsonLogEventsLayout() {
        boolean bl = false;
        this.suppressedErrors = new HashMap();
        this.mdcKeysAsFields = PlatformMDCKey.Companion.getFull();
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(@Nullable String string2) {
        this.hostName = string2;
    }

    @Nullable
    public final String getApp() {
        return this.app;
    }

    public final void setApp(@Nullable String string2) {
        this.app = string2;
    }

    @NotNull
    public String doLayout(@NotNull ILoggingEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        try {
            String logstashEvent2 = JsonDslKt.jsonObjectText((Function1<? super JsonBuilderContext, Unit>)((Function1)new Function1<JsonBuilderContext, Unit>(event2, this){
                final /* synthetic */ ILoggingEvent $event;
                final /* synthetic */ JsonLogEventsLayout this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull JsonBuilderContext $this$jsonObjectText) {
                    Intrinsics.checkNotNullParameter((Object)$this$jsonObjectText, (String)"$this$jsonObjectText");
                    $this$jsonObjectText.put("@version", 1);
                    $this$jsonObjectText.put("@timestamp", JsonLogEventsLayoutKt.dateFormat(this.$event.getTimeStamp()));
                    this.this$0.customJsonFields($this$jsonObjectText, this.$event);
                }
            }));
            return Intrinsics.stringPlus((String)logstashEvent2, (Object)"\n");
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stackTrace, true));
            return "FAILED TO LAYOUT A LOG EVENT\nEvent: " + event2 + "\nError: " + e + '\n' + stackTrace;
        }
    }

    public final void addSuppressedConnectionErrors(@NotNull SuppressedConnectionErrors suppressedConnectionErrors) {
        Intrinsics.checkNotNullParameter((Object)suppressedConnectionErrors, (String)"suppressedConnectionErrors");
        JsonLogEventsLayout jsonLogEventsLayout = this;
        jsonLogEventsLayout.suppressedConnectionErrors.plusAssign(suppressedConnectionErrors);
    }

    public final void addSuppressedError(@NotNull SuppressedError suppressedError) {
        block1: {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)suppressedError, (String)"suppressedError");
            String string2 = suppressedError.getLoggerName();
            if (string2 == null) break block1;
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string3;
            boolean bl4 = false;
            Object object = this.suppressedErrors.get(it);
            Boolean bl5 = bl = object == null ? null : Boolean.valueOf(object.add(suppressedError));
            if (bl == null) {
                object = this;
                boolean bl6 = false;
                boolean bl7 = false;
                JsonLogEventsLayout $this$addSuppressedError_u24lambda_u2d1_u24lambda_u2d0 = (JsonLogEventsLayout)((Object)object);
                boolean bl8 = false;
                Map map2 = $this$addSuppressedError_u24lambda_u2d1_u24lambda_u2d0.suppressedErrors;
                Object object2 = new SuppressedError[]{suppressedError};
                object2 = CollectionsKt.mutableListOf((Object[])object2);
                boolean bl9 = false;
                map2.put(it, object2);
            }
        }
    }

    protected void customJsonFields(@NotNull JsonBuilderContext jsonBuilderContext, @NotNull ILoggingEvent event2) {
        boolean bl;
        boolean bl2;
        String string2;
        Intrinsics.checkNotNullParameter((Object)jsonBuilderContext, (String)"jsonBuilderContext");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Level level = null;
        level = event2.getLevel();
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR) && this.isSuppressed(event2)) {
            level = Level.WARN;
        }
        String threadDump = this.maybeThreadDump(event2);
        JsonBuilderContext jsonBuilderContext2 = jsonBuilderContext;
        boolean bl3 = false;
        boolean bl4 = false;
        JsonBuilderContext $this$customJsonFields_u24lambda_u2d4 = jsonBuilderContext2;
        boolean bl5 = false;
        Object object = this.getHostName();
        $this$customJsonFields_u24lambda_u2d4.put("source_host", (String)(object == null ? JsonLogEventsLayoutKt.access$getComputedHostName() : object));
        object = this.getRegion();
        if (object != null) {
            string2 = object;
            bl2 = false;
            bl = false;
            String it = string2;
            boolean bl6 = false;
            $this$customJsonFields_u24lambda_u2d4.put("region", it);
        }
        JsonLogEventsLayoutKt.putLogAppVersion($this$customJsonFields_u24lambda_u2d4);
        $this$customJsonFields_u24lambda_u2d4.put("message", event2.getFormattedMessage());
        object = this.getApp();
        $this$customJsonFields_u24lambda_u2d4.put("app", (String)(object == null ? "platform" : object));
        object = event2.getThrowableProxy();
        if (object != null) {
            string2 = object;
            bl2 = false;
            bl = false;
            String proxy = string2;
            boolean bl7 = false;
            $this$customJsonFields_u24lambda_u2d4.put("exception", (Function1<? super JsonBuilderContext, Unit>)((Function1)new Function1<JsonBuilderContext, Unit>((IThrowableProxy)proxy, this){
                final /* synthetic */ IThrowableProxy $proxy;
                final /* synthetic */ JsonLogEventsLayout this$0;
                {
                    this.$proxy = $proxy;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull JsonBuilderContext $this$null) {
                    String it;
                    boolean bl;
                    boolean bl2;
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    Object object = this.$proxy.getClassName();
                    if (object != null) {
                        string2 = object;
                        bl2 = false;
                        bl = false;
                        it = string2;
                        boolean bl3 = false;
                        $this$null.put("exception_class", it);
                    }
                    object = this.$proxy.getMessage();
                    if (object != null) {
                        string2 = object;
                        bl2 = false;
                        bl = false;
                        it = string2;
                        boolean bl4 = false;
                        $this$null.put("exception_message", it);
                    }
                    object = this.this$0;
                    string2 = this.$proxy;
                    bl2 = false;
                    bl = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean it2 = false;
                    boolean bl5 = false;
                    StringBuilder $this$invoke_u24lambda_u2d2 = stringBuilder;
                    boolean bl6 = false;
                    JsonLogEventsLayout.access$print((JsonLogEventsLayout)((Object)object), $this$invoke_u24lambda_u2d2, (IThrowableProxy)string2);
                    String string3 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                    object = string3;
                    boolean bl7 = false;
                    bl2 = false;
                    Object it3 = object;
                    boolean bl8 = false;
                    $this$null.put("stacktrace", (String)it3);
                }
            }));
        }
        $this$customJsonFields_u24lambda_u2d4.put("logger_name", event2.getLoggerName());
        object = event2.getMDCPropertyMap();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.mdcPropertyMap");
        $this$customJsonFields_u24lambda_u2d4.put("mdc", this.preProcessMDCMap($this$customJsonFields_u24lambda_u2d4, (Map<String, String>)object));
        $this$customJsonFields_u24lambda_u2d4.put("level", level.toString());
        $this$customJsonFields_u24lambda_u2d4.put("thread_name", event2.getThreadName());
        if (threadDump != null) {
            $this$customJsonFields_u24lambda_u2d4.put("thread_dump", threadDump);
        }
    }

    private final boolean isSuppressed(ILoggingEvent event2) {
        Boolean bl;
        List<SuppressedError> list = this.suppressedErrors.get(event2.getLoggerName());
        if (list == null) {
            bl = null;
        } else {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SuppressedError it = (SuppressedError)element$iv;
                        boolean bl3 = false;
                        if (!it.match(event2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        return ScalarsKt.orFalse(bl) || this.suppressedConnectionErrors.match(event2) || this.isOOM(event2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String maybeThreadDump(ILoggingEvent event2) {
        String string2;
        if (this.isOOM(event2)) {
            String string3 = event2.getFormattedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event.formattedMessage");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"unable to create native thread", (boolean)false, (int)2, null)) {
                try {
                    string3 = JStack.dumpThreads$default(JStack.INSTANCE, null, 1, null);
                }
                catch (Throwable t) {
                    string3 = null;
                }
                string2 = string3;
                return string2;
            }
        }
        string2 = null;
        return string2;
    }

    private final boolean isOOM(ILoggingEvent event2) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event2.getThrowableProxy());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IThrowableProxy it = (IThrowableProxy)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"java.lang.OutOfMemoryError")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> preProcessMDCMap(JsonBuilderContext $this$preProcessMDCMap, Map<String, String> initialMDCMap) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv = this.getMdcKeysAsFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MDCKey it = (MDCKey)element$iv;
            boolean bl = false;
            MDCUtilsKt.extractFieldFromMap($this$preProcessMDCMap, initialMDCMap, it);
        }
        $this$forEach$iv = this.getMdcKeysAsFields();
        Map<String, String> map2 = initialMDCMap;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MDCKey mDCKey = (MDCKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getId();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return MapsKt.minus(map2, (Iterable)collection);
    }

    @NotNull
    protected List<MDCKey> getMdcKeysAsFields() {
        return this.mdcKeysAsFields;
    }

    private final void print(StringBuilder s, IThrowableProxy th) {
        IdentityHashMap<IThrowableProxy, Unit> used = new IdentityHashMap<IThrowableProxy, Unit>();
        boolean $i$f$emptyArray = false;
        this.printEnclosedStackTrace("", s, th, (StackTraceElementProxy[])((Object[])new StackTraceElementProxy[0]), used);
    }

    /*
     * WARNING - void declaration
     */
    private final void printEnclosedStackTrace(String caption, StringBuilder s, IThrowableProxy th, StackTraceElementProxy[] enclosingTrace, IdentityHashMap<IThrowableProxy, Unit> used) {
        Object object = used;
        boolean bl = false;
        Map map2 = object;
        int n = 0;
        if (map2.containsKey(th)) {
            object = s;
            String string2 = Intrinsics.stringPlus((String)"\tCIRCULAR: ", (Object)th.getClassName());
            boolean bl2 = false;
            StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        } else {
            boolean bl3;
            String string3;
            String string4;
            StackTraceElementProxy[] stackTraceElementProxyArray;
            object = used;
            StackTraceElementProxy[] stackTraceElementProxyArray2 = Unit.INSTANCE;
            boolean bl4 = false;
            object.put(th, stackTraceElementProxyArray2);
            stackTraceElementProxyArray2 = th.getStackTraceElementProxyArray();
            if (stackTraceElementProxyArray2 == null) {
                boolean $i$f$emptyArray = false;
                stackTraceElementProxyArray = (StackTraceElementProxy[])((Object[])new StackTraceElementProxy[0]);
            } else {
                stackTraceElementProxyArray = stackTraceElementProxyArray2;
            }
            StackTraceElementProxy[] trace2 = stackTraceElementProxyArray;
            int m2 = trace2.length - 1;
            int n2 = enclosingTrace.length - 1;
            while (m2 >= 0 && n2 >= 0 && Intrinsics.areEqual((Object)trace2[m2], (Object)enclosingTrace[n2])) {
                n = m2;
                m2 = n + -1;
                n = n2;
                n2 = n + -1;
            }
            int framesInCommon = trace2.length - 1 - m2;
            StringBuilder stringBuilder = s;
            StringBuilder stringBuilder2 = new StringBuilder().append(caption).append((Object)th.getClassName());
            String string5 = th.getMessage();
            if (string5 == null) {
                string4 = "";
            } else {
                void it;
                string3 = string5;
                bl3 = false;
                boolean bl5 = false;
                String string6 = string3;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl6 = false;
                String string7 = Intrinsics.stringPlus((String)" ", (Object)it);
                stringBuilder2 = stringBuilder3;
                String string8 = string7;
                string4 = string8 == null ? "" : string8;
            }
            string5 = stringBuilder2.append(string4).toString();
            boolean bl7 = false;
            StringBuilder stringBuilder4 = stringBuilder.append(string5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            int n3 = 0;
            if (n3 <= m2) {
                int i;
                do {
                    i = n3++;
                    StringBuilder stringBuilder5 = s;
                    string3 = Intrinsics.stringPlus((String)"\t", (Object)trace2[i].getSTEAsString());
                    bl3 = false;
                    StringBuilder stringBuilder6 = stringBuilder5.append(string3);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder6);
                } while (i != m2);
            }
            if (framesInCommon != 0) {
                StringBuilder stringBuilder7 = s;
                String string9 = "\t... " + framesInCommon + " more";
                boolean bl8 = false;
                StringBuilder stringBuilder8 = stringBuilder7.append(string9);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder8);
            }
            IThrowableProxy[] iThrowableProxyArray = th.getSuppressed();
            Intrinsics.checkNotNullExpressionValue((Object)iThrowableProxyArray, (String)"th.suppressed");
            for (IThrowableProxy se : iThrowableProxyArray) {
                Intrinsics.checkNotNullExpressionValue((Object)se, (String)"se");
                this.printEnclosedStackTrace("Suppressed: ", s, se, trace2, used);
            }
            IThrowableProxy cause = th.getCause();
            if (cause != null) {
                this.printEnclosedStackTrace("Caused by: ", s, cause, trace2, used);
            }
        }
    }

    public static final /* synthetic */ void access$print(JsonLogEventsLayout $this, StringBuilder s, IThrowableProxy th) {
        $this.print(s, th);
    }
}

