/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.ExceptionUtilRt;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;

@Named(value="Intellij Idea Maven Importer Spy")
@Singleton
public class MavenImporterSpy
extends AbstractEventSpy {
    private volatile MavenServerProgressIndicator myIndicator;
    private Set<String> downloadedArtifacts = Collections.newSetFromMap(new ConcurrentHashMap());

    public void onEvent(Object o) throws Exception {
        if (!(o instanceof RepositoryEvent)) {
            return;
        }
        RepositoryEvent event = (RepositoryEvent)o;
        if (event.getArtifact() == null) {
            return;
        }
        MavenServerProgressIndicator indicator = this.myIndicator;
        if (indicator == null) {
            return;
        }
        String dependencyId = MavenImporterSpy.toString(event.getArtifact());
        if (event.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADING) {
            indicator.startedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, dependencyId);
            this.downloadedArtifacts.add(dependencyId);
        }
        if (event.getType() == RepositoryEvent.EventType.ARTIFACT_RESOLVED && this.downloadedArtifacts.remove(dependencyId)) {
            MavenImporterSpy.processResolvedArtifact(event, indicator, dependencyId);
        }
    }

    private static void processResolvedArtifact(RepositoryEvent event, MavenServerProgressIndicator indicator, String dependencyId) throws RemoteException {
        if (event.getExceptions() != null && !event.getExceptions().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Exception e : event.getExceptions()) {
                String stackTrace = ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.jetbrains");
                builder.append(stackTrace).append("\n");
            }
            indicator.failedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, dependencyId, event.getException().getMessage(), builder.toString());
        } else {
            indicator.completedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, dependencyId);
        }
    }

    public void close() {
        this.downloadedArtifacts.clear();
    }

    private static String toString(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier() + ":" + artifact.getVersion();
    }

    public void setIndicator(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }
}

