/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.diagnostics;

import java.io.File;
import org.gradle.util.internal.GFileUtils;

public class DaemonDiagnostics {
    private final Long pid;
    private final File daemonLog;
    private static final int TAIL_SIZE = 20;

    public DaemonDiagnostics(File daemonLog, Long pid) {
        this.daemonLog = daemonLog;
        this.pid = pid;
    }

    public Long getPid() {
        return this.pid;
    }

    public File getDaemonLog() {
        return this.daemonLog;
    }

    public String toString() {
        return "{pid=" + this.pid + ", daemonLog=" + this.daemonLog + '}';
    }

    private String tailDaemonLog() {
        try {
            String tail = GFileUtils.tail((File)this.getDaemonLog(), (int)20);
            return this.formatTail(tail);
        }
        catch (GFileUtils.TailReadingException e) {
            return "Unable to read from the daemon log file: " + this.getDaemonLog().getAbsolutePath() + ", because of: " + e.getCause();
        }
    }

    private String formatTail(String tail) {
        return "----- Last  20 lines from daemon log file - " + this.getDaemonLog().getName() + " -----\n" + tail + "----- End of the daemon log -----\n";
    }

    public String describe() {
        return "Daemon pid: " + this.pid + "\n  log file: " + this.daemonLog + "\n" + this.tailDaemonLog();
    }
}

