/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.algorithm.Change;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.EqualDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.PatchFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public final class Patch<T>
implements Serializable {
    private final List<AbstractDelta<T>> deltas;

    public Patch() {
        this(10);
    }

    public Patch(int estimatedPatchSize) {
        this.deltas = new ArrayList<AbstractDelta<T>>(estimatedPatchSize);
    }

    public List<T> applyTo(List<T> target) throws PatchFailedException {
        ArrayList<T> result = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public List<T> restore(List<T> target) {
        ArrayList<T> result = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            delta.restore(result);
        }
        return result;
    }

    public void addDelta(AbstractDelta<T> delta) {
        this.deltas.add(delta);
    }

    public List<AbstractDelta<T>> getDeltas() {
        this.deltas.sort(Comparator.comparing(d -> d.getSource().getPosition()));
        return this.deltas;
    }

    public String toString() {
        return "Patch{deltas=" + this.deltas + '}';
    }

    public static <T> Patch<T> generate(List<T> original, List<T> revised, List<Change> changes) {
        return Patch.generate(original, revised, changes, false);
    }

    private static <T> Chunk<T> buildChunk(int start, int end, List<T> data) {
        return new Chunk<T>(start, new ArrayList<T>(data.subList(start, end)));
    }

    public static <T> Patch<T> generate(List<T> original, List<T> revised, List<Change> _changes, boolean includeEquals) {
        Patch<T> patch = new Patch<T>(_changes.size());
        int startOriginal = 0;
        int startRevised = 0;
        List<Change> changes = _changes;
        if (includeEquals) {
            changes = new ArrayList<Change>(_changes);
            Collections.sort(changes, Comparator.comparing(d -> d.startOriginal));
        }
        for (Change change : changes) {
            if (includeEquals && startOriginal < change.startOriginal) {
                patch.addDelta(new EqualDelta<T>(Patch.buildChunk(startOriginal, change.startOriginal, original), Patch.buildChunk(startRevised, change.startRevised, revised)));
            }
            Chunk<T> orgChunk = Patch.buildChunk(change.startOriginal, change.endOriginal, original);
            Chunk<T> revChunk = Patch.buildChunk(change.startRevised, change.endRevised, revised);
            switch (change.deltaType) {
                case DELETE: {
                    patch.addDelta(new DeleteDelta<T>(orgChunk, revChunk));
                    break;
                }
                case INSERT: {
                    patch.addDelta(new InsertDelta<T>(orgChunk, revChunk));
                    break;
                }
                case CHANGE: {
                    patch.addDelta(new ChangeDelta<T>(orgChunk, revChunk));
                }
            }
            startOriginal = change.endOriginal;
            startRevised = change.endRevised;
        }
        if (includeEquals && startOriginal < original.size()) {
            patch.addDelta(new EqualDelta<T>(Patch.buildChunk(startOriginal, original.size(), original), Patch.buildChunk(startRevised, revised.size(), revised)));
        }
        return patch;
    }
}

