/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.conpty.ConsoleProcessListChildProcessMain;
import com.sun.jna.Library;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.WinDef;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleProcessListFetcher {
    private static final Logger LOG = Logger.getLogger(ConsoleProcessListFetcher.class);
    private static final int TIMEOUT_MILLIS = 5000;
    private static final List<String> JAVA_OPTIONS_ENV_VARS = List.of("JAVA_TOOL_OPTIONS", "_JAVA_OPTIONS", "JDK_JAVA_OPTIONS");

    static int getConsoleProcessCount(long pid) throws IOException {
        int exitCode;
        ProcessBuilder builder = new ProcessBuilder(ConsoleProcessListFetcher.getPathToJavaExecutable(), "-XX:TieredStopAtLevel=1", "-XX:CICompilerCount=1", "-XX:+UseSerialGC", "-XX:-UsePerfData", "-Xms8m", "-Xmx16m", "-cp", ConsoleProcessListFetcher.buildClasspath(ConsoleProcessListChildProcessMain.class, Library.class, WinDef.DWORD.class), ConsoleProcessListChildProcessMain.class.getName(), String.valueOf(pid));
        JAVA_OPTIONS_ENV_VARS.forEach(builder.environment().keySet()::remove);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        StreamGobbler stdout = new StreamGobbler(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        try {
            process.waitFor(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (process.isAlive()) {
            LOG.info((Object)"Terminating still running child process");
            process.destroy();
        }
        stdout.awaitReadingEnds();
        try {
            exitCode = process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            throw new IOException("Still running child process");
        }
        if (exitCode != 0) {
            throw new IOException("Failed to get console process list: exit code " + exitCode + ", output: " + stdout.getText());
        }
        String processCountStr = ConsoleProcessListFetcher.getProcessCountStr(stdout.getText());
        try {
            int result = Integer.parseInt(processCountStr);
            if (result <= 1) {
                throw new IOException("Unexpected amount of console processes: " + result);
            }
            return result - 1;
        }
        catch (NumberFormatException e) {
            throw new IOException("Failed to get console process list: cannot parse int from '" + processCountStr + "', all output: " + stdout.getText().trim());
        }
    }

    @NotNull
    private static String getProcessCountStr(@NotNull String stdout) throws IOException {
        int suffixInd;
        int prefixInd = stdout.lastIndexOf("Process list count: ");
        if (prefixInd != -1 && (suffixInd = stdout.indexOf(" attached to the console", prefixInd)) != -1) {
            return stdout.substring(prefixInd + "Process list count: ".length(), suffixInd);
        }
        throw new IOException("Cannot find process count in " + stdout);
    }

    @NotNull
    private static String getPathToJavaExecutable() throws IOException {
        Path javaHome = Path.of(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe", new String[0]);
        if (!Files.isRegularFile(javaHome, new LinkOption[0])) {
            throw new IOException("No such executable " + javaHome);
        }
        return javaHome.toAbsolutePath().toString();
    }

    @NotNull
    private static String buildClasspath(Class<?> ... classes) {
        List paths = Arrays.stream(classes).map(ConsoleProcessListFetcher::getJarPathForClass).collect(Collectors.toList());
        return String.join((CharSequence)(Platform.isWindows() ? ";" : ":"), paths);
    }

    private static String getJarPathForClass(@NotNull Class<?> aClass) {
        String resourceRoot = ConsoleProcessListFetcher.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return new File(Objects.requireNonNull(resourceRoot)).getAbsolutePath();
    }

    @Nullable
    private static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? ConsoleProcessListFetcher.extractRoot(url, path) : null;
    }

    @NotNull
    private static String extractRoot(@NotNull URL resourceURL, @NotNull String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            throw new IllegalStateException("precondition failed: " + resourcePath);
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = ConsoleProcessListFetcher.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (testPath.endsWith(testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            resultPath = ConsoleProcessListFetcher.getJarPath(resourceURL.getFile());
        }
        if (resultPath == null) {
            throw new IllegalStateException("Cannot extract '" + resourcePath + "' from '" + resourceURL + "', " + protocol);
        }
        return resultPath;
    }

    @NotNull
    private static File urlToFile(@NotNull URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url + "'", e);
        }
    }

    @Nullable
    private static String getJarPath(@NotNull String urlFilePart) {
        URL fileUrl;
        String filePrefix;
        int pivot = urlFilePart.indexOf("!/");
        if (pivot < 0) {
            return null;
        }
        String fileUrlStr = urlFilePart.substring(0, pivot);
        if (!fileUrlStr.startsWith(filePrefix = "file:")) {
            return fileUrlStr;
        }
        try {
            fileUrl = new URL(fileUrlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
        File result = ConsoleProcessListFetcher.urlToFile(fileUrl);
        return result.getPath().replace('\\', '/');
    }

    private static class StreamGobbler
    implements Runnable {
        private final Reader myReader;
        private final StringBuilder myBuffer = new StringBuilder();
        private final Thread myThread;
        private boolean myIsStopped = false;

        private StreamGobbler(Reader reader) {
            this.myReader = reader;
            this.myThread = new Thread((Runnable)this, "ConsoleProcessListFetcher output reader");
            this.myThread.start();
        }

        @Override
        public void run() {
            char[] buf = new char[8192];
            try {
                int readCount;
                while (!this.myIsStopped && (readCount = this.myReader.read(buf)) >= 0) {
                    this.myBuffer.append(buf, 0, readCount);
                }
                if (this.myIsStopped) {
                    this.myBuffer.append("Failed to read output: force stopped");
                }
            }
            catch (Exception e) {
                this.myBuffer.append("Failed to read output: ").append(e.getClass().getName()).append(" raised");
            }
        }

        private void awaitReadingEnds() {
            try {
                this.myThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myIsStopped = true;
        }

        private String getText() {
            return this.myBuffer.toString();
        }
    }
}

