/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.WinSize;
import com.pty4j.windows.conpty.Kernel32Ex;
import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.pty4j.windows.conpty.WinConPtyProcess;
import com.pty4j.windows.conpty.WinEx;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class PseudoConsole {
    private final WinEx.HPCON hpc;
    private WinSize myLastWinSize;
    private boolean myClosed = false;

    private static WinEx.COORDByValue getSizeCoords(WinSize size) {
        WinEx.COORDByValue sizeCoords = new WinEx.COORDByValue();
        sizeCoords.X = (short)size.getColumns();
        sizeCoords.Y = (short)size.getRows();
        return sizeCoords;
    }

    public PseudoConsole(WinSize size, WinNT.HANDLE input, WinNT.HANDLE output) throws LastErrorExceptionEx {
        WinEx.HPCONByReference hpcByReference = new WinEx.HPCONByReference();
        if (!Kernel32Ex.INSTANCE.CreatePseudoConsole(PseudoConsole.getSizeCoords(size), input, output, new WinDef.DWORD(0L), hpcByReference).equals((Object)WinError.S_OK)) {
            throw new LastErrorExceptionEx("CreatePseudoConsole");
        }
        this.hpc = hpcByReference.getValue();
        this.myLastWinSize = size;
    }

    public WinEx.HPCON getHandle() {
        return this.hpc;
    }

    public void resize(WinSize newSize) throws IOException {
        if (!Kernel32Ex.INSTANCE.ResizePseudoConsole(this.hpc, PseudoConsole.getSizeCoords(newSize)).equals((Object)WinError.S_OK)) {
            throw new LastErrorExceptionEx("ResizePseudoConsole");
        }
        this.myLastWinSize = newSize;
    }

    @NotNull
    public WinSize getWinSize() throws IOException {
        if (this.myClosed) {
            throw new IOException(WinConPtyProcess.class.getName() + ": unable to get window size for closed PseudoConsole");
        }
        return this.myLastWinSize;
    }

    public void close() {
        if (!this.myClosed) {
            this.myClosed = true;
            Kernel32Ex.INSTANCE.ClosePseudoConsole(this.hpc);
        }
    }
}

