/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.AnsiTerminalEmulator;
import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColoredOutputTypeRegistryImpl
extends ColoredOutputTypeRegistry {
    private final Map<String, ProcessOutputType> myStdoutAttrsToKeyMap = new ConcurrentHashMap<String, ProcessOutputType>();
    private final Map<String, ProcessOutputType> myStderrAttrsToKeyMap = new ConcurrentHashMap<String, ProcessOutputType>();
    private static final TextAttributesKey[] myAnsiColorKeys = new TextAttributesKey[]{ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE};

    @NotNull
    public ProcessOutputType getOutputType(@NonNls String attribute, @NotNull Key streamType) {
        if (streamType == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(0);
        }
        ProcessOutputType streamOutputType = streamType instanceof ProcessOutputType ? (ProcessOutputType)streamType : (ProcessOutputType)ProcessOutputTypes.STDOUT;
        Map<String, ProcessOutputType> attrsToKeyMap = ProcessOutputType.isStdout((Key)streamType) ? this.myStdoutAttrsToKeyMap : this.myStderrAttrsToKeyMap;
        ProcessOutputType key = attrsToKeyMap.get(attribute);
        if (key != null) {
            ProcessOutputType processOutputType = key;
            if (processOutputType == null) {
                ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(1);
            }
            return processOutputType;
        }
        String completeAttribute = attribute;
        attribute = attribute.startsWith("\u001b[") ? attribute.substring(2) : StringUtil.trimStart((String)attribute, (String)"[");
        if ((attribute = StringUtil.trimEnd((String)attribute, (String)"m")).equals("0")) {
            ProcessOutputType processOutputType = streamOutputType;
            if (processOutputType == null) {
                ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(2);
            }
            return processOutputType;
        }
        ProcessOutputType newKey = new ProcessOutputType(completeAttribute, streamOutputType);
        ConsoleViewContentType.registerNewConsoleViewType(newKey, ColoredOutputTypeRegistryImpl.createAnsiConsoleViewContentType(attribute));
        attrsToKeyMap.put(completeAttribute, newKey);
        ProcessOutputType processOutputType = newKey;
        if (processOutputType == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(3);
        }
        return processOutputType;
    }

    @NotNull
    public ProcessOutputType getOutputType(@NotNull AnsiTerminalEmulator terminal, @NotNull Key streamType) {
        String ansiSerializedState;
        Map<String, ProcessOutputType> attrsToKeyMap;
        ProcessOutputType key;
        if (terminal == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(4);
        }
        if (streamType == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(5);
        }
        if ((key = (attrsToKeyMap = ProcessOutputType.isStdout((Key)streamType) ? this.myStdoutAttrsToKeyMap : this.myStderrAttrsToKeyMap).get(ansiSerializedState = terminal.getAnsiSerializedSGRState())) != null) {
            ProcessOutputType processOutputType = key;
            if (processOutputType == null) {
                ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(6);
            }
            return processOutputType;
        }
        ProcessOutputType streamOutputType = streamType instanceof ProcessOutputType ? (ProcessOutputType)streamType : (ProcessOutputType)ProcessOutputTypes.STDOUT;
        ProcessOutputType newKey = new ProcessOutputType(ansiSerializedState, streamOutputType);
        ConsoleViewContentType.registerNewConsoleViewType(newKey, new AnsiConsoleViewContentType(terminal));
        attrsToKeyMap.put(ansiSerializedState, newKey);
        ProcessOutputType processOutputType = newKey;
        if (processOutputType == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(7);
        }
        return processOutputType;
    }

    private static Color getAnsiColor(int value2) {
        return ColoredOutputTypeRegistryImpl.getColorByKey(ColoredOutputTypeRegistryImpl.getAnsiColorKey(value2));
    }

    private static Color getColorByKey(TextAttributesKey colorKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(colorKey).getForegroundColor();
    }

    @NotNull
    private static Color getDefaultForegroundColor() {
        Color color;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attr = scheme.getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY);
        Color color2 = color = attr != null ? attr.getForegroundColor() : null;
        if (color == null) {
            color = scheme.getDefaultForeground();
        }
        Color color3 = color;
        if (color3 == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(8);
        }
        return color3;
    }

    @NotNull
    private static Color getDefaultBackgroundColor() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
        if (color == null) {
            color = scheme.getDefaultBackground();
        }
        Color color2 = color;
        if (color2 == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(9);
        }
        return color2;
    }

    public static TextAttributesKey getAnsiColorKey(int value2) {
        if (value2 >= 16) {
            return ConsoleViewContentType.NORMAL_OUTPUT_KEY;
        }
        return myAnsiColorKeys[value2];
    }

    @NotNull
    private static ConsoleViewContentType createAnsiConsoleViewContentType(@NotNull String attribute) {
        String[] strings;
        if (attribute == null) {
            ColoredOutputTypeRegistryImpl.$$$reportNull$$$0(10);
        }
        int foregroundColor = -1;
        int backgroundColor = -1;
        boolean inverse = false;
        EffectType effectType = null;
        int fontType = -1;
        for (String string : strings = attribute.split(";")) {
            int value2;
            try {
                value2 = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (value2 == 1) {
                fontType = 1;
                continue;
            }
            if (value2 == 4) {
                effectType = EffectType.LINE_UNDERSCORE;
                continue;
            }
            if (value2 == 7) {
                inverse = true;
                continue;
            }
            if (value2 == 22) {
                fontType = 0;
                continue;
            }
            if (value2 == 24) {
                effectType = null;
                continue;
            }
            if (value2 >= 30 && value2 <= 37) {
                foregroundColor = value2 - 30;
                continue;
            }
            if (value2 == 38) continue;
            if (value2 == 39) {
                foregroundColor = -1;
                continue;
            }
            if (value2 >= 40 && value2 <= 47) {
                backgroundColor = value2 - 40;
                continue;
            }
            if (value2 == 48) continue;
            if (value2 == 49) {
                backgroundColor = -1;
                continue;
            }
            if (value2 >= 90 && value2 <= 97) {
                foregroundColor = value2 - 82;
                continue;
            }
            if (value2 < 100 || value2 > 107) continue;
            backgroundColor = value2 - 92;
        }
        return new AnsiConsoleViewContentType(attribute, backgroundColor, foregroundColor, inverse, effectType, fontType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ColoredOutputTypeRegistryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ColoredOutputTypeRegistryImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultForegroundColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOutputType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnsiConsoleViewContentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AnsiConsoleViewContentType
    extends ConsoleViewContentType {
        private final int myBackgroundColorIndex;
        private final int myForegroundColorIndex;
        @Nullable
        private final Color myEnforcedBackgroundColor;
        @Nullable
        private final Color myEnforcedForegroundColor;
        private final boolean myInverse;
        @NotNull
        private final List<EffectType> myEffectTypes;
        private final int myFontType;

        private AnsiConsoleViewContentType(@NotNull String attribute, int backgroundColorIndex, int foregroundColorIndex, @Nullable Color enforcedBackgroundColor, @Nullable Color enforcedForegroundColor, boolean inverse, @NotNull List<EffectType> effectTypes, int fontType) {
            if (attribute == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(0);
            }
            if (effectTypes == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(1);
            }
            super(attribute, new TextAttributes());
            this.myBackgroundColorIndex = backgroundColorIndex;
            this.myEnforcedBackgroundColor = enforcedBackgroundColor;
            this.myForegroundColorIndex = foregroundColorIndex;
            this.myEnforcedForegroundColor = enforcedForegroundColor;
            this.myInverse = inverse;
            this.myEffectTypes = effectTypes.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.immutableList(effectTypes);
            this.myFontType = fontType;
        }

        private AnsiConsoleViewContentType(@NotNull String attribute, int backgroundColor, int foregroundColor, boolean inverse, @Nullable EffectType effectType, int fontType) {
            if (attribute == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(2);
            }
            this(attribute, backgroundColor, foregroundColor, null, null, inverse, effectType == null ? Collections.emptyList() : Collections.singletonList(effectType), fontType);
        }

        private AnsiConsoleViewContentType(@NotNull AnsiTerminalEmulator terminalEmulator) {
            if (terminalEmulator == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(3);
            }
            this(terminalEmulator.getAnsiSerializedSGRState(), terminalEmulator.getBackgroundColorIndex(), terminalEmulator.getForegroundColorIndex(), terminalEmulator.getBackgroundColor(), terminalEmulator.getForegroundColor(), terminalEmulator.isInverse(), AnsiConsoleViewContentType.computeEffectTypes(terminalEmulator), AnsiConsoleViewContentType.computeAwtFont(terminalEmulator));
        }

        @NotNull
        private static List<EffectType> computeEffectTypes(@NotNull AnsiTerminalEmulator terminalEmulator) {
            AnsiTerminalEmulator.FrameType frameType;
            if (terminalEmulator == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(4);
            }
            ArrayList<EffectType> result = new ArrayList<EffectType>();
            AnsiTerminalEmulator.Underline underline = terminalEmulator.getUnderline();
            if (underline == AnsiTerminalEmulator.Underline.SINGLE_UNDERLINE) {
                result.add(EffectType.LINE_UNDERSCORE);
            } else if (underline == AnsiTerminalEmulator.Underline.DOUBLE_UNDERLINE) {
                result.add(EffectType.BOLD_LINE_UNDERSCORE);
            }
            if (terminalEmulator.isCrossedOut()) {
                result.add(EffectType.STRIKEOUT);
            }
            if ((frameType = terminalEmulator.getFrameType()) == AnsiTerminalEmulator.FrameType.FRAMED) {
                result.add(EffectType.BOXED);
            } else if (frameType == AnsiTerminalEmulator.FrameType.ENCIRCLED) {
                result.add(EffectType.ROUNDED_BOX);
            }
            ArrayList<EffectType> arrayList = result;
            if (arrayList == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static int computeAwtFont(@NotNull AnsiTerminalEmulator terminalEmulator) {
            if (terminalEmulator == null) {
                AnsiConsoleViewContentType.$$$reportNull$$$0(6);
            }
            int result = 0;
            if (terminalEmulator.getWeight() == AnsiTerminalEmulator.Weight.BOLD) {
                result = 1;
            }
            if (terminalEmulator.isItalic()) {
                result |= 2;
            }
            return result;
        }

        @Override
        public TextAttributes getAttributes() {
            TextAttributes attrs = new TextAttributes();
            attrs.setEffectType(null);
            if (this.myFontType != -1) {
                attrs.setFontType(this.myFontType);
            }
            Color foregroundColor = this.getForegroundColor();
            Color backgroundColor = this.getBackgroundColor();
            if (this.myInverse) {
                attrs.setForegroundColor(backgroundColor);
                attrs.setEffectColor(backgroundColor);
                attrs.setBackgroundColor(foregroundColor);
                this.myEffectTypes.forEach(it -> attrs.withAdditionalEffect((EffectType)((Object)it), backgroundColor));
            } else {
                attrs.setForegroundColor(foregroundColor);
                attrs.setEffectColor(foregroundColor);
                attrs.setBackgroundColor(backgroundColor);
                this.myEffectTypes.forEach(it -> attrs.withAdditionalEffect((EffectType)((Object)it), foregroundColor));
            }
            return attrs;
        }

        private Color getForegroundColor() {
            return this.myEnforcedForegroundColor != null ? this.myEnforcedForegroundColor : (this.myForegroundColorIndex != -1 ? ColoredOutputTypeRegistryImpl.getAnsiColor(this.myForegroundColorIndex) : ColoredOutputTypeRegistryImpl.getDefaultForegroundColor());
        }

        private Color getBackgroundColor() {
            return this.myEnforcedBackgroundColor != null ? this.myEnforcedBackgroundColor : (this.myBackgroundColorIndex != -1 ? ColoredOutputTypeRegistryImpl.getAnsiColor(this.myBackgroundColorIndex) : ColoredOutputTypeRegistryImpl.getDefaultBackgroundColor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectTypes";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminalEmulator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/ColoredOutputTypeRegistryImpl$AnsiConsoleViewContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/ColoredOutputTypeRegistryImpl$AnsiConsoleViewContentType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeEffectTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeEffectTypes";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAwtFont";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

