/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\u001f\u0010\u000e\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\u0011\u0010\u000e\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\t\u001a\u0019\u0010\u000e\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0003\"\u001f\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"defaultTargetName", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/project/Project;", "getDefaultTargetName", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "createEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "project", "getEffectiveConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "targetName", "getEffectiveTargetName", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfile;", "intellij.platform.execution"})
@JvmName(name="TargetEnvironmentConfigurations")
public final class TargetEnvironmentConfigurations {
    private static final String getDefaultTargetName(Project $this$defaultTargetName) {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = TargetEnvironmentsManager.Companion.getInstance($this$defaultTargetName).getDefaultTarget();
        return targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getDisplayName() : null;
    }

    @Nullable
    public static final String getEffectiveTargetName(@NotNull RunProfile $this$getEffectiveTargetName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getEffectiveTargetName, (String)"$this$getEffectiveTargetName");
        if (!($this$getEffectiveTargetName instanceof TargetEnvironmentAwareRunProfile)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((TargetEnvironmentAwareRunProfile)$this$getEffectiveTargetName).getDefaultTargetName(), (Object)"@@@LOCAL@@@")) {
            string = null;
        } else if (((TargetEnvironmentAwareRunProfile)$this$getEffectiveTargetName).getDefaultTargetName() != null) {
            string = ((TargetEnvironmentAwareRunProfile)$this$getEffectiveTargetName).getDefaultTargetName();
        } else {
            RunProfile runProfile = $this$getEffectiveTargetName;
            if (!(runProfile instanceof RunConfigurationBase)) {
                runProfile = null;
            }
            RunConfigurationBase runConfigurationBase = (RunConfigurationBase)runProfile;
            if (runConfigurationBase != null) {
                RunConfigurationBase runConfigurationBase2 = runConfigurationBase;
                boolean bl = false;
                boolean bl2 = false;
                RunConfigurationBase it = runConfigurationBase2;
                boolean bl3 = false;
                Project project = ((RunConfigurationBase)$this$getEffectiveTargetName).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                string = TargetEnvironmentConfigurations.getDefaultTargetName(project);
            } else {
                string = null;
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final String getEffectiveTargetName(@NotNull TargetEnvironmentAwareRunProfile $this$getEffectiveTargetName, @NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getEffectiveTargetName, (String)"$this$getEffectiveTargetName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string2 = $this$getEffectiveTargetName.getDefaultTargetName();
        if (string2 != null) {
            String string3 = string2;
            switch (string3.hashCode()) {
                case -57245355: {
                    if (!string3.equals("@@@LOCAL@@@")) break;
                    return null;
                }
            }
        }
        if ((string = $this$getEffectiveTargetName.getDefaultTargetName()) != null) {
            return string;
        }
        string = TargetEnvironmentConfigurations.getDefaultTargetName(project);
        return string;
    }

    @Nullable
    public static final TargetEnvironmentConfiguration getEffectiveConfiguration(@NotNull RunProfile runProfile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(runProfile instanceof TargetEnvironmentAwareRunProfile)) {
            return null;
        }
        String targetName = ((TargetEnvironmentAwareRunProfile)runProfile).getDefaultTargetName();
        return TargetEnvironmentConfigurations.getEffectiveConfiguration(targetName, project);
    }

    @Nullable
    public static final TargetEnvironmentConfiguration getEffectiveConfiguration(@Nullable String targetName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Intrinsics.areEqual((Object)targetName, (Object)"@@@LOCAL@@@") ? null : (targetName != null ? TargetEnvironmentsManager.Companion.getInstance(project).getTargets().findByName(targetName) : TargetEnvironmentsManager.Companion.getInstance(project).getDefaultTarget());
    }

    @Nullable
    public static final String getEffectiveTargetName(@Nullable String targetName, @NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)targetName, (Object)"@@@LOCAL@@@")) {
            string = null;
        } else if (targetName != null) {
            string = targetName;
        } else {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = TargetEnvironmentsManager.Companion.getInstance(project).getDefaultTarget();
            string = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getDisplayName() : null;
        }
        return string;
    }

    @NotNull
    public static final TargetEnvironmentRequest createEnvironmentRequest(@NotNull RunProfile runProfile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = TargetEnvironmentConfigurations.getEffectiveConfiguration(runProfile, project);
        if (object == null || (object = ((TargetEnvironmentConfiguration)object).createEnvironmentRequest(project)) == null) {
            object = new LocalTargetEnvironmentRequest();
        }
        return object;
    }
}

