/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.NlsActions;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;

public interface OccurenceNavigator {
    public static final OccurenceNavigator EMPTY = new OccurenceNavigator(){

        @Override
        public boolean hasNextOccurence() {
            return false;
        }

        @Override
        public boolean hasPreviousOccurence() {
            return false;
        }

        @Override
        public OccurenceInfo goNextOccurence() {
            return null;
        }

        @Override
        public OccurenceInfo goPreviousOccurence() {
            return null;
        }

        @Override
        @NotNull
        public String getNextOccurenceActionName() {
            return "";
        }

        @Override
        @NotNull
        public String getPreviousOccurenceActionName() {
            return "";
        }
    };

    public boolean hasNextOccurence();

    public boolean hasPreviousOccurence();

    public OccurenceInfo goNextOccurence();

    public OccurenceInfo goPreviousOccurence();

    @NlsActions.ActionText
    @NotNull
    public String getNextOccurenceActionName();

    @NlsActions.ActionText
    @NotNull
    public String getPreviousOccurenceActionName();

    public static class OccurenceInfo {
        private final Navigatable myNavigateable;
        private final int myOccurenceNumber;
        private final int myOccurencesCount;

        public OccurenceInfo(Navigatable navigateable, int occurenceNumber, int occurencesCount) {
            this.myNavigateable = navigateable;
            this.myOccurenceNumber = occurenceNumber;
            this.myOccurencesCount = occurencesCount;
        }

        private OccurenceInfo(int occurenceNumber, int occurencesCount) {
            this(null, occurenceNumber, occurencesCount);
        }

        public static OccurenceInfo position(int occurenceNumber, int occurencesCount) {
            return new OccurenceInfo(occurenceNumber, occurencesCount);
        }

        public Navigatable getNavigateable() {
            return this.myNavigateable;
        }

        public int getOccurenceNumber() {
            return this.myOccurenceNumber;
        }

        public int getOccurencesCount() {
            return this.myOccurencesCount;
        }
    }
}

