/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListSelection<T> {
    @NotNull
    private final List<T> myList;
    private final int mySelectedIndex;

    private ListSelection(@NotNull List<T> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(0);
        }
        this.myList = list;
        this.mySelectedIndex = selectedIndex >= 0 && selectedIndex < list.size() ? selectedIndex : 0;
    }

    @NotNull
    public static <V> ListSelection<V> createAt(@NotNull List<V> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(1);
        }
        return new ListSelection<V>(list, selectedIndex);
    }

    @NotNull
    public static <V> ListSelection<V> create(@NotNull List<V> list, @Nullable V selected) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(2);
        }
        return ListSelection.createAt(list, list.indexOf(selected));
    }

    @NotNull
    public static <V> ListSelection<V> create(V @NotNull [] array, V selected) {
        if (array == null) {
            ListSelection.$$$reportNull$$$0(3);
        }
        return ListSelection.create(Arrays.asList(array), selected);
    }

    @NotNull
    public static <V> ListSelection<V> createSingleton(@NotNull V element) {
        if (element == null) {
            ListSelection.$$$reportNull$$$0(4);
        }
        return ListSelection.createAt(Collections.singletonList(element), 0);
    }

    @NotNull
    public static <V> ListSelection<V> empty() {
        return new ListSelection(Collections.emptyList(), -1);
    }

    @NotNull
    public List<T> getList() {
        List<T> list = this.myList;
        if (list == null) {
            ListSelection.$$$reportNull$$$0(5);
        }
        return list;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @NotNull
    public <V> ListSelection<V> map(@NotNull NullableFunction<? super T, ? extends V> convertor) {
        if (convertor == null) {
            ListSelection.$$$reportNull$$$0(6);
        }
        int newSelectionIndex = -1;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            Object out;
            if (i2 == this.mySelectedIndex) {
                newSelectionIndex = result.size();
            }
            if ((out = convertor.fun(this.myList.get(i2))) == null) continue;
            result.add(out);
        }
        return new ListSelection(result, newSelectionIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSingleton";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

