/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance(EmptyEditorHighlighter.class);
    private TextAttributes myCachedAttributes;
    private final TextAttributesKey myKey;
    private int myTextLength;
    private HighlighterClient myEditor;

    public EmptyEditorHighlighter() {
        this(null, HighlighterColors.TEXT);
    }

    public EmptyEditorHighlighter(@Nullable EditorColorsScheme scheme, @NotNull TextAttributesKey key) {
        if (key == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(0);
        }
        this.myTextLength = 0;
        this.myKey = key;
        this.myCachedAttributes = scheme != null ? scheme.getAttributes(key) : null;
    }

    public EmptyEditorHighlighter(@Nullable TextAttributes attributes) {
        this.myTextLength = 0;
        this.myCachedAttributes = attributes;
        this.myKey = HighlighterColors.TEXT;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public void setAttributes(TextAttributes attributes) {
        this.myCachedAttributes = attributes;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(1);
        }
        this.myTextLength = text2.length();
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.setAttributes(scheme.getAttributes(this.myKey));
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(4);
        }
        this.myTextLength += e.getNewLength() - e.getOldLength();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        return new HighlighterIterator(){
            private final TextAttributesKey[] myKeys;
            private int index;
            {
                this.myKeys = new TextAttributesKey[]{EmptyEditorHighlighter.this.myKey};
                this.index = 0;
            }

            @Override
            public TextAttributes getTextAttributes() {
                return EmptyEditorHighlighter.this.myCachedAttributes;
            }

            @Override
            public TextAttributesKey @NotNull [] getTextAttributesKeys() {
                if (this.myKeys == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.myKeys;
            }

            @Override
            public int getStart() {
                return 0;
            }

            @Override
            public int getEnd() {
                return EmptyEditorHighlighter.this.myTextLength;
            }

            @Override
            public void advance() {
                ++this.index;
            }

            @Override
            public void retreat() {
                --this.index;
            }

            @Override
            public boolean atEnd() {
                return this.index != 0;
            }

            @Override
            @NotNull
            public Document getDocument() {
                Document document = EmptyEditorHighlighter.this.myEditor.getDocument();
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                return document;
            }

            @Override
            public IElementType getTokenType() {
                return IElementType.find((short)1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/editor/ex/util/EmptyEditorHighlighter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextAttributesKeys";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDocument";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/ex/util/EmptyEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setColorScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

