/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconRenderer
implements GutterMark,
PossiblyDumbAware,
SimpleAccessible {
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return null;
    }

    @Nullable
    public AnAction getClickAction() {
        return null;
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return null;
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return null;
    }

    public boolean isNavigateAction() {
        return false;
    }

    @NotNull
    public Alignment getAlignment() {
        Alignment alignment = Alignment.CENTER;
        if (alignment == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        return alignment;
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        return null;
    }

    @NotNull
    public String getAccessibleName() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "icon: ");
    }

    @NonNls
    @NotNull
    public final String getFeatureId() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "");
    }

    @NotNull
    private static String getAccessibleName(@Nullable Icon icon2, @NotNull String prefix) {
        String path2;
        if (prefix == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        if (icon2 instanceof RetrievableIcon) {
            return GutterIconRenderer.getAccessibleName(((RetrievableIcon)icon2).retrieveIcon(), prefix);
        }
        if (icon2 instanceof CompositeIcon) {
            StringBuilder b = new StringBuilder("composite icon: ");
            int count = ((CompositeIcon)icon2).getIconCount();
            for (int i2 = 0; i2 < count; ++i2) {
                b.append(GutterIconRenderer.getAccessibleName(((CompositeIcon)icon2).getIcon(i2), ""));
                if (i2 >= count - 1) continue;
                b.append(" & ");
            }
            String string = b.toString();
            if (string == null) {
                GutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (icon2 instanceof IconLoader.CachedImageIcon && (path2 = ((IconLoader.CachedImageIcon)icon2).getOriginalPath()) != null) {
            String[] split2 = path2.split(Pattern.quote("/") + "|" + Pattern.quote("\\"));
            String name = split2[split2.length - 1];
            String string = prefix + name.split(Pattern.quote("."))[0];
            if (string == null) {
                GutterIconRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = prefix + "unknown";
        if (string == null) {
            GutterIconRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getAccessibleTooltipText() {
        return this.getTooltipText();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Alignment {
        LINE_NUMBERS(0),
        LEFT(1),
        RIGHT(3),
        CENTER(2);

        private final int myWeight;

        private Alignment(int weight) {
            this.myWeight = weight;
        }

        public int getWeight() {
            return this.myWeight;
        }
    }
}

