/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEditor {
    private static final Logger LOG = Logger.getInstance(PathEditor.class);
    public static final Color INVALID_COLOR = new JBColor(new Color(210, 0, 0), (Color)JBColor.RED);
    protected JPanel myPanel;
    private JBList<VirtualFile> myList;
    private final DefaultListModel<VirtualFile> myModel;
    private final Set<VirtualFile> myAllFiles = new HashSet<VirtualFile>();
    private boolean myModified = false;
    protected boolean myEnabled = false;
    private final FileChooserDescriptor myDescriptor;
    private VirtualFile myAddBaseDir;

    public PathEditor(FileChooserDescriptor descriptor) {
        this.myDescriptor = descriptor;
        this.myModel = this.createListModel();
    }

    public void setAddBaseDir(@Nullable VirtualFile addBaseDir) {
        this.myAddBaseDir = addBaseDir;
    }

    protected void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    protected void setModified(boolean modified) {
        this.myModified = modified;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public VirtualFile[] getRoots() {
        int count = this.getRowCount();
        if (count == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] roots = new VirtualFile[count];
        for (int i2 = 0; i2 < count; ++i2) {
            roots[i2] = this.getValueAt(i2);
        }
        return roots;
    }

    public void resetPath(@NotNull List<? extends VirtualFile> paths) {
        if (paths == null) {
            PathEditor.$$$reportNull$$$0(0);
        }
        this.keepSelectionState();
        this.clearList();
        this.setEnabled(true);
        for (VirtualFile virtualFile2 : paths) {
            this.addElement(virtualFile2);
        }
        this.setModified(false);
    }

    public JComponent createComponent() {
        this.myList = new JBList<VirtualFile>((ListModel<VirtualFile>)this.getListModel());
        this.myList.setCellRenderer(this.createListCellRenderer(this.myList));
        TreeUIHelper.getInstance().installListSpeedSearch(this.myList, VirtualFile::getPresentableUrl);
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions().setAddActionUpdater(e -> this.myEnabled).setRemoveActionUpdater(e -> this.isRemoveActionEnabled(this.getSelectedRoots())).setAddAction(button -> {
            VirtualFile[] added = this.doAddItems();
            if (added.length > 0) {
                this.setModified(true);
            }
            this.requestDefaultFocus();
            this.setSelectedRoots(added);
        }).setRemoveAction(button -> {
            int[] indices = this.myList.getSelectedIndices();
            this.doRemoveItems(indices, this.myList);
        });
        this.addToolbarButtons(toolbarDecorator);
        this.myPanel = toolbarDecorator.createPanel();
        this.myPanel.setBorder(null);
        return this.myPanel;
    }

    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
    }

    protected boolean isRemoveActionEnabled(VirtualFile[] files) {
        return files.length > 0 && this.myEnabled;
    }

    protected VirtualFile[] doAddItems() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myPanel));
        VirtualFile[] files = FileChooser.chooseFiles(this.myDescriptor, this.myPanel, project, this.myAddBaseDir);
        if (files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        files = this.adjustAddedFileSet(this.myPanel, files);
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(files.length);
        for (VirtualFile vFile : files) {
            if (!this.addElement(vFile)) continue;
            added.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(added);
    }

    protected void doRemoveItems(int[] indices, JList<VirtualFile> list) {
        this.itemsRemoved(ListUtil.removeIndices(list, indices));
    }

    protected DefaultListModel<VirtualFile> createListModel() {
        return new DefaultListModel<VirtualFile>();
    }

    protected ListCellRenderer<VirtualFile> createListCellRenderer(JBList<VirtualFile> list) {
        return new PathCellRenderer();
    }

    protected void itemsRemoved(List<VirtualFile> removedItems) {
        this.myAllFiles.removeAll(removedItems);
        if (removedItems.size() > 0) {
            this.setModified(true);
        }
        this.requestDefaultFocus();
    }

    protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
        return files;
    }

    protected boolean isUrlInserted() {
        if (this.getRowCount() > 0) {
            return this.getListModel().lastElement().getFileSystem() instanceof HttpFileSystem;
        }
        return false;
    }

    protected void requestDefaultFocus() {
        if (this.myList != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }
    }

    public void addPaths(VirtualFile ... paths) {
        boolean added = false;
        this.keepSelectionState();
        for (VirtualFile path2 : paths) {
            if (!this.addElement(path2)) continue;
            added = true;
        }
        if (added) {
            this.setModified(true);
        }
    }

    public void removePaths(VirtualFile ... paths) {
        Set pathsSet = ContainerUtil.set((Object[])paths);
        int size = this.getRowCount();
        IntArrayList indicesToRemove = new IntArrayList(paths.length);
        for (int idx = 0; idx < size; ++idx) {
            VirtualFile path2 = this.getValueAt(idx);
            if (!pathsSet.contains(path2)) continue;
            indicesToRemove.add(idx);
        }
        this.itemsRemoved(ListUtil.removeIndices(this.myList, indicesToRemove.toArray()));
    }

    protected boolean addElement(VirtualFile item) {
        if (item == null) {
            return false;
        }
        if (this.myAllFiles.contains(item)) {
            return false;
        }
        if (this.isUrlInserted()) {
            this.getListModel().insertElementAt(item, this.getRowCount() - 1);
        } else {
            this.getListModel().addElement(item);
        }
        this.myAllFiles.add(item);
        return true;
    }

    protected DefaultListModel<VirtualFile> getListModel() {
        return this.myModel;
    }

    protected void setSelectedRoots(VirtualFile[] roots) {
        HashSet set = ContainerUtil.newHashSet((Object[])roots);
        this.myList.getSelectionModel().clearSelection();
        int rowCount = this.getRowCount();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            VirtualFile currObject = this.getValueAt(i2);
            LOG.assertTrue(currObject != null);
            if (!set.contains(currObject)) continue;
            this.myList.getSelectionModel().addSelectionInterval(i2, i2);
        }
    }

    private void keepSelectionState() {
        VirtualFile[] selectedItems = this.getSelectedRoots();
        SwingUtilities.invokeLater(() -> this.setSelectedRoots(selectedItems));
    }

    protected VirtualFile[] getSelectedRoots() {
        return VfsUtilCore.toVirtualFileArray(this.myList.getSelectedValuesList());
    }

    protected int getRowCount() {
        return this.getListModel().getSize();
    }

    protected VirtualFile getValueAt(int row) {
        return this.getListModel().get(row);
    }

    public void clearList() {
        this.getListModel().clear();
        this.myAllFiles.clear();
        this.setModified(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/projectRoots/ui/PathEditor", "resetPath"));
    }

    protected static class PathCellRenderer
    extends ColoredListCellRenderer<VirtualFile> {
        protected PathCellRenderer() {
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList<? extends VirtualFile> list, VirtualFile file, int index, boolean selected, boolean focused) {
            if (list == null) {
                PathCellRenderer.$$$reportNull$$$0(0);
            }
            LOG.assertTrue(file != null);
            String text2 = file.getPresentableUrl();
            this.append(text2, file.isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
            this.setIcon(this.getItemIcon(file));
        }

        protected Icon getItemIcon(@NotNull VirtualFile file) {
            if (file == null) {
                PathCellRenderer.$$$reportNull$$$0(1);
            }
            if (!file.isValid()) {
                return AllIcons.Nodes.PpInvalid;
            }
            if (file.getFileSystem() instanceof HttpFileSystem) {
                return PlatformIcons.WEB_ICON;
            }
            if (file.getFileSystem() instanceof ArchiveFileSystem) {
                return PlatformIcons.JAR_ICON;
            }
            return PlatformIcons.FILE_ICON;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/projectRoots/ui/PathEditor$PathCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getItemIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

