/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001aL\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0014\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u0002H\u00030\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00030\fH\u0082\b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"canShowMacSheetPanel", "", "showMessage", "T", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "mac", "Lkotlin/Function1;", "Ljava/awt/Window;", "other", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.core"})
public final class MessageDialogBuilderKt {
    private static final <T> T showMessage(Project project, Component parentComponent, Function1<? super Window, ? extends T> mac, Function0<? extends T> other) {
        block3: {
            int $i$f$showMessage = 0;
            if (MessageDialogBuilderKt.canShowMacSheetPanel() || SystemInfoRt.isMac && MessagesService.Companion.getInstance().isAlertEnabled()) {
                try {
                    Window window = parentComponent == null ? WindowManager.getInstance().suggestParentWindow(project) : ComponentUtil.getWindow((Component)parentComponent);
                    return (T)mac.invoke((Object)window);
                }
                catch (Exception e) {
                    if (!(Intrinsics.areEqual((Object)e.getMessage(), (Object)"Cannot find any window") ^ true)) break block3;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MessagesService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error((Throwable)e);
                }
            }
        }
        return (T)other.invoke();
    }

    public static final boolean canShowMacSheetPanel() {
        if (!SystemInfoRt.isMac || MessagesService.Companion.getInstance().isAlertEnabled()) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        return app != null && !app.isUnitTestMode() && !app.isHeadlessEnvironment() && Registry.is((String)"ide.mac.message.dialogs.as.sheets", (boolean)true);
    }

    public static final /* synthetic */ Object access$showMessage(Project project, Component parentComponent, Function1 mac, Function0 other) {
        return MessageDialogBuilderKt.showMessage(project, parentComponent, mac, other);
    }
}

