/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ToolWindow
extends BusyObject {
    public static final Key<Boolean> SHOW_CONTENT_ICON = new Key("ContentIcon");

    @NonNls
    @NotNull
    public String getId();

    public boolean isActive();

    public void activate(@Nullable Runnable var1);

    public void activate(@Nullable Runnable var1, boolean var2);

    public void activate(@Nullable Runnable var1, boolean var2, boolean var3);

    public boolean isVisible();

    public void show(@Nullable Runnable var1);

    default public void show() {
        this.show(null);
    }

    public void hide(@Nullable Runnable var1);

    default public void hide() {
        this.hide(null);
    }

    @NotNull
    public ToolWindowAnchor getAnchor();

    public boolean isVisibleOnLargeStripe();

    public void setVisibleOnLargeStripe(boolean var1);

    public void setOrderOnLargeStripe(int var1);

    public int getOrderOnLargeStripe();

    @NotNull
    public ToolWindowAnchor getLargeStripeAnchor();

    public void setLargeStripeAnchor(@NotNull ToolWindowAnchor var1);

    public void setAnchor(@NotNull ToolWindowAnchor var1, @Nullable Runnable var2);

    public boolean isSplitMode();

    public void setSplitMode(boolean var1, @Nullable Runnable var2);

    public boolean isAutoHide();

    public void setAutoHide(boolean var1);

    @NotNull
    public ToolWindowType getType();

    public void setType(@NotNull ToolWindowType var1, @Nullable Runnable var2);

    @Nullable
    public Icon getIcon();

    public void setIcon(@NotNull Icon var1);

    @NlsContexts.TabTitle
    @Nullable
    public String getTitle();

    public void setTitle(@NlsContexts.TabTitle String var1);

    @NlsContexts.TabTitle
    @NotNull
    public String getStripeTitle();

    public void setStripeTitle(@NlsContexts.TabTitle @NotNull String var1);

    public boolean isAvailable();

    public void setAvailable(boolean var1, @Nullable Runnable var2);

    public void setAvailable(boolean var1);

    public void setContentUiType(@NotNull ToolWindowContentUiType var1, @Nullable Runnable var2);

    public void setDefaultContentUiType(@NotNull ToolWindowContentUiType var1);

    @NotNull
    public ToolWindowContentUiType getContentUiType();

    public void installWatcher(ContentManager var1);

    @NotNull
    public JComponent getComponent();

    @NotNull
    public ContentManager getContentManager();

    @Nullable
    public ContentManager getContentManagerIfCreated();

    public void addContentManagerListener(@NotNull ContentManagerListener var1);

    public void setDefaultState(@Nullable ToolWindowAnchor var1, @Nullable ToolWindowType var2, @Nullable Rectangle var3);

    public void setToHideOnEmptyContent(boolean var1);

    public void setShowStripeButton(boolean var1);

    public boolean isShowStripeButton();

    public boolean isDisposed();

    public void showContentPopup(@NotNull InputEvent var1);

    @NotNull
    public Disposable getDisposable();

    default public void setHelpId(@NotNull @NonNls String helpId) {
        if (helpId == null) {
            ToolWindow.$$$reportNull$$$0(0);
        }
    }

    default public String getHelpId() {
        return null;
    }

    public void remove();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    default public ActionCallback getActivation() {
        return ActionCallback.DONE;
    }

    public void setTitleActions(@NotNull List<? extends AnAction> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/openapi/wm/ToolWindow", "setHelpId"));
    }
}

