/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.DocCommentSettings;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface LanguageCodeStyleProvider
extends CustomCodeStyleSettingsFactory {
    @Nullable
    public static LanguageCodeStyleProvider forLanguage(Language language) {
        for (LanguageCodeStyleProvider languageCodeStyleProvider : CodeStyleSettingsService.getInstance().getLanguageCodeStyleProviders()) {
            if (!((Object)((Object)languageCodeStyleProvider.getLanguage())).equals((Object)language)) continue;
            return languageCodeStyleProvider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleProvider.$$$reportNull$$$0(0);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleProvider curr = LanguageCodeStyleProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    @NotNull
    public Language getLanguage();

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings();

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings var1);

    public Set<String> getSupportedFields();

    @ApiStatus.Experimental
    default public boolean usesCommonKeepLineBreaks() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/codeStyle/LanguageCodeStyleProvider", "findUsingBaseLanguage"));
    }
}

