/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonActionsPanel
extends JPanel {
    private final ActionToolbarPosition myPosition;
    private final ActionToolbar myToolbar;
    private final Map<Buttons, AnActionButton> myButtons;
    private final AnActionButton[] myActions;
    private EnumMap<Buttons, ShortcutSet> myCustomShortcuts;

    CommonActionsPanel(@NotNull ListenerFactory factory, @Nullable JComponent contextComponent, ActionToolbarPosition position, AnActionButton @Nullable [] additionalActions, @Nullable Comparator<? super AnActionButton> buttonComparator, @NlsContexts.Button String addName, @NlsContexts.Button String removeName, @NlsContexts.Button String moveUpName, @NlsContexts.Button String moveDownName, @NlsContexts.Button String editName, Icon addIcon, Buttons ... buttons) {
        int i2;
        if (factory == null) {
            CommonActionsPanel.$$$reportNull$$$0(0);
        }
        if (buttons == null) {
            CommonActionsPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myButtons = new HashMap<Buttons, AnActionButton>();
        this.myPosition = position;
        Listener listener = factory.createListener(this);
        AnActionButton[] actions = new AnActionButton[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i2 = 0; i2 < buttons.length; ++i2) {
            AnActionButton b;
            AnActionButton[] button = buttons[i2];
            String name = null;
            switch (2.$SwitchMap$com$intellij$ui$CommonActionsPanel$Buttons[button.ordinal()]) {
                case 1: {
                    name = addName;
                    break;
                }
                case 2: {
                    name = editName;
                    break;
                }
                case 3: {
                    name = removeName;
                    break;
                }
                case 4: {
                    name = moveUpName;
                    break;
                }
                case 5: {
                    name = moveDownName;
                }
            }
            actions[i2] = b = button.createButton(listener, name, button == Buttons.ADD && addIcon != null ? addIcon : button.getIcon());
            this.myButtons.put((Buttons)button, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i2 = buttons.length;
            for (AnActionButton button : additionalActions) {
                actions[i2++] = button;
            }
        }
        this.myActions = actions;
        for (AnActionButton action : actions) {
            action.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        ArrayList toolbarActions = ContainerUtil.newArrayList((Object[])this.myActions);
        for (int i3 = 0; i3 < toolbarActions.size(); ++i3) {
            if (!(toolbarActions.get(i3) instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions.set(i3, ((AnActionButton.CheckedAnActionButton)toolbarActions.get(i3)).getDelegate());
        }
        ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = actionManager.createActionToolbar("ToolbarDecorator", new DefaultActionGroup(toolbarActions.toArray(AnAction.EMPTY_ARRAY)), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP);
        this.myToolbar.setTargetComponent(contextComponent);
        this.myToolbar.getComponent().setBorder(null);
        this.add((Component)this.myToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            CommonActionsPanel.$$$reportNull$$$0(2);
        }
        return actionToolbar;
    }

    public void setToolbarLabel(JComponent label, ActionToolbarPosition position) {
        this.removeAll();
        this.add((Component)label, ToolbarDecorator.getPlacement(position));
        if (position == ActionToolbarPosition.LEFT) {
            this.add((Component)this.myToolbar.getComponent(), "East");
        } else if (position == ActionToolbarPosition.RIGHT) {
            this.add((Component)this.myToolbar.getComponent(), "West");
        } else {
            this.add((Component)this.myToolbar.getComponent(), "Center");
        }
    }

    public AnActionButton getAnActionButton(Buttons button) {
        return this.myButtons.get((Object)button);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            ShortcutSet customShortCut;
            ShortcutSet shortcut = button.getShortcut();
            if (shortcut == null) continue;
            if (button instanceof MyActionButton && this.myCustomShortcuts != null && (customShortCut = this.myCustomShortcuts.get((Object)((MyActionButton)button).myButton)) != null) {
                shortcut = customShortCut;
            }
            if (button instanceof AddButton && UIUtil.isDialogRootPane((JRootPane)pane)) {
                button.registerCustomShortcutSet(shortcut, pane);
            } else {
                button.registerCustomShortcutSet(shortcut, button.getContextComponent());
            }
            if (!(button instanceof RemoveButton)) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            if (!(button instanceof AddButton) || !UIUtil.isDialogRootPane((JRootPane)pane)) continue;
            button.unregisterCustomShortcutSet(pane);
        }
        super.removeNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction(IdeBundle.messagePointer("action.Anonymous.text.delete.hook", new Object[0])){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                removeButton.actionPerformed(e);
            }

            @Override
            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                JComponent contextComponent;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((contextComponent = removeButton.getContextComponent()) instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("DELETE", "BACK_SPACE"), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button, boolean enabled) {
        AnActionButton b = this.myButtons.get((Object)button);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void setCustomShortcuts(@NotNull Buttons button, ShortcutSet ... shortcutSets) {
        if (button == null) {
            CommonActionsPanel.$$$reportNull$$$0(3);
        }
        if (shortcutSets != null) {
            if (this.myCustomShortcuts == null) {
                this.myCustomShortcuts = new EnumMap(Buttons.class);
            }
            this.myCustomShortcuts.put(button, new CompositeShortcutSet(shortcutSets));
        } else if (this.myCustomShortcuts != null) {
            this.myCustomShortcuts.remove((Object)button);
            if (this.myCustomShortcuts.isEmpty()) {
                this.myCustomShortcuts = null;
            }
        }
    }

    @NotNull
    public ActionToolbarPosition getPosition() {
        ActionToolbarPosition actionToolbarPosition = this.myPosition;
        if (actionToolbarPosition == null) {
            CommonActionsPanel.$$$reportNull$$$0(4);
        }
        return actionToolbarPosition;
    }

    @NotNull
    public static ShortcutSet getCommonShortcut(@NotNull Buttons button) {
        if (button == null) {
            CommonActionsPanel.$$$reportNull$$$0(5);
        }
        switch (button) {
            case ADD: {
                ShortcutSet shortcutSet = CommonShortcuts.getNewForDialogs();
                if (shortcutSet == null) {
                    CommonActionsPanel.$$$reportNull$$$0(6);
                }
                return shortcutSet;
            }
            case EDIT: {
                CustomShortcutSet customShortcutSet = CustomShortcutSet.fromString("ENTER");
                if (customShortcutSet == null) {
                    CommonActionsPanel.$$$reportNull$$$0(7);
                }
                return customShortcutSet;
            }
            case REMOVE: {
                CustomShortcutSet customShortcutSet = CustomShortcutSet.fromString(SystemInfo.isMac ? "meta BACK_SPACE" : "alt DELETE");
                if (customShortcutSet == null) {
                    CommonActionsPanel.$$$reportNull$$$0(8);
                }
                return customShortcutSet;
            }
            case UP: {
                ShortcutSet shortcutSet = CommonShortcuts.MOVE_UP;
                if (shortcutSet == null) {
                    CommonActionsPanel.$$$reportNull$$$0(9);
                }
                return shortcutSet;
            }
            case DOWN: {
                ShortcutSet shortcutSet = CommonShortcuts.MOVE_DOWN;
                if (shortcutSet == null) {
                    CommonActionsPanel.$$$reportNull$$$0(10);
                }
                return shortcutSet;
            }
        }
        throw new IllegalStateException("Unexpected value: " + button);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCustomShortcuts";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface ListenerFactory {
        @NotNull
        public Listener createListener(@NotNull CommonActionsPanel var1);
    }

    static class DownButton
    extends MyActionButton {
        DownButton(Listener listener, @NlsContexts.Button String name, Icon icon2) {
            super(Buttons.DOWN, listener, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && max < size - 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DownButton.$$$reportNull$$$0(0);
            }
            this.myListener.doDown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$DownButton", "actionPerformed"));
        }
    }

    static class UpButton
    extends MyActionButton {
        UpButton(Listener listener, @NlsContexts.Button String name, Icon icon2) {
            super(Buttons.UP, listener, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min >= 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpButton.$$$reportNull$$$0(0);
            }
            this.myListener.doUp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$UpButton", "actionPerformed"));
        }
    }

    static class EditButton
    extends MyActionButton {
        EditButton(Listener listener, @NlsContexts.Button String name, Icon icon2) {
            super(Buttons.EDIT, listener, name, icon2);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            JComponent c;
            if (e == null) {
                EditButton.$$$reportNull$$$0(0);
            }
            if ((c = this.getContextComponent()) == null || !c.isShowing() || !c.isEnabled()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof KeyEvent && c instanceof JTable && ((JTable)c).isEditing() && !(inputEvent.getComponent() instanceof ActionButtonComponent)) {
                e.getPresentation().setEnabled(false);
                return;
            }
            super.updateButton(e);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min == max && min >= 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditButton.$$$reportNull$$$0(1);
            }
            this.myListener.doEdit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/CommonActionsPanel$EditButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RemoveButton
    extends MyActionButton {
        RemoveButton(Listener listener, @NlsContexts.Button String name, Icon icon2) {
            super(Buttons.REMOVE, listener, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveButton.$$$reportNull$$$0(0);
            }
            this.myListener.doRemove();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$RemoveButton", "actionPerformed"));
        }
    }

    static class AddButton
    extends MyActionButton {
        AddButton(Listener listener, @NlsContexts.Button String name, Icon icon2) {
            super(Buttons.ADD, listener, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return true;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddButton.$$$reportNull$$$0(0);
            }
            this.myListener.doAdd();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$AddButton", "actionPerformed"));
        }
    }

    static abstract class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        protected final Listener myListener;

        MyActionButton(@NotNull Buttons button, @NotNull Listener listener, @NotNull @NlsContexts.Button String name, @NotNull Icon icon2) {
            if (button == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            if (listener == null) {
                MyActionButton.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyActionButton.$$$reportNull$$$0(2);
            }
            if (icon2 == null) {
                MyActionButton.$$$reportNull$$$0(3);
            }
            super(name, name, icon2);
            this.myButton = button;
            this.myListener = listener;
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionButton.$$$reportNull$$$0(4);
            }
            super.updateButton(e);
            if (!e.getPresentation().isEnabled()) {
                return;
            }
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                e.getPresentation().setEnabled(this.isEnabled() && this.isEnabled(size, min, max));
            }
        }

        protected abstract boolean isEnabled(int var1, int var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/CommonActionsPanel$MyActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        default public void doAdd() {
        }

        default public void doRemove() {
        }

        default public void doUp() {
        }

        default public void doDown() {
        }

        default public void doEdit() {
        }
    }

    public static enum Buttons {
        ADD(IconUtil.getAddIcon(), (Supplier)UIBundle.messagePointer("button.text.add", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener, String name, @NotNull Icon icon2) {
                if (listener == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new AddButton(listener, name == null ? this.getText() : name, icon2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$1";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        REMOVE(IconUtil.getRemoveIcon(), (Supplier)UIBundle.messagePointer("button.text.remove", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener, String name, @NotNull Icon icon2) {
                if (listener == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new RemoveButton(listener, name == null ? this.getText() : name, icon2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$2";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        EDIT(IconUtil.getEditIcon(), (Supplier)UIBundle.messagePointer("button.text.edit", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener, String name, @NotNull Icon icon2) {
                if (listener == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new EditButton(listener, name == null ? this.getText() : name, icon2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$3";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UP(IconUtil.getMoveUpIcon(), (Supplier)UIBundle.messagePointer("button.text.up", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener, String name, @NotNull Icon icon2) {
                if (listener == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                return new UpButton(listener, name == null ? this.getText() : name, icon2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$4";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DOWN(IconUtil.getMoveDownIcon(), (Supplier)UIBundle.messagePointer("button.text.down", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener, String name, @NotNull Icon icon2) {
                if (listener == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                return new DownButton(listener, name == null ? this.getText() : name, icon2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$5";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final Icon myIcon;
        private final @NotNull Supplier<@NlsContexts.Button String> myText;

        private Buttons(Icon icon2, Supplier<String> text2) {
            if (icon2 == null) {
                Buttons.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                Buttons.$$$reportNull$$$0(1);
            }
            this.myIcon = icon2;
            this.myText = text2;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myIcon;
            if (icon2 == null) {
                Buttons.$$$reportNull$$$0(2);
            }
            return icon2;
        }

        @NotNull
        abstract AnActionButton createButton(@NotNull Listener var1, @NlsContexts.Button String var2, @NotNull Icon var3);

        @NotNull
        @NlsContexts.Button
        public String getText() {
            String string = this.myText.get();
            if (string == null) {
                Buttons.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/CommonActionsPanel$Buttons";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/CommonActionsPanel$Buttons";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

