/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ErrorLabel
extends JLabel {
    private boolean myUnderline;
    private Color myForeground;
    private @NlsContexts.Tooltip String myTooltip;

    public ErrorLabel() {
        this(null, null);
    }

    public ErrorLabel(@NlsContexts.Label String text2) {
        this(text2, null);
    }

    public ErrorLabel(@NlsContexts.Label String text2, Icon icon2) {
        super(text2, icon2, 2);
        this.setOpaque(false);
    }

    public void setErrorText(@NlsContexts.Label String text2, Color color) {
        boolean newUnderline = text2 != null;
        this.myForeground = color;
        if (newUnderline) {
            this.updateLabelView(true, text2);
        } else if (this.myUnderline) {
            this.updateLabelView(false, this.myTooltip);
        }
    }

    @Override
    public void setToolTipText(@NlsContexts.Tooltip String text2) {
        if (this.myUnderline) {
            this.myTooltip = text2;
        } else {
            super.setToolTipText(text2);
        }
    }

    private void updateLabelView(boolean newUnderline, @NlsContexts.Tooltip String tooltip) {
        super.setToolTipText(tooltip);
        this.myUnderline = newUnderline;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String text2 = this.getText();
        if (text2 != null && this.myUnderline) {
            Border border;
            g.setColor(this.myForeground);
            int x = 0;
            Icon icon2 = this.getIcon();
            if (icon2 != null) {
                x = icon2.getIconWidth() + this.getIconTextGap();
            }
            if (this.getHorizontalAlignment() == 0) {
                int w = g.getFontMetrics().stringWidth(text2);
                x += this.getWidth() - x - w >> 1;
            }
            if ((border = this.getBorder()) != null) {
                Insets insets = border.getBorderInsets(this);
                if (insets.left != -1) {
                    x += insets.left;
                }
            }
            ErrorLabel.drawWave(this, g, x, text2);
        }
    }

    public static void drawWave(Component c, Graphics g, int x, String text2) {
        int line;
        int y = ErrorLabel.getTextBaseLine(c);
        int width = c.getFontMetrics(c.getFont()).stringWidth(text2);
        int nLines = (width >> 1) + 1;
        int xCurr = x;
        int yBottom = (y += 2) + 1;
        int[] xx = new int[nLines + 1];
        int[] yy = new int[nLines + 1];
        for (line = 0; line < nLines; line += 2) {
            xx[line] = xCurr;
            yy[line] = yBottom;
            xx[line + 1] = xCurr + 2;
            yy[line + 1] = yBottom - 2;
            xCurr += 4;
        }
        g.drawPolyline(xx, yy, line);
    }

    private static int getTextBaseLine(Component c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return (c.getHeight() >> 1) + (fm.getHeight() >> 1) - fm.getDescent();
    }
}

