/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class OptionGroup
implements PanelWithAnchor {
    private final @NlsContexts.BorderTitle String myTitle;
    private final List<Object> myOptions = new ArrayList<Object>();
    private final BitSet myIndented = new BitSet();
    private JComponent myAnchor;

    public OptionGroup() {
        this(null);
    }

    public OptionGroup(@Nullable @NlsContexts.BorderTitle String title) {
        this.myTitle = title;
    }

    public void add(JComponent component) {
        this.add(component, false);
    }

    public void add(JComponent component, boolean indented) {
        this.myOptions.add(component);
        this.myIndented.set(this.myOptions.size() - 1, indented);
    }

    public void add(JComponent leftComponent, JComponent rightComponent) {
        this.add(leftComponent, rightComponent, false);
    }

    public void add(JComponent leftComponent, JComponent rightComponent, boolean indented) {
        this.myOptions.add(Pair.pair((Object)leftComponent, (Object)rightComponent));
        this.myIndented.set(this.myOptions.size() - 1, indented);
    }

    public JPanel createPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        for (int i2 = 0; i2 < this.myOptions.size(); ++i2) {
            int top = i2 == 0 ? 0 : 4;
            int left = this.myIndented.get(i2) ? 20 : 0;
            Object option = this.myOptions.get(i2);
            if (option instanceof JComponent) {
                JComponent component = (JComponent)option;
                panel2.add((Component)component, new GridBagConstraints(0, i2, 0, 1, 1.0, 0.0, 17, OptionGroup.getFill(component), (Insets)JBUI.insets((int)top, (int)left, (int)0, (int)0), 0, 0));
                continue;
            }
            JComponent first = (JComponent)((Pair)option).first;
            panel2.add((Component)first, new GridBagConstraints(0, i2, 1, 1, 1.0, 0.0, 17, OptionGroup.getFill(first), (Insets)JBUI.insets((int)top, (int)left, (int)0, (int)0), 0, 0));
            JComponent second = (JComponent)((Pair)option).second;
            panel2.add((Component)second, new GridBagConstraints(1, i2, 1, 1, 1.0, 0.0, 13, 2, (Insets)JBUI.insets((int)top, (int)10, (int)0, (int)0), 0, 0));
            if (!(first instanceof JLabel)) continue;
            ((JLabel)first).setLabelFor(second);
        }
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(0, 0));
        panel2.add((Component)p, new GridBagConstraints(0, this.myOptions.size(), 0, 1, 0.0, 1.0, 11, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        if (this.myTitle != null) {
            IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder(this.myTitle, true);
            panel2.setBorder(titledBorder);
            titledBorder.acceptMinimumSize(panel2);
        }
        return panel2;
    }

    private static int getFill(JComponent component) {
        return component instanceof JCheckBox ? 0 : 2;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        for (Object o : this.myOptions) {
            if (!(o instanceof Pair) || !(((Pair)o).first instanceof AnchorableComponent)) continue;
            ((AnchorableComponent)((Pair)o).first).setAnchor(anchor);
        }
    }

    public JComponent[] getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (Object o : this.myOptions) {
            if (o instanceof Pair) {
                components.add((JComponent)((Pair)o).first);
                components.add((JComponent)((Pair)o).second);
                continue;
            }
            components.add((JComponent)o);
        }
        return components.toArray(new JComponent[0]);
    }

    @Nullable
    public JComponent findAnchor() {
        double maxWidth = -1.0;
        JComponent anchor = null;
        for (Object o : this.myOptions) {
            JComponent component;
            if (!(o instanceof Pair) || !(((Pair)o).first instanceof AnchorableComponent) || !(((Pair)o).first instanceof JComponent) || !((component = (JComponent)((Pair)o).first).getPreferredSize().getWidth() > maxWidth)) continue;
            maxWidth = component.getPreferredSize().getWidth();
            anchor = component;
        }
        return anchor;
    }
}

