/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressBarLoadingDecorator
extends LoadingDecorator {
    private final AtomicBoolean loadingStarted;
    private JProgressBar myProgressBar;

    public ProgressBarLoadingDecorator(@NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
        if (contentPanel == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(1);
        }
        super(contentPanel, disposable, startDelayMs, true);
        this.loadingStarted = new AtomicBoolean(false);
    }

    @Override
    protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text2, AsyncProcessIcon icon2) {
        parent.setLayout(new BorderLayout());
        NonOpaquePanel result = new NonOpaquePanel();
        result.setLayout(new BoxLayout(result, 1));
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setIndeterminate(true);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 2);
        this.myProgressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        result.add(this.myProgressBar);
        parent.add((Component)result, this.isOnTop() ? "North" : "South");
        return result;
    }

    protected boolean isOnTop() {
        return true;
    }

    @NotNull
    public JProgressBar getProgressBar() {
        JProgressBar jProgressBar = this.myProgressBar;
        if (jProgressBar == null) {
            ProgressBarLoadingDecorator.$$$reportNull$$$0(2);
        }
        return jProgressBar;
    }

    @Override
    public void startLoading(boolean takeSnapshot) {
        if (this.loadingStarted.compareAndSet(false, true)) {
            super.startLoading(takeSnapshot);
        }
    }

    public void startLoading() {
        this.startLoading(false);
    }

    @Override
    public void stopLoading() {
        if (this.loadingStarted.compareAndSet(true, false)) {
            super.stopLoading();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/ProgressBarLoadingDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/ProgressBarLoadingDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

