/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.scale.JBUIScale;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public interface ExtendableTextComponent {
    public static final String VARIANT = "extendable";

    public List<Extension> getExtensions();

    public void setExtensions(Extension ... var1);

    public void setExtensions(Collection<? extends Extension> var1);

    public void addExtension(@NotNull Extension var1);

    public void removeExtension(@NotNull Extension var1);

    public static interface Extension {
        public Icon getIcon(boolean var1);

        default public int getIconGap() {
            return JBUIScale.scale((int)5);
        }

        default public int getPreferredSpace() {
            Icon icon1 = this.getIcon(true);
            Icon icon2 = this.getIcon(false);
            if (icon1 == null && icon2 == null) {
                return 0;
            }
            if (icon1 == null) {
                return this.getIconGap() + icon2.getIconWidth();
            }
            if (icon2 == null) {
                return this.getIconGap() + icon1.getIconWidth();
            }
            return this.getIconGap() + Math.max(icon1.getIconWidth(), icon2.getIconWidth());
        }

        default public int getAfterIconOffset() {
            return 0;
        }

        default public boolean isIconBeforeText() {
            return false;
        }

        default public Runnable getActionOnClick() {
            return null;
        }

        @NlsContexts.Tooltip
        default public String getTooltip() {
            return null;
        }

        public static Extension create(@NotNull Icon icon2, @NlsContexts.Tooltip String tooltip, Runnable action) {
            if (icon2 == null) {
                Extension.$$$reportNull$$$0(0);
            }
            return Extension.create(icon2, icon2, tooltip, action);
        }

        public static Extension create(final @NotNull Icon defaultIcon, final @NotNull Icon hoveredIcon, final @NlsContexts.Tooltip String tooltip, final Runnable action) {
            if (defaultIcon == null) {
                Extension.$$$reportNull$$$0(1);
            }
            if (hoveredIcon == null) {
                Extension.$$$reportNull$$$0(2);
            }
            return new Extension(){

                @Override
                public Icon getIcon(boolean hovered) {
                    return hovered ? hoveredIcon : defaultIcon;
                }

                @Override
                public String getTooltip() {
                    return tooltip;
                }

                @Override
                public Runnable getActionOnClick() {
                    return action;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hoveredIcon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/components/fields/ExtendableTextComponent$Extension";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

