/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.util.animation.Animations;
import com.intellij.util.animation.DoubleIntFunction;
import java.awt.Color;
import java.util.function.DoubleFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/animation/DoubleColorFunction;", "Ljava/util/function/DoubleFunction;", "Ljava/awt/Color;", "from", "to", "(Ljava/awt/Color;Ljava/awt/Color;)V", "alpha", "Lcom/intellij/util/animation/DoubleIntFunction;", "blue", "getFrom", "()Ljava/awt/Color;", "green", "red", "getTo", "apply", "value", "", "intellij.platform.ide"})
public final class DoubleColorFunction
implements DoubleFunction<Color> {
    private final DoubleIntFunction red;
    private final DoubleIntFunction green;
    private final DoubleIntFunction blue;
    private final DoubleIntFunction alpha;
    @NotNull
    private final Color from;
    @NotNull
    private final Color to;

    @Override
    @NotNull
    public Color apply(double value2) {
        return new Color(this.red.apply(value2), this.green.apply(value2), this.blue.apply(value2), this.alpha.apply(value2));
    }

    @NotNull
    public final Color getFrom() {
        return this.from;
    }

    @NotNull
    public final Color getTo() {
        return this.to;
    }

    public DoubleColorFunction(@NotNull Color from, @NotNull Color to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.from = from;
        this.to = to;
        this.red = Animations.access$range(this.from.getRed(), this.to.getRed());
        this.green = Animations.access$range(this.from.getGreen(), this.to.getGreen());
        this.blue = Animations.access$range(this.from.getBlue(), this.to.getBlue());
        this.alpha = Animations.access$range(this.from.getAlpha(), this.to.getAlpha());
    }
}

