/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.JavacOutputParser;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.text.StringTokenizer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputParser {
    @NonNls
    private static final String JAVAC = "javac";
    private static final Logger LOG = Logger.getInstance(OutputParser.class);
    private final Project myProject;
    private final AntBuildMessageView myMessageView;
    private final WeakReference<ProgressIndicator> myProgress;
    @Nls
    private final String myBuildName;
    private final OSProcessHandler myProcessHandler;
    private volatile boolean isStopped;
    private List<String> myJavacMessages;
    private boolean myFirstLineProcessed;
    private boolean myStartedSuccessfully;

    public OutputParser(Project project, OSProcessHandler processHandler, AntBuildMessageView errorsView, ProgressIndicator progress, @Nls String buildName) {
        this.myProject = project;
        this.myProcessHandler = processHandler;
        this.myMessageView = errorsView;
        this.myProgress = new WeakReference<ProgressIndicator>(progress);
        this.myBuildName = buildName;
        this.myMessageView.setParsingThread(this);
    }

    public final void stopProcess() {
        this.myProcessHandler.destroyProcess();
    }

    public boolean isTerminateInvoked() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected OSProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    public final void setStopped(boolean stopped) {
        this.isStopped = stopped;
    }

    private void setProgressStatistics(@NlsContexts.ProgressText String s) {
        ProgressIndicator progress = (ProgressIndicator)this.myProgress.get();
        if (progress != null) {
            progress.setText2(s);
        }
    }

    private void setProgressText(@NlsContexts.ProgressText String s) {
        ProgressIndicator progress = (ProgressIndicator)this.myProgress.get();
        if (progress != null) {
            progress.setText(s);
        }
    }

    private void printRawError(@Nls String text) {
        this.myMessageView.outputError(text, 0);
    }

    public final void readErrorOutput(@NlsSafe String text) {
        if (!this.myFirstLineProcessed) {
            this.myFirstLineProcessed = true;
            this.myStartedSuccessfully = false;
            this.myMessageView.buildFailed(this.myBuildName);
        }
        if (!this.myStartedSuccessfully) {
            this.printRawError(text);
        }
    }

    protected final void processTag(char tagName, @NlsSafe String tagValue, @AntMessage.Priority int priority) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(tagName) + priority + "=" + tagValue);
        }
        if ('G' == tagName) {
            this.setProgressStatistics(AntBundle.message("target.tag.name.status.text", tagValue));
        } else if ('T' == tagName) {
            this.setProgressText(AntBundle.message("executing.task.tag.value.status.text", tagValue));
            if (JAVAC.equals(tagValue)) {
                this.myJavacMessages = new ArrayList<String>();
            }
        }
        if (this.myJavacMessages != null && ('M' == tagName || 'E' == tagName)) {
            this.myJavacMessages.add(tagValue);
            return;
        }
        if ('M' == tagName) {
            this.myMessageView.outputMessage(tagValue, priority);
        } else if ('G' == tagName) {
            this.myMessageView.startTarget(tagValue);
        } else if ('T' == tagName) {
            this.myMessageView.startTask(tagValue);
        } else if ('E' == tagName) {
            this.myMessageView.outputError(tagValue, priority);
        } else if ('X' == tagName) {
            String exceptionText = tagValue.replace('\u0000', '\n');
            this.myMessageView.outputException(exceptionText);
        } else if ('B' == tagName) {
            this.myMessageView.startBuild(this.myBuildName);
        } else if ('g' == tagName || 't' == tagName) {
            List<String> javacMessages = this.myJavacMessages;
            this.myJavacMessages = null;
            OutputParser.processJavacMessages(javacMessages, this.myMessageView, this.myProject);
            if ('g' == tagName) {
                this.myMessageView.finishTarget();
            } else {
                this.myMessageView.finishTask();
            }
        }
    }

    @AntMessage.Priority
    static int fixPriority(int priority) {
        if (priority == 0 || priority == 1 || priority == 2 || priority == 3 || priority == 4) {
            return priority;
        }
        return 3;
    }

    private static void processJavacMessages(final List<String> javacMessages, final AntBuildMessageView messageView, final Project project) {
        if (javacMessages == null) {
            return;
        }
        JavacOutputParser outputParser = new JavacOutputParser(project);
        OutputParser.Callback callback = new OutputParser.Callback(){
            private int myIndex = -1;

            @Nullable
            public String getCurrentLine() {
                if (this.myIndex >= javacMessages.size()) {
                    return null;
                }
                return (String)javacMessages.get(this.myIndex);
            }

            public String getNextLine() {
                int next;
                int size = javacMessages.size();
                this.myIndex = next = Math.min(this.myIndex + 1, javacMessages.size());
                if (next >= size) {
                    return null;
                }
                return (String)javacMessages.get(next);
            }

            public void pushBack(String line) {
                --this.myIndex;
            }

            public void message(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
                StringTokenizer tokenizer = new StringTokenizer(message, "\n", false);
                String[] strings = new String[tokenizer.countTokens()];
                int idx = 0;
                while (tokenizer.hasMoreTokens()) {
                    strings[idx] = tokenizer.nextToken();
                    ++idx;
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    VirtualFile file = url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                    messageView.outputJavacMessage(OutputParser.convertCategory(category), strings, file, url, lineNum, columnNum);
                    if (file != null && category == CompilerMessageCategory.ERROR) {
                        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project);
                        Problem problem = wolf.convertToProblem(file, lineNum, columnNum, strings);
                        wolf.weHaveGotNonIgnorableProblems(file, Collections.singletonList(problem));
                    }
                });
            }

            public void setProgressText(String text) {
            }

            public void fileProcessed(String path) {
            }

            public void fileGenerated(String path) {
            }
        };
        try {
            while (outputParser.processMessageLine(callback)) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static AntBuildMessageView.MessageType convertCategory(CompilerMessageCategory category) {
        if (CompilerMessageCategory.ERROR.equals((Object)category)) {
            return AntBuildMessageView.MessageType.ERROR;
        }
        return AntBuildMessageView.MessageType.MESSAGE;
    }
}

