/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.ReflectedProject;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.dom.AntDomDefaultTargetConverter;
import com.intellij.lang.ant.dom.AntDomImport;
import com.intellij.lang.ant.dom.AntDomInclude;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.SubTagList;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DefinesXml
public abstract class AntDomProject
extends AntDomNamedElement
implements PropertiesProvider {
    private static final Logger LOG = Logger.getInstance(AntDomProject.class);
    @NonNls
    public static final String DEFAULT_ENVIRONMENT_PREFIX = "env.";
    private volatile ClassLoader myClassLoader;
    private volatile Map<String, String> myProperties;

    @Attribute(value="default")
    @Convert(value=AntDomDefaultTargetConverter.class)
    public abstract GenericAttributeValue<TargetResolver.Result> getDefaultTarget();

    @Attribute(value="basedir")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getBasedir();

    @Nullable
    public final PsiFileSystemItem getProjectBasedir() {
        PsiFileSystemItem basedir = (PsiFileSystemItem)this.getBasedir().getValue();
        if (basedir != null) {
            return basedir;
        }
        XmlTag tag = this.getXmlTag();
        VirtualFile containingFile = tag.getContainingFile().getOriginalFile().getVirtualFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile parent = containingFile.getParent();
        if (parent == null) {
            return null;
        }
        return tag.getManager().findDirectory(parent);
    }

    @Nullable
    @NlsSafe
    public final String getProjectBasedirPath() {
        File file;
        String basedir = this.getBasedir().getStringValue();
        if (basedir != null && (file = new File(basedir)).isAbsolute()) {
            try {
                return FileUtil.toSystemIndependentName((String)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        String selfDir = this.getContainingFileDir();
        if (basedir == null) {
            return selfDir;
        }
        try {
            return FileUtil.toSystemIndependentName((String)new File(selfDir, basedir).getCanonicalPath());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    @NlsSafe
    public final String getContainingFileDir() {
        VirtualFile containingFile = this.getXmlTag().getContainingFile().getOriginalFile().getVirtualFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile parent = containingFile.getParent();
        return parent != null ? parent.getPath() : null;
    }

    @SubTagList(value="target")
    public abstract List<AntDomTarget> getDeclaredTargets();

    @SubTagList(value="import")
    public abstract List<AntDomImport> getDeclaredImports();

    @SubTagList(value="include")
    public abstract List<AntDomInclude> getDeclaredIncludes();

    @Nullable
    public final AntDomTarget findDeclaredTarget(String declaredName) {
        for (AntDomTarget target : this.getDeclaredTargets()) {
            if (!declaredName.equals(target.getName().getRawText())) continue;
            return target;
        }
        return null;
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader loader = this.myClassLoader;
        if (loader == null) {
            XmlTag tag = this.getXmlTag();
            PsiFile containingFile = tag.getContainingFile();
            AntBuildFileImpl buildFile = (AntBuildFileImpl)AntConfigurationBase.getInstance(containingFile.getProject()).getAntBuildFile(containingFile);
            if (buildFile != null) {
                loader = buildFile.getClassLoader();
            } else {
                AntInstallation antInstallation = this.getAntInstallation();
                loader = antInstallation.getClassLoader();
            }
            this.myClassLoader = loader;
        }
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            AntDomProject.$$$reportNull$$$0(0);
        }
        return classLoader;
    }

    public AntInstallation getAntInstallation() {
        AntConfigurationBase configuration = AntConfigurationBase.getInstance(this.getManager().getProject());
        AntInstallation antInstallation = null;
        if (configuration != null) {
            antInstallation = configuration.getProjectDefaultAnt();
        }
        if (antInstallation == null) {
            antInstallation = GlobalAntConfiguration.getInstance().getBundledAnt();
        }
        assert (antInstallation != null);
        return antInstallation;
    }

    @Nullable
    public final Sdk getTargetJdk() {
        XmlTag tag = this.getXmlTag();
        PsiFile containingFile = tag.getContainingFile();
        AntBuildFileImpl buildFile = (AntBuildFileImpl)AntConfigurationBase.getInstance(containingFile.getProject()).getAntBuildFile(containingFile);
        if (buildFile != null) {
            String jdkName = (String)AntBuildFileImpl.CUSTOM_JDK_NAME.get(buildFile.getAllOptions());
            if (StringUtil.isEmptyOrSpaces((String)jdkName)) {
                jdkName = (String)AntConfigurationImpl.DEFAULT_JDK_NAME.get(buildFile.getAllOptions());
            }
            if (!StringUtil.isEmptyOrSpaces((String)jdkName)) {
                return ProjectJdkTable.getInstance().findJdk(jdkName);
            }
        }
        return ProjectRootManager.getInstance((Project)tag.getProject()).getProjectSdk();
    }

    @Override
    @NotNull
    public Iterator<String> getNamesIterator() {
        Iterator<String> iterator = this.getProperties().keySet().iterator();
        if (iterator == null) {
            AntDomProject.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    @Override
    @Nullable
    public String getPropertyValue(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    @Override
    @Nullable
    public PsiElement getNavigationElement(String propertyName) {
        PsiElement nameElementPsi;
        DomTarget target = DomTarget.getTarget((DomElement)this);
        PsiElement psiElement = nameElementPsi = target != null ? PomService.convertToPsi((PsiTarget)target) : null;
        if (nameElementPsi != null) {
            return nameElementPsi;
        }
        XmlElement xmlElement = this.getXmlElement();
        return xmlElement != null ? xmlElement.getNavigationElement() : null;
    }

    private Map<String, String> getProperties() {
        Map<String, String> properties = this.myProperties;
        if (properties == null) {
            AntBuildFileImpl buildFile;
            ReflectedProject reflected = ReflectedProject.getProject(this.getClassLoader());
            Map<String, String> externals = Collections.emptyMap();
            PsiFile containingFile = this.getXmlTag().getContainingFile();
            if (containingFile != null && (buildFile = (AntBuildFileImpl)AntConfigurationBase.getInstance(containingFile.getProject()).getAntBuildFile(containingFile)) != null) {
                externals = buildFile.getExternalProperties();
            }
            this.myProperties = properties = this.loadPredefinedProperties(reflected.getProperties(), externals);
        }
        return properties;
    }

    private Map<String, String> loadPredefinedProperties(Map<String, String> properties, Map<String, String> externalProps) {
        String containingFileDir;
        String basedir;
        HashMap<String, String> destination = new HashMap<String, String>();
        if (properties != null) {
            properties.forEach((name, value) -> AntDomProject.appendProperty(destination, name, value));
        }
        if (externalProps != null) {
            externalProps.forEach((name, value) -> AntDomProject.appendProperty(destination, name, value));
        }
        if ((basedir = this.getProjectBasedirPath()) == null) {
            basedir = ".";
        }
        if (!FileUtil.isAbsolute((String)basedir) && (containingFileDir = this.getContainingFileDir()) != null) {
            try {
                basedir = new File(containingFileDir, basedir).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AntDomProject.appendProperty(destination, "basedir", FileUtil.toSystemIndependentName((String)basedir));
        AntInstallation installation = this.getAntInstallation();
        String homeDir = installation.getHomeDir();
        if (homeDir != null) {
            AntDomProject.appendProperty(destination, "ant.home", FileUtil.toSystemIndependentName((String)homeDir));
        }
        AntDomProject.appendProperty(destination, "ant.version", installation.getVersion());
        String projectName = this.getName().getRawText();
        AntDomProject.appendProperty(destination, "ant.project.name", projectName == null ? "" : projectName);
        Sdk jdkToRunWith = this.getTargetJdk();
        String version = jdkToRunWith != null ? jdkToRunWith.getVersionString() : null;
        AntDomProject.appendProperty(destination, "ant.java.version", version != null ? version : SystemInfo.JAVA_VERSION);
        VirtualFile containingFile = this.getXmlTag().getContainingFile().getOriginalFile().getVirtualFile();
        if (containingFile != null) {
            String antFilePath = containingFile.getPath();
            AntDomProject.appendProperty(destination, "ant.file", antFilePath);
            if (projectName != null) {
                AntDomProject.appendProperty(destination, "ant.file." + projectName, antFilePath);
                AntDomProject.appendProperty(destination, "ant.file.type." + projectName, "file");
            }
        }
        return destination;
    }

    private static void appendProperty(Map<String, String> map, String name, String value) {
        map.putIfAbsent(name, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/ant/dom/AntDomProject";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesIterator";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

